/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.lb.policy;

import java.lang.reflect.Method;
import java.util.List;
import org.ow2.carol.cmi.controller.common.ClusterViewManager;
import org.ow2.carol.cmi.lb.LoadBalanceable;
import org.ow2.carol.cmi.lb.NoLoadBalanceableException;
import org.ow2.carol.cmi.lb.decision.BasicDecisionManager;
import org.ow2.carol.cmi.lb.decision.DecisionUtil;
import org.ow2.carol.cmi.lb.policy.ILBPolicy;
import org.ow2.carol.cmi.lb.strategy.ILBStrategy;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbsLBPolicy<T extends LoadBalanceable>
implements ILBPolicy<T> {
    private static final Log LOGGER = LogFactory.getLog(AbsLBPolicy.class);
    private ClusterViewManager clusterViewManager;
    private ILBStrategy<T> lbStrategy = null;

    public AbsLBPolicy() {
        this.clusterViewManager = null;
    }

    public AbsLBPolicy(ClusterViewManager clusterViewManager) {
        this.clusterViewManager = clusterViewManager;
    }

    @Override
    public abstract T choose(List<T> var1) throws NoLoadBalanceableException;

    public BasicDecisionManager<Void> onInvokeException(Method method, Object[] parameters, T loadBalanceable, Throwable thr) {
        if (DecisionUtil.mustFailoverOnInvoke(thr, this.clusterViewManager, loadBalanceable)) {
            return BasicDecisionManager.doRetry();
        }
        return BasicDecisionManager.doThrow();
    }

    @Override
    public <ReturnType> BasicDecisionManager<ReturnType> onReturn(Method method, Object[] parameters, T loadBalanceable, ReturnType retVal) {
        LOGGER.debug((Object)"onReturn: do nothing !", new Object[0]);
        return BasicDecisionManager.doReturn(retVal);
    }

    public BasicDecisionManager<Void> onLookupException(T loadBalanceable, Throwable thr) {
        if (DecisionUtil.mustFailoverOnLookup(thr, this.clusterViewManager, loadBalanceable)) {
            return BasicDecisionManager.doRetry();
        }
        return BasicDecisionManager.doThrow();
    }

    @Override
    public synchronized void setLBStrategy(ILBStrategy<T> lbStrategy) {
        this.lbStrategy = lbStrategy;
    }

    @Override
    public ILBStrategy<T> getLBStrategy() {
        return this.lbStrategy;
    }

    public void setClusterViewManager(ClusterViewManager clusterViewManager) {
        this.clusterViewManager = clusterViewManager;
    }
}

