/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.rpc;

import org.ow2.carol.cmi.controller.common.ClusterViewManager;
import org.ow2.carol.cmi.reference.CMIReference;
import org.ow2.carol.cmi.reference.CMIReferenceable;
import org.ow2.carol.cmi.rpc.CMIInvocationHandler;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CMIInvocationHandlerByPool<T>
extends CMIInvocationHandler<T> {
    private static final Log LOGGER = LogFactory.getLog(CMIInvocationHandlerByPool.class);

    protected CMIInvocationHandlerByPool(ClusterViewManager clusterViewManager, String objectName, String protocolName, boolean keepCurrentRef, Class<? extends T> itf) {
        super(clusterViewManager, objectName, protocolName, keepCurrentRef, itf);
    }

    @Override
    protected CMIReferenceable<T> getCMIReferenceable(CMIReference cmiReference) throws Exception {
        return (CMIReferenceable)this.clusterViewManager.getPool(this.objectName).get((Object)cmiReference);
    }

    @Override
    protected void onExceptionHook(String objectName, CMIReferenceable<T> cmiReferenceable) throws Exception {
        try {
            this.clusterViewManager.getPool(objectName).discard(cmiReferenceable);
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Cannot discard the reference {0}", new Object[]{cmiReferenceable, e});
        }
    }

    @Override
    protected void onFinallyHook(String objectName, CMIReferenceable<T> cmiReferenceable) {
        try {
            this.clusterViewManager.getPool(objectName).release(cmiReferenceable);
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Cannot release the reference {0}", new Object[]{cmiReferenceable, e});
        }
    }
}

