/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ICUBinary;
import com.ibm.icu.impl.ICUDebug;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

final class NormalizerDataReader
implements ICUBinary.Authenticate {
    private static final boolean debug = ICUDebug.enabled("NormalizerDataReader");
    private DataInputStream dataInputStream;
    private static final byte[] DATA_FORMAT_ID = new byte[]{78, 111, 114, 109};
    private static final byte[] DATA_FORMAT_VERSION = new byte[]{2, 2, 5, 2};

    protected NormalizerDataReader(InputStream inputStream) throws IOException {
        if (debug) {
            System.out.println("Bytes in inputStream " + inputStream.available());
        }
        ICUBinary.readHeader(inputStream, DATA_FORMAT_ID, this);
        if (debug) {
            System.out.println("Bytes left in inputStream " + inputStream.available());
        }
        this.dataInputStream = new DataInputStream(inputStream);
        if (debug) {
            System.out.println("Bytes left in dataInputStream " + this.dataInputStream.available());
        }
    }

    protected int[] readIndexes(int length) throws IOException {
        int[] indexes = new int[length];
        int i = 0;
        while (i < length) {
            indexes[i] = this.dataInputStream.readInt();
            ++i;
        }
        return indexes;
    }

    protected void read(byte[] normBytes, byte[] fcdBytes, byte[] auxBytes, char[] extraData, char[] combiningTable, Object[] canonStartSets) throws IOException {
        this.dataInputStream.read(normBytes);
        int i = 0;
        while (i < extraData.length) {
            extraData[i] = this.dataInputStream.readChar();
            ++i;
        }
        int i2 = 0;
        while (i2 < combiningTable.length) {
            combiningTable[i2] = this.dataInputStream.readChar();
            ++i2;
        }
        this.dataInputStream.read(fcdBytes);
        this.dataInputStream.read(auxBytes);
        int[] canonStartSetsIndexes = new int[32];
        int i3 = 0;
        while (i3 < canonStartSetsIndexes.length) {
            canonStartSetsIndexes[i3] = this.dataInputStream.readChar();
            ++i3;
        }
        char[] startSets = new char[canonStartSetsIndexes[0] - 32];
        int i4 = 0;
        while (i4 < startSets.length) {
            startSets[i4] = this.dataInputStream.readChar();
            ++i4;
        }
        char[] bmpTable = new char[canonStartSetsIndexes[1]];
        int i5 = 0;
        while (i5 < bmpTable.length) {
            bmpTable[i5] = this.dataInputStream.readChar();
            ++i5;
        }
        char[] suppTable = new char[canonStartSetsIndexes[2]];
        int i6 = 0;
        while (i6 < suppTable.length) {
            suppTable[i6] = this.dataInputStream.readChar();
            ++i6;
        }
        canonStartSets[0] = canonStartSetsIndexes;
        canonStartSets[1] = startSets;
        canonStartSets[2] = bmpTable;
        canonStartSets[3] = suppTable;
    }

    public byte[] getDataFormatVersion() {
        return DATA_FORMAT_VERSION;
    }

    public boolean isDataVersionAcceptable(byte[] version2) {
        return version2[0] == DATA_FORMAT_VERSION[0] && version2[2] == DATA_FORMAT_VERSION[2] && version2[3] == DATA_FORMAT_VERSION[3];
    }
}

