/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.CharTrie;
import com.ibm.icu.impl.NormalizerImpl;
import com.ibm.icu.impl.Trie;
import com.ibm.icu.impl.TrieIterator;
import com.ibm.icu.impl.UCharacterPropertyReader;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.UCharacterIterator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.RangeValueIterator;
import com.ibm.icu.util.VersionInfo;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;

public final class UCharacterProperty
implements Trie.DataManipulate {
    public CharTrie m_trie_;
    public char[] m_trieIndex_;
    public char[] m_trieData_;
    public int m_trieInitialValue_;
    public int[] m_property_;
    public VersionInfo m_unicodeVersion_;
    public static final int EXC_UPPERCASE_ = 0;
    public static final int EXC_LOWERCASE_ = 1;
    public static final int EXC_TITLECASE_ = 2;
    public static final int EXC_UNUSED_ = 3;
    public static final int EXC_NUMERIC_VALUE_ = 4;
    public static final int EXC_DENOMINATOR_VALUE_ = 5;
    public static final int EXC_MIRROR_MAPPING_ = 6;
    public static final int EXC_SPECIAL_CASING_ = 7;
    public static final int EXC_CASE_FOLDING_ = 8;
    public static final int EXC_COMBINING_CLASS_ = 9;
    public static final int MAX_CASE_MAP_SIZE = 10;
    public static final String TURKISH_ = "tr";
    public static final String AZERBAIJANI_ = "az";
    public static final String LITHUANIAN_ = "lt";
    public static final char LATIN_CAPITAL_LETTER_I_WITH_DOT_ABOVE_ = '\u0130';
    public static final char LATIN_SMALL_LETTER_DOTLESS_I_ = '\u0131';
    public static final char LATIN_SMALL_LETTER_I_ = 'i';
    public static final int TYPE_MASK = 31;
    public static final int EXCEPTION_MASK = 32;
    public static final int MIRROR_MASK = 2048;
    static final int MY_MASK = 30;
    private static final long UNSIGNED_INT_MASK = 0xFFFFFFFFL;
    BinaryProperties[] binProps = new BinaryProperties[]{new BinaryProperties(1, 1024L), new BinaryProperties(1, 512L), new BinaryProperties(1, 2L), new BinaryProperties(-1, 2048L), new BinaryProperties(1, 8L), new BinaryProperties(1, 0x800000L), new BinaryProperties(1, 0x1000000L), new BinaryProperties(1, 4096L), new BinaryProperties(1, 8192L), new BinaryProperties(0, 0L), new BinaryProperties(1, Integer.MIN_VALUE), new BinaryProperties(1, 131072L), new BinaryProperties(1, 262144L), new BinaryProperties(1, 256L), new BinaryProperties(1, 16L), new BinaryProperties(1, 0x40000000L), new BinaryProperties(1, 0x20000000L), new BinaryProperties(1, 2048L), new BinaryProperties(1, 524288L), new BinaryProperties(1, 0x100000L), new BinaryProperties(1, 4L), new BinaryProperties(1, 0x4000000L), new BinaryProperties(1, 16384L), new BinaryProperties(1, 128L), new BinaryProperties(1, 65536L), new BinaryProperties(1, 32L), new BinaryProperties(1, 0x200000L), new BinaryProperties(1, 0x2000000L), new BinaryProperties(1, 64L), new BinaryProperties(1, 0x400000L), new BinaryProperties(1, 32768L), new BinaryProperties(1, 1L), new BinaryProperties(1, 0x10000000L), new BinaryProperties(1, 0x8000000L), new BinaryProperties(-1, 32768L)};
    char[] m_case_;
    int[] m_exception_;
    CharTrie m_additionalTrie_;
    int[] m_additionalVectors_;
    int m_additionalColumnsCount_;
    int m_maxBlockScriptValue_;
    int m_maxJTGValue_;
    private static UCharacterProperty INSTANCE_ = null;
    private static final String DATA_FILE_NAME_ = "data/uprops.icu";
    private static final int DATA_BUFFER_SIZE_ = 25000;
    private static final int EXC_GROUP_ = 8;
    private static final int EXC_GROUP_MASK_ = 255;
    private static final int EXC_DIGIT_MASK_ = 65535;
    private static final byte[] FLAGS_OFFSET_ = new byte[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8};
    private static final int VALUE_SHIFT_ = 20;
    private static final int UNSIGNED_VALUE_MASK_AFTER_SHIFT_ = 2047;
    private static final int RESERVED_SHIFT_ = 15;
    private static final int BIDI_SHIFT_ = 6;
    private static final int MIRROR_SHIFT_ = 11;
    private static final int NUMERIC_TYPE_SHIFT = 12;
    private static final int CASE_SENSITIVE_SHIFT_ = 15;
    private static final int EXCEPTION_BIT = 32;
    private static final int VALUE_BITS_ = 65516;
    private static final int MIN_VALUE_ = -2048;
    private static final int MAX_VALUE_ = 2047;
    private static int MAX_EXCEPTIONS_COUNT_ = 4096;
    private static final int LAST_5_BIT_MASK_ = 31;
    private static final int SHIFT_5_ = 5;
    private static final int SHIFT_10_ = 10;
    private static final int SUPPLEMENTARY_FOLD_INDICATOR_MASK_ = 32768;
    private static final int SUPPLEMENTARY_FOLD_OFFSET_MASK_ = Short.MAX_VALUE;
    private static final int LEAD_SURROGATE_SHIFT_ = 10;
    private static final int SURROGATE_OFFSET_ = -56613888;
    private static final char LATIN_CAPITAL_LETTER_I_ = 'I';
    private static final char COMBINING_DOT_ABOVE_ = '\u0307';
    private static final int LATIN_SMALL_LETTER_J_ = 106;
    private static final int LATIN_SMALL_LETTER_I_WITH_OGONEK_ = 303;
    private static final int LATIN_SMALL_LETTER_I_WITH_TILDE_BELOW_ = 7725;
    private static final int LATIN_SMALL_LETTER_I_WITH_DOT_BELOW_ = 7883;
    private static final int COMBINING_MARK_ABOVE_CLASS_ = 230;
    private static final int LATIN_CAPITAL_LETTER_J_ = 74;
    private static final int LATIN_CAPITAL_I_WITH_OGONEK_ = 302;
    private static final int LATIN_CAPITAL_I_WITH_TILDE_ = 296;
    private static final int LATIN_CAPITAL_I_WITH_GRAVE_ = 204;
    private static final int LATIN_CAPITAL_I_WITH_ACUTE_ = 205;
    private static final int COMBINING_GRAVE_ACCENT_ = 768;
    private static final int COMBINING_ACUTE_ACCENT_ = 769;
    private static final int COMBINING_TILDE_ = 771;
    private static final char GREEK_CAPITAL_LETTER_SIGMA_ = '\u03a3';
    private static final char GREEK_SMALL_LETTER_SIGMA_ = '\u03c3';
    private static final char GREEK_SMALL_LETTER_RHO_ = '\u03c2';
    private static final int HYPHEN_ = 8208;
    private static final int SOFT_HYPHEN_ = 173;
    private static final int LAST_CHAR_MASK_ = 65535;
    private static final int LAST_BYTE_MASK_ = 255;
    private static final int SHIFT_16_ = 16;
    private static final int WHITE_SPACE_PROPERTY_ = 0;
    private static final int BIDI_CONTROL_PROPERTY_ = 1;
    private static final int JOIN_CONTROL_PROPERTY_ = 2;
    private static final int DASH_PROPERTY_ = 3;
    private static final int HYPHEN_PROPERTY_ = 4;
    private static final int QUOTATION_MARK_PROPERTY_ = 5;
    private static final int TERMINAL_PUNCTUATION_PROPERTY_ = 6;
    private static final int MATH_PROPERTY_ = 7;
    private static final int HEX_DIGIT_PROPERTY_ = 8;
    private static final int ASCII_HEX_DIGIT_PROPERTY_ = 9;
    private static final int ALPHABETIC_PROPERTY_ = 10;
    private static final int IDEOGRAPHIC_PROPERTY_ = 11;
    private static final int DIACRITIC_PROPERTY_ = 12;
    private static final int EXTENDER_PROPERTY_ = 13;
    private static final int LOWERCASE_PROPERTY_ = 14;
    private static final int UPPERCASE_PROPERTY_ = 15;
    private static final int NONCHARACTER_CODE_POINT_PROPERTY_ = 16;
    private static final int GRAPHEME_EXTEND_PROPERTY_ = 17;
    private static final int GRAPHEME_LINK_PROPERTY_ = 18;
    private static final int IDS_BINARY_OPERATOR_PROPERTY_ = 19;
    private static final int IDS_TRINARY_OPERATOR_PROPERTY_ = 20;
    private static final int RADICAL_PROPERTY_ = 21;
    private static final int UNIFIED_IDEOGRAPH_PROPERTY_ = 22;
    private static final int DEFAULT_IGNORABLE_CODE_POINT_PROPERTY_ = 23;
    private static final int DEPRECATED_PROPERTY_ = 24;
    private static final int SOFT_DOTTED_PROPERTY_ = 25;
    private static final int LOGICAL_ORDER_EXCEPTION_PROPERTY_ = 26;
    private static final int XID_START_PROPERTY_ = 27;
    private static final int XID_CONTINUE_PROPERTY_ = 28;
    private static final int ID_START_PROPERTY_ = 29;
    private static final int ID_CONTINUE_PROPERTY_ = 30;
    private static final int GRAPHEME_BASE_PROPERTY_ = 31;
    private static final int BINARY_1_TOP_PROPERTY_ = 32;
    private static final int FIRST_NIBBLE_SHIFT_ = 4;
    private static final int LAST_NIBBLE_MASK_ = 15;
    private static final int AGE_SHIFT_ = 24;
    private static final int TAB = 9;
    private static final int LF = 10;
    private static final int FF = 12;
    private static final int CR = 13;
    private static final int U_A = 65;
    private static final int U_Z = 90;
    private static final int U_a = 97;
    private static final int U_z = 122;
    private static final int DEL = 127;
    private static final int NL = 133;
    private static final int NBSP = 160;
    private static final int CGJ = 847;
    private static final int FIGURESP = 8199;
    private static final int HAIRSP = 8202;
    private static final int ZWNJ = 8204;
    private static final int ZWJ = 8205;
    private static final int RLM = 8207;
    private static final int NNBSP = 8239;
    private static final int WJ = 8288;
    private static final int INHSWAP = 8298;
    private static final int NOMDIG = 8303;
    private static final int ZWNBSP = 65279;

    public void setIndexData(CharTrie.FriendAgent friendagent) {
        this.m_trieIndex_ = friendagent.getPrivateIndex();
        this.m_trieData_ = friendagent.getPrivateData();
        this.m_trieInitialValue_ = friendagent.getPrivateInitialValue();
    }

    public int getFoldingOffset(int value) {
        if ((value & 0x8000) != 0) {
            return value & Short.MAX_VALUE;
        }
        return 0;
    }

    public int getProperty(int ch) {
        if (ch < 55296 || ch > 56319 && ch < 65536) {
            try {
                return this.m_property_[this.m_trieData_[(this.m_trieIndex_[ch >> 5] << 2) + (ch & 0x1F)]];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return this.m_property_[this.m_trieInitialValue_];
            }
        }
        if (ch <= 56319) {
            return this.m_property_[this.m_trieData_[(this.m_trieIndex_[320 + (ch >> 5)] << 2) + (ch & 0x1F)]];
        }
        if (ch <= 0x10FFFF) {
            return this.m_property_[this.m_trie_.getSurrogateValue(UTF16.getLeadSurrogate(ch), (char)(ch & 0x3FF))];
        }
        return this.m_property_[this.m_trieInitialValue_];
    }

    public static int getSignedValue(int prop) {
        return prop >> 20;
    }

    public static int getExceptionIndex(int prop) {
        return prop >> 20 & 0x7FF;
    }

    public static int getUnsignedValue(int prop) {
        return prop >> 20 & 0x7FF;
    }

    public boolean hasExceptionValue(int index, int indicator) {
        return (this.m_exception_[index] & 1 << indicator) != 0;
    }

    public int getExceptionValue(int props, int etype) {
        int index = UCharacterProperty.getExceptionIndex(props);
        if (this.hasExceptionValue(index, etype)) {
            if (etype == 9) {
                return this.m_exception_[index];
            }
            int n = this.m_exception_[index];
            ++index;
            index = this.addExceptionOffset(n, etype, index);
            return this.m_exception_[index];
        }
        return -1;
    }

    public int getException(int index, int etype) {
        if (etype == 9) {
            return this.m_exception_[index];
        }
        int n = this.m_exception_[index];
        ++index;
        index = this.addExceptionOffset(n, etype, index);
        return this.m_exception_[index];
    }

    public int getFoldCase(int index) {
        char single = this.m_case_[index];
        if ('\ud800' <= single && single <= '\udfff') {
            if (single <= '\udbff') {
                char trail = this.m_case_[index + 1];
                if ('\ud800' <= trail && trail <= '\udfff') {
                    return UCharacterProperty.getRawSupplementary(single, trail);
                }
            } else {
                char lead = this.m_case_[index - 1];
                if ('\ud800' <= lead && lead <= '\udbff') {
                    return UCharacterProperty.getRawSupplementary(lead, single);
                }
            }
        }
        return single;
    }

    public void getFoldCase(int index, int count, StringBuffer str) {
        index += 2;
        while (count > 0) {
            str.append(this.m_case_[index]);
            ++index;
            --count;
        }
    }

    public void getUpperCase(int index, StringBuffer buffer) {
        int count = this.m_case_[index];
        index += (count & 0x1F) + 1;
        count = count >> 5 & 0x1F;
        int j = 0;
        while (j < count) {
            buffer.append(this.m_case_[index + j]);
            ++j;
        }
    }

    public void getTitleCase(int index, StringBuffer buffer) {
        int count = this.m_case_[index];
        index += (count & 0x1F) + 1 + (count >> 5 & 0x1F);
        count = count >> 10 & 0x1F;
        int j = 0;
        while (j < count) {
            buffer.append(this.m_case_[index + j]);
            ++j;
        }
    }

    public void getLowerCase(int index, StringBuffer buffer) {
        int count = this.m_case_[index] & 0x1F;
        ++index;
        int j = 0;
        while (j < count) {
            buffer.append(this.m_case_[index + j]);
            ++j;
        }
    }

    public int getAdditional(int codepoint, int column) {
        if (column == -1) {
            return this.getProperty(codepoint);
        }
        if (column < 0 || column >= this.m_additionalColumnsCount_) {
            return 0;
        }
        return this.m_additionalVectors_[this.m_additionalTrie_.getCodePointValue(codepoint) + column];
    }

    public VersionInfo getAge(int codepoint) {
        int version2 = this.getAdditional(codepoint, 0) >> 24;
        return VersionInfo.getInstance(version2 >> 4 & 0xF, version2 & 0xF, 0, 0);
    }

    public boolean hasBinaryProperty(int codepoint, int property) {
        if (property < 0 || 35 <= property) {
            return false;
        }
        if (property == 9) {
            return NormalizerImpl.isFullCompositionExclusion(codepoint);
        }
        return (0xFFFFFFFFL & (long)this.getAdditional(codepoint, this.binProps[property].column) & this.binProps[property].mask) != 0L;
    }

    public static int getRawSupplementary(char lead, char trail) {
        return (lead << 10) + trail + -56613888;
    }

    public static UCharacterProperty getInstance() throws RuntimeException {
        if (INSTANCE_ == null) {
            try {
                INSTANCE_ = new UCharacterProperty();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return INSTANCE_;
    }

    public int getSpecialLowerCase(Locale locale, int index, int ch, UCharacterIterator uchariter, StringBuffer buffer) {
        int exception = this.getException(index, 7);
        if (exception < 0) {
            String language;
            int offset = uchariter.getIndex();
            if (locale.getLanguage().equals(LITHUANIAN_) && ((ch == 73 || ch == 74 || ch == 302) && UCharacterProperty.isFollowedByMOREABOVE(uchariter, offset) || ch == 204 || ch == 205 || ch == 296)) {
                switch (ch) {
                    case 73: {
                        buffer.append('i');
                        buffer.append('\u0307');
                        return 2;
                    }
                    case 74: {
                        buffer.append('j');
                        buffer.append('\u0307');
                        return 2;
                    }
                    case 302: {
                        buffer.append('\u012f');
                        buffer.append('\u0307');
                        return 2;
                    }
                    case 204: {
                        buffer.append('i');
                        buffer.append('\u0307');
                        buffer.append('\u0300');
                        return 3;
                    }
                    case 205: {
                        buffer.append('i');
                        buffer.append('\u0307');
                        buffer.append('\u0301');
                        return 3;
                    }
                    case 296: {
                        buffer.append('i');
                        buffer.append('\u0307');
                        buffer.append('\u0303');
                        return 3;
                    }
                }
            }
            if ((language = locale.getLanguage()).equals(TURKISH_) || language.equals(AZERBAIJANI_)) {
                if (ch == 304) {
                    buffer.append('i');
                    return 1;
                }
                if (ch == 775 && this.isPrecededByI(uchariter, offset)) {
                    return 0;
                }
                if (ch == 73 && !UCharacterProperty.isFollowedByDotAbove(uchariter, offset)) {
                    buffer.append('\u0131');
                    return 1;
                }
            }
            if (ch == 304) {
                buffer.append('i');
                buffer.append('\u0307');
                return 2;
            }
            if (ch == 931 && this.isCFINAL(uchariter, offset) && this.isNotCINITIAL(uchariter, offset)) {
                buffer.append('\u03c2');
                return 1;
            }
            if (this.hasExceptionValue(index, 1)) {
                int oldlength = buffer.length();
                UTF16.append(buffer, this.getException(index, 1));
                return buffer.length() - oldlength;
            }
            UTF16.append(buffer, ch);
            return UTF16.getCharCount(ch);
        }
        index = exception & 0xFFFF;
        int oldlength = buffer.length();
        this.getLowerCase(index, buffer);
        return buffer.length() - oldlength;
    }

    public int toLowerCase(Locale locale, int ch, UCharacterIterator uchariter, StringBuffer buffer) {
        int props = this.getProperty(ch);
        if ((props & 0x20) == 0) {
            int type = props & 0x1F;
            if (type == 1 || type == 3) {
                ch += UCharacterProperty.getSignedValue(props);
            }
        } else {
            int index = UCharacterProperty.getExceptionIndex(props);
            if (this.hasExceptionValue(index, 7)) {
                return this.getSpecialLowerCase(locale, index, ch, uchariter, buffer);
            }
            if (this.hasExceptionValue(index, 1)) {
                ch = this.getException(index, 1);
            }
        }
        UTF16.append(buffer, ch);
        return UTF16.getCharCount(ch);
    }

    public int toLowerCase(Locale locale, int ch, UCharacterIterator uchariter, char[] buffer) {
        int props = this.getProperty(ch);
        if ((props & 0x20) == 0) {
            int type = props & 0x1F;
            if (type == 1 || type == 3) {
                ch += UCharacterProperty.getSignedValue(props);
            }
        } else {
            int index = UCharacterProperty.getExceptionIndex(props);
            if (this.hasExceptionValue(index, 7)) {
                StringBuffer strbuffer = new StringBuffer(1);
                int result = this.getSpecialLowerCase(locale, index, ch, uchariter, strbuffer);
                strbuffer.getChars(0, result, buffer, 0);
                return result;
            }
            if (this.hasExceptionValue(index, 1)) {
                ch = this.getException(index, 1);
            }
        }
        if (ch < 65536) {
            buffer[0] = (char)ch;
            return 1;
        }
        buffer[0] = UTF16.getLeadSurrogate(ch);
        buffer[1] = UTF16.getTrailSurrogate(ch);
        return 2;
    }

    public void toLowerCase(Locale locale, String str, int start, int limit, StringBuffer result) {
        UCharacterIterator ucharIter = UCharacterIterator.getInstance(str);
        int strIndex = start;
        while (strIndex < limit) {
            ucharIter.setIndex(strIndex);
            int ch = ucharIter.currentCodePoint();
            this.toLowerCase(locale, ch, ucharIter, result);
            ++strIndex;
            if (ch < 65536) continue;
            ++strIndex;
        }
    }

    public int getSpecialUpperOrTitleCase(Locale locale, int index, int ch, UCharacterIterator uchariter, boolean upperflag, StringBuffer buffer) {
        int exception = this.getException(index, 7);
        if (exception < 0) {
            String language = locale.getLanguage();
            if ((language.equals(TURKISH_) || language.equals(AZERBAIJANI_)) && ch == 105) {
                buffer.append('\u0130');
                return 1;
            }
            if (language.equals(LITHUANIAN_) && ch == 775 && this.isPrecededBySoftDotted(uchariter, uchariter.getIndex())) {
                return 0;
            }
            if (!upperflag && this.hasExceptionValue(index, 2)) {
                ch = this.getException(index, 2);
            } else if (this.hasExceptionValue(index, 0)) {
                ch = this.getException(index, 0);
            }
            UTF16.append(buffer, ch);
            return UTF16.getCharCount(ch);
        }
        index = exception & 0xFFFF;
        int oldlength = buffer.length();
        if (upperflag) {
            this.getUpperCase(index, buffer);
        } else {
            this.getTitleCase(index, buffer);
        }
        return buffer.length() - oldlength;
    }

    public int toUpperOrTitleCase(Locale locale, int ch, UCharacterIterator uchariter, boolean upperflag, StringBuffer buffer) {
        int props = this.getProperty(ch);
        if ((props & 0x20) == 0) {
            int type = props & 0x1F;
            if (type == 2) {
                ch -= UCharacterProperty.getSignedValue(props);
            }
        } else {
            int index = UCharacterProperty.getExceptionIndex(props);
            if (this.hasExceptionValue(index, 7)) {
                return this.getSpecialUpperOrTitleCase(locale, index, ch, uchariter, upperflag, buffer);
            }
            if (!upperflag && this.hasExceptionValue(index, 2)) {
                ch = this.getException(index, 2);
            } else if (this.hasExceptionValue(index, 0)) {
                ch = this.getException(index, 0);
            }
        }
        UTF16.append(buffer, ch);
        return UTF16.getCharCount(ch);
    }

    public int toUpperOrTitleCase(Locale locale, int ch, UCharacterIterator uchariter, boolean upperflag, char[] buffer) {
        int props = this.getProperty(ch);
        if ((props & 0x20) == 0) {
            int type = props & 0x1F;
            if (type == 2) {
                ch -= UCharacterProperty.getSignedValue(props);
            }
        } else {
            int index = UCharacterProperty.getExceptionIndex(props);
            if (this.hasExceptionValue(index, 7)) {
                StringBuffer strbuffer = new StringBuffer(1);
                int result = this.getSpecialUpperOrTitleCase(locale, index, ch, uchariter, upperflag, strbuffer);
                strbuffer.getChars(0, result, buffer, 0);
                return result;
            }
            if (!upperflag && this.hasExceptionValue(index, 2)) {
                ch = this.getException(index, 2);
            } else if (this.hasExceptionValue(index, 0)) {
                ch = this.getException(index, 0);
            }
        }
        if (ch < 65536) {
            buffer[0] = (char)ch;
            return 1;
        }
        buffer[0] = UTF16.getLeadSurrogate(ch);
        buffer[1] = UTF16.getTrailSurrogate(ch);
        return 2;
    }

    public String toUpperCase(Locale locale, String str, int start, int limit) {
        UCharacterIterator ucharIter = UCharacterIterator.getInstance(str);
        int strIndex = start;
        StringBuffer result = new StringBuffer(limit - start);
        while (strIndex < limit) {
            ucharIter.setIndex(strIndex);
            int ch = ucharIter.currentCodePoint();
            this.toUpperOrTitleCase(locale, ch, ucharIter, true, result);
            ++strIndex;
            if (ch < 65536) continue;
            ++strIndex;
        }
        return result.toString();
    }

    public String toTitleCase(Locale locale, String str, BreakIterator breakiter) {
        UCharacterIterator ucharIter = UCharacterIterator.getInstance(str);
        int length = str.length();
        StringBuffer result = new StringBuffer();
        breakiter.setText(str);
        int index = breakiter.first();
        while (index != -1 && index < length) {
            int ch = UTF16.charAt(str, index);
            ucharIter.setIndex(index);
            this.toUpperOrTitleCase(locale, ch, ucharIter, false, result);
            int next = breakiter.next();
            if ((index += UTF16.getCharCount(ch)) != -1 && index < next) {
                this.toLowerCase(locale, str, index, next, result);
            }
            index = next;
        }
        return result.toString();
    }

    public static boolean isRuleWhiteSpace(int c) {
        UCharacterProperty property = UCharacterProperty.getInstance();
        return (property.getProperty(c) & 0x1F) == 16 || property.hasBinaryProperty(c, 31);
    }

    public int getMaxValues(int column) {
        switch (column) {
            case 0: {
                return this.m_maxBlockScriptValue_;
            }
            case 2: {
                return this.m_maxJTGValue_;
            }
        }
        return 0;
    }

    public static int getMask(int type) {
        return 1 << type;
    }

    private UCharacterProperty() throws IOException {
        InputStream i = this.getClass().getResourceAsStream(DATA_FILE_NAME_);
        BufferedInputStream b = new BufferedInputStream(i, 25000);
        UCharacterPropertyReader reader = new UCharacterPropertyReader(b);
        reader.read(this);
        b.close();
        i.close();
        this.m_trie_.putIndexData(this);
    }

    private boolean isPrecededBySoftDotted(UCharacterIterator uchariter, int offset) {
        uchariter.setIndex(offset);
        int ch = uchariter.previousCodePoint();
        while (ch != -1) {
            if (this.isSoftDotted(ch)) {
                return true;
            }
            int cc = NormalizerImpl.getCombiningClass(ch);
            if (cc == 0 || cc == 230) {
                return false;
            }
            ch = uchariter.previousCodePoint();
        }
        return false;
    }

    private boolean isCFINAL(UCharacterIterator uchariter, int offset) {
        uchariter.setIndex(offset);
        uchariter.nextCodePoint();
        int ch = uchariter.nextCodePoint();
        while (ch != -1) {
            int cat = this.getProperty(ch) & 0x1F;
            if (this.isCased(ch, cat)) {
                return false;
            }
            if (!UCharacterProperty.isCaseIgnorable(ch, cat)) {
                return true;
            }
            ch = uchariter.nextCodePoint();
        }
        return true;
    }

    private boolean isNotCINITIAL(UCharacterIterator uchariter, int offset) {
        uchariter.setIndex(offset);
        int ch = uchariter.previousCodePoint();
        while (ch != -1) {
            int cat = this.getProperty(ch) & 0x1F;
            if (this.isCased(ch, cat)) {
                return true;
            }
            if (!UCharacterProperty.isCaseIgnorable(ch, cat)) {
                return false;
            }
            ch = uchariter.previousCodePoint();
        }
        return false;
    }

    private boolean isPrecededByI(UCharacterIterator uchariter, int offset) {
        int c;
        uchariter.setIndex(offset);
        while ((c = uchariter.previousCodePoint()) >= 0) {
            if (c == 73) {
                return true;
            }
            int cc = NormalizerImpl.getCombiningClass(c);
            if (cc != 0 && cc != 230) continue;
            return false;
        }
        return false;
    }

    private static boolean isFollowedByMOREABOVE(UCharacterIterator uchariter, int offset) {
        uchariter.setIndex(offset);
        uchariter.nextCodePoint();
        int ch = uchariter.nextCodePoint();
        while (ch != -1) {
            int cc = NormalizerImpl.getCombiningClass(ch);
            if (cc == 230) {
                return true;
            }
            if (cc == 0) {
                return false;
            }
            ch = uchariter.nextCodePoint();
        }
        return false;
    }

    private static boolean isFollowedByDotAbove(UCharacterIterator uchariter, int offset) {
        uchariter.setIndex(offset);
        uchariter.nextCodePoint();
        int ch = uchariter.nextCodePoint();
        while (ch != -1) {
            if (ch == 775) {
                return true;
            }
            int cc = NormalizerImpl.getCombiningClass(ch);
            if (cc == 0 || cc == 230) {
                return false;
            }
            ch = uchariter.nextCodePoint();
        }
        return false;
    }

    private static boolean isCaseIgnorable(int ch, int cat) {
        return cat == 6 || cat == 7 || cat == 16 || cat == 4 || cat == 26 || ch == 39 || ch == 173 || ch == 8217;
    }

    private boolean isCased(int ch, int cat) {
        boolean result;
        boolean bl = result = cat == 3 || cat == 1 || cat == 2;
        if (result) {
            return result;
        }
        int prop = this.getAdditional(ch, 1);
        return this.compareAdditionalType(prop, 15) || this.compareAdditionalType(prop, 14);
    }

    private boolean isSoftDotted(int ch) {
        return this.compareAdditionalType(this.getAdditional(ch, 1), 25);
    }

    private int addExceptionOffset(int evalue, int indicator, int address) {
        int result = address;
        if (indicator >= 8) {
            result += FLAGS_OFFSET_[evalue & 0xFF];
            evalue >>= 8;
            indicator -= 8;
        }
        int mask = (1 << indicator) - 1;
        return result += FLAGS_OFFSET_[evalue & mask];
    }

    private boolean compareAdditionalType(int property, int type) {
        return (property & 1 << type) != 0;
    }

    public UnicodeSet addPropertyStarts(UnicodeSet set) {
        int value2;
        TrieIterator propsIter = new TrieIterator(this.m_trie_);
        RangeValueIterator.Element propsResult = new RangeValueIterator.Element();
        while (propsIter.next(propsResult)) {
            set.add(propsResult.start);
        }
        TrieIterator propsVectorsIter = new TrieIterator(this.m_additionalTrie_);
        RangeValueIterator.Element propsVectorsResult = new RangeValueIterator.Element();
        while (propsVectorsIter.next(propsVectorsResult)) {
            set.add(propsVectorsResult.start);
        }
        set.add(9);
        set.add(14);
        set.add(28);
        set.add(32);
        set.add(133);
        set.add(134);
        set.add(127);
        set.add(8202);
        set.add(8208);
        set.add(8298);
        set.add(8304);
        set.add(65279);
        set.add(65280);
        set.add(160);
        set.add(161);
        set.add(8199);
        set.add(8200);
        set.add(8239);
        set.add(8240);
        set.add(12295);
        set.add(12296);
        set.add(19968);
        set.add(19969);
        set.add(20108);
        set.add(20109);
        set.add(19977);
        set.add(19978);
        set.add(22235);
        set.add(22236);
        set.add(20116);
        set.add(20117);
        set.add(20845);
        set.add(20846);
        set.add(19971);
        set.add(19972);
        set.add(20843);
        set.add(20844);
        set.add(20061);
        set.add(20062);
        set.add(97);
        set.add(123);
        set.add(65);
        set.add(91);
        set.add(8288);
        set.add(65520);
        set.add(65532);
        set.add(917504);
        set.add(921600);
        set.add(847);
        set.add(848);
        set.add(8204);
        set.add(8206);
        set.add(4352);
        int value = 1;
        int c = 4442;
        while (c <= 4447) {
            value2 = UCharacter.getIntPropertyValue(c, 4107);
            if (value != value2) {
                value = value2;
                set.add(c);
            }
            ++c;
        }
        set.add(4448);
        value = 2;
        c = 4515;
        while (c <= 4519) {
            value2 = UCharacter.getIntPropertyValue(c, 4107);
            if (value != value2) {
                value = value2;
                set.add(c);
            }
            ++c;
        }
        set.add(4520);
        value = 3;
        c = 4602;
        while (c <= 4607) {
            value2 = UCharacter.getIntPropertyValue(c, 4107);
            if (value != value2) {
                value = value2;
                set.add(c);
            }
            ++c;
        }
        return set;
    }

    public UnicodeSet getInclusions() {
        UnicodeSet set = new UnicodeSet();
        NormalizerImpl.addPropertyStarts(set);
        this.addPropertyStarts(set);
        return set;
    }

    private static final class BinaryProperties {
        int column;
        long mask;

        public BinaryProperties(int column, long mask) {
            this.column = column;
            this.mask = mask;
        }
    }
}

