/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.felix.cm.PersistenceManager;
import org.apache.felix.cm.file.FilePersistenceManager;
import org.apache.felix.cm.impl.ConfigurationAdminFactory;
import org.apache.felix.cm.impl.ConfigurationAdminImpl;
import org.apache.felix.cm.impl.ConfigurationImpl;
import org.apache.felix.cm.impl.Factory;
import org.apache.felix.cm.impl.RankingComparator;
import org.apache.felix.cm.impl.UpdateThread;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.cm.ConfigurationPlugin;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class ConfigurationManager
implements BundleActivator,
BundleListener {
    public static final String CM_CONFIG_DIR = "felix.cm.dir";
    private static final String LOG_SERVICE_NAME = "org.osgi.service.log.LogService";
    private static SecureRandom numberGenerator;
    private static final Comparator cmRankComp;
    private BundleContext bundleContext;
    private ServiceRegistration configurationAdminRegistration;
    private ServiceReference configurationAdminReference;
    private ServiceTracker logTracker;
    private ServiceTracker configurationListenerTracker;
    private ServiceTracker managedServiceTracker;
    private ServiceTracker managedServiceFactoryTracker;
    private ServiceTracker persistenceManagerTracker;
    private UpdateThread updateThread;
    private PersistenceManager[] persistenceManagers;
    private int pmtCount;
    private Map factories;
    private Map configurations;
    static /* synthetic */ Class class$org$osgi$service$cm$ManagedService;
    static /* synthetic */ Class class$org$osgi$service$cm$ManagedServiceFactory;

    public void start(BundleContext bundleContext) {
        Hashtable<String, Object> props;
        this.logTracker = new ServiceTracker(bundleContext, LOG_SERVICE_NAME, null);
        this.logTracker.open();
        this.bundleContext = bundleContext;
        this.factories = new HashMap();
        this.configurations = new HashMap();
        this.configurationListenerTracker = new ServiceTracker(bundleContext, ConfigurationListener.class.getName(), null);
        this.configurationListenerTracker.open();
        this.updateThread = new UpdateThread(this);
        this.updateThread.start();
        try {
            FilePersistenceManager fpm = new FilePersistenceManager(bundleContext, bundleContext.getProperty(CM_CONFIG_DIR));
            props = new Hashtable<String, Object>();
            props.put("service.pid", fpm.getClass().getName());
            props.put("service.description", "Platform Filesystem Persistence Manager");
            props.put("service.vendor", "Apache Software Foundation");
            props.put("service.ranking", new Integer(Integer.MIN_VALUE));
            bundleContext.registerService(PersistenceManager.class.getName(), (Object)fpm, props);
        }
        catch (IllegalArgumentException iae) {
            this.log(1, "Cannot create the FilePersistenceManager", iae);
        }
        bundleContext.addBundleListener((BundleListener)this);
        this.pmtCount = 1;
        this.persistenceManagerTracker = new ServiceTracker(bundleContext, PersistenceManager.class.getName(), null);
        this.persistenceManagerTracker.open();
        ConfigurationAdminFactory caf = new ConfigurationAdminFactory(this);
        props = new Hashtable();
        props.put("service.pid", "org.apache.felix.cm.ConfigurationAdmin");
        props.put("service.description", "Configuration Admin Service Specification 1.2 Implementation");
        props.put("service.vendor", "Apache Software Foundation");
        this.configurationAdminRegistration = bundleContext.registerService(ConfigurationAdmin.class.getName(), (Object)caf, props);
        this.managedServiceTracker = new ManagedServiceTracker();
        this.managedServiceFactoryTracker = new ManagedServiceFactoryTracker();
    }

    public void stop(BundleContext bundleContext) {
        this.configurationAdminRegistration.unregister();
        this.configurationAdminRegistration = null;
        this.managedServiceFactoryTracker.close();
        this.managedServiceTracker.close();
        this.persistenceManagerTracker.close();
        bundleContext.removeBundleListener((BundleListener)this);
        if (this.configurationListenerTracker != null) {
            this.configurationListenerTracker.close();
        }
        if (this.updateThread != null) {
            this.updateThread.terminate();
            try {
                this.updateThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.logTracker != null) {
            this.logTracker.close();
        }
        this.bundleContext = null;
        this.configurations = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConfigurationImpl getCachedConfiguration(String pid) {
        Map map = this.configurations;
        synchronized (map) {
            return (ConfigurationImpl)this.configurations.get(pid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator getCachedConfigurations() {
        Map map = this.configurations;
        synchronized (map) {
            return this.configurations.values().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConfigurationImpl cacheConfiguration(ConfigurationImpl configuration) {
        Map map = this.configurations;
        synchronized (map) {
            Object existing = this.configurations.get(configuration.getPid());
            if (existing != null) {
                return (ConfigurationImpl)existing;
            }
            this.configurations.put(configuration.getPid(), configuration);
            return configuration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConfiguration(ConfigurationImpl configuration) {
        Map map = this.configurations;
        synchronized (map) {
            this.configurations.remove(configuration.getPid());
        }
    }

    ConfigurationImpl createFactoryConfiguration(ConfigurationAdminImpl configurationAdmin, String factoryPid) throws IOException {
        Factory factory = this.getFactory(factoryPid);
        if (factory.getBundleLocation() != null && !factory.getBundleLocation().equals(configurationAdmin.getBundle().getLocation())) {
            configurationAdmin.checkPermission();
        }
        String pid = ConfigurationManager.createPid(factoryPid);
        ConfigurationImpl config = this.createConfiguration(pid, factoryPid, configurationAdmin.getBundle().getLocation());
        factory.addPID(pid);
        factory.store();
        return config;
    }

    ConfigurationImpl createFactoryConfiguration(String factoryPid, String location) throws IOException {
        String pid = ConfigurationManager.createPid(factoryPid);
        ConfigurationImpl config = this.createConfiguration(pid, factoryPid, location);
        Factory factory = this.getFactory(factoryPid);
        factory.addPID(pid);
        factory.store();
        return config;
    }

    ConfigurationImpl getExistingConfiguration(String pid) throws IOException {
        ConfigurationImpl config = this.getCachedConfiguration(pid);
        if (config != null) {
            return config;
        }
        PersistenceManager[] pmList = this.getPersistenceManagers();
        for (int i = 0; i < pmList.length; ++i) {
            if (!pmList[i].exists(pid)) continue;
            Dictionary props = pmList[i].load(pid);
            config = new ConfigurationImpl(this, pmList[i], props);
            return this.cacheConfiguration(config);
        }
        return null;
    }

    ConfigurationImpl getConfiguration(String pid, String bundleLocation) throws IOException {
        ConfigurationImpl config = this.getExistingConfiguration(pid);
        if (config != null) {
            return config;
        }
        return this.createConfiguration(pid, null, bundleLocation);
    }

    ConfigurationImpl[] listConfigurations(ConfigurationAdminImpl configurationAdmin, String filterString) throws IOException, InvalidSyntaxException {
        Filter filter = null;
        if (filterString != null) {
            filter = this.bundleContext.createFilter(filterString);
        }
        boolean unprivileged = configurationAdmin != null && !configurationAdmin.hasPermission();
        String location = unprivileged ? configurationAdmin.getBundle().getLocation() : null;
        ArrayList<ConfigurationImpl> configList = new ArrayList<ConfigurationImpl>();
        PersistenceManager[] pmList = this.getPersistenceManagers();
        for (int i = 0; i < pmList.length; ++i) {
            Enumeration configs = pmList[i].getDictionaries();
            while (configs.hasMoreElements()) {
                Object boundLocation;
                Dictionary config = (Dictionary)configs.nextElement();
                String pid = (String)config.get("service.pid");
                if (pid == null || unprivileged && !location.equals(boundLocation = config.get("service.bundleLocation")) || filter != null && !filter.match(config)) continue;
                ConfigurationImpl cfg = this.getCachedConfiguration(pid);
                if (cfg == null) {
                    cfg = new ConfigurationImpl(this, pmList[i], config);
                }
                configList.add(cfg);
            }
        }
        return configList.toArray(new ConfigurationImpl[configList.size()]);
    }

    void deleted(ConfigurationImpl config) {
        this.removeConfiguration(config);
        this.updateThread.schedule(new DeleteConfiguration(config));
    }

    void updated(ConfigurationImpl config) {
        this.updateThread.schedule(new UpdateConfiguration(config));
    }

    void fireConfigurationEvent(int type, String pid, String factoryPid) {
        this.updateThread.schedule(new FireConfigurationEvent(type, pid, factoryPid));
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 16) {
            String location = event.getBundle().getLocation();
            try {
                PersistenceManager[] pmList = this.getPersistenceManagers();
                for (int i = 0; i < pmList.length; ++i) {
                    Enumeration configs = pmList[i].getDictionaries();
                    while (configs.hasMoreElements()) {
                        Dictionary config = (Dictionary)configs.nextElement();
                        String pid = (String)config.get("service.pid");
                        if (pid != null) {
                            ConfigurationImpl cfg = this.getCachedConfiguration(pid);
                            if (cfg == null) {
                                cfg = new ConfigurationImpl(this, pmList[i], config);
                            }
                            if (!location.equals(cfg.getBundleLocation())) continue;
                            cfg.setBundleLocation(null);
                            continue;
                        }
                        Factory factory = Factory.getFactory(pmList[i], config);
                        if (factory == null) continue;
                        Factory cachedFactory = (Factory)this.factories.get(factory.getFactoryPid());
                        if (cachedFactory != null) {
                            factory = cachedFactory;
                        }
                        if (!location.equals(factory.getBundleLocation())) continue;
                        factory.setBundleLocation(null);
                    }
                }
            }
            catch (Exception e) {
                this.log(2, "Problem unbinding configurations for bundle " + location, e);
            }
        }
    }

    private PersistenceManager[] getPersistenceManagers() {
        int currentPmtCount = this.persistenceManagerTracker.getTrackingCount();
        if (this.persistenceManagers == null || currentPmtCount > this.pmtCount) {
            PersistenceManager[] pm;
            ServiceReference[] refs = this.persistenceManagerTracker.getServiceReferences();
            if (refs == null || refs.length == 0) {
                pm = new PersistenceManager[]{};
            } else {
                TreeSet<ServiceReference> pms = new TreeSet<ServiceReference>(new RankingComparator(false));
                for (int i = 0; i < refs.length; ++i) {
                    pms.add(refs[i]);
                }
                pm = new PersistenceManager[pms.size()];
                int pmIndex = 0;
                Iterator pi = pms.iterator();
                while (pi.hasNext()) {
                    ServiceReference ref = (ServiceReference)pi.next();
                    pm[pmIndex] = (PersistenceManager)this.persistenceManagerTracker.getService(ref);
                    ++pmIndex;
                }
            }
            this.pmtCount = currentPmtCount;
            this.persistenceManagers = pm;
        }
        return this.persistenceManagers;
    }

    private void configure(ServiceReference sr, ManagedService service) {
        String pid = (String)sr.getProperty("service.pid");
        if (pid != null) {
            ManagedServiceUpdate update = new ManagedServiceUpdate(pid, sr, service);
            this.updateThread.schedule(update);
        }
    }

    private void configure(ServiceReference sr, ManagedServiceFactory service) {
        String pid = (String)sr.getProperty("service.pid");
        if (pid != null) {
            ManagedServiceFactoryUpdate update = new ManagedServiceFactoryUpdate(pid, sr, service);
            this.updateThread.schedule(update);
        }
    }

    ConfigurationImpl createConfiguration(String pid, String factoryPid, String bundleLocation) throws IOException {
        ConfigurationImpl config = new ConfigurationImpl(this, this.getPersistenceManagers()[0], pid, factoryPid, bundleLocation);
        return this.cacheConfiguration(config);
    }

    Factory getFactory(String factoryPid) throws IOException {
        Factory factory = (Factory)this.factories.get(factoryPid);
        if (factory != null) {
            return factory;
        }
        PersistenceManager[] pmList = this.getPersistenceManagers();
        for (int i = 0; i < pmList.length; ++i) {
            if (!Factory.exists(pmList[i], factoryPid)) continue;
            factory = Factory.load(pmList[i], factoryPid);
            this.factories.put(factoryPid, factory);
            return factory;
        }
        return this.createFactory(factoryPid);
    }

    Factory createFactory(String factoryPid) {
        Factory factory = new Factory(this.getPersistenceManagers()[0], factoryPid);
        this.factories.put(factoryPid, factory);
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dictionary callPlugins(ServiceReference sr, ConfigurationImpl cfg) {
        Dictionary props = cfg.getProperties();
        if (props == null) {
            return null;
        }
        ServiceReference[] plugins = null;
        try {
            String pid = (String)sr.getProperty("service.pid");
            String filter = "(|(!(cm.target=*))(cm.target=" + pid + "))";
            plugins = this.bundleContext.getServiceReferences(ConfigurationPlugin.class.getName(), filter);
        }
        catch (InvalidSyntaxException ise) {
            // empty catch block
        }
        if (plugins == null || plugins.length == 0) {
            return props;
        }
        TreeSet<void> pluginSet = new TreeSet<void>(cmRankComp);
        for (int i = 0; plugins != null && i < plugins.length; ++i) {
            pluginSet.add(plugins[i]);
        }
        Iterator pi = pluginSet.iterator();
        while (pi.hasNext()) {
            ServiceReference pluginRef = (ServiceReference)pi.next();
            ConfigurationPlugin plugin = (ConfigurationPlugin)this.bundleContext.getService(pluginRef);
            try {
                plugin.modifyConfiguration(sr, props);
            }
            catch (Throwable t) {
                this.log(1, "Unexpected problem calling configuration plugin", t);
            }
            finally {
                this.bundleContext.ungetService(pluginRef);
            }
            cfg.setAutoProperties(props, false);
        }
        return props;
    }

    private static String createPid(String factoryPid) {
        SecureRandom ng = numberGenerator;
        if (ng == null) {
            numberGenerator = ng = new SecureRandom();
        }
        byte[] randomBytes = new byte[16];
        ng.nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0x80);
        StringBuffer buf = new StringBuffer(factoryPid.length() + 1 + 36);
        buf.append(factoryPid).append(".");
        for (int i = 0; i < randomBytes.length; ++i) {
            if (i == 4 || i == 6 || i == 8 || i == 10) {
                buf.append('-');
            }
            int val = randomBytes[i] & 0xFF;
            buf.append(Integer.toHexString(val >> 4));
            buf.append(Integer.toHexString(val & 0xF));
        }
        return buf.toString();
    }

    void log(int level, String message, Throwable t) {
        String code;
        Object log = this.logTracker.getService();
        if (log != null) {
            ((LogService)log).log(this.configurationAdminReference, level, message, t);
            return;
        }
        switch (level) {
            case 3: {
                code = "*INFO *";
                break;
            }
            case 2: {
                code = "*WARN *";
                break;
            }
            case 1: {
                code = "*ERROR*";
                break;
            }
            default: {
                code = "*DEBUG*";
            }
        }
        System.err.println(code + " " + message);
        if (t != null) {
            t.printStackTrace(System.err);
        }
    }

    static {
        cmRankComp = new RankingComparator(true, "service.cmRanking");
    }

    private class ManagedServiceFactoryTracker
    extends AbstractManagedServiceTracker {
        ManagedServiceFactoryTracker() {
            super((class$org$osgi$service$cm$ManagedServiceFactory == null ? (class$org$osgi$service$cm$ManagedServiceFactory = ConfigurationManager.class$("org.osgi.service.cm.ManagedServiceFactory")) : class$org$osgi$service$cm$ManagedServiceFactory).getName());
        }

        public Object addingService(ServiceReference reference) {
            ManagedServiceFactory service = (ManagedServiceFactory)super.addingService(reference);
            if (service != null) {
                ConfigurationManager.this.configure(reference, service);
            }
            return service;
        }
    }

    private class ManagedServiceTracker
    extends AbstractManagedServiceTracker {
        ManagedServiceTracker() {
            super((class$org$osgi$service$cm$ManagedService == null ? (class$org$osgi$service$cm$ManagedService = ConfigurationManager.class$("org.osgi.service.cm.ManagedService")) : class$org$osgi$service$cm$ManagedService).getName());
        }

        public Object addingService(ServiceReference reference) {
            ManagedService service = (ManagedService)super.addingService(reference);
            if (service != null) {
                ConfigurationManager.this.configure(reference, service);
            }
            return service;
        }
    }

    private abstract class AbstractManagedServiceTracker
    extends ServiceTracker {
        AbstractManagedServiceTracker(String className) {
            super(ConfigurationManager.this.bundleContext, className, null);
            this.open();
        }

        public void removedService(ServiceReference reference, Object service) {
            ConfigurationImpl cfg;
            String pid = (String)reference.getProperty("service.pid");
            if (pid != null && (cfg = ConfigurationManager.this.getCachedConfiguration(pid)) != null && reference.equals(cfg.getServiceReference())) {
                cfg.setServiceReference(null);
            }
            super.removedService(reference, service);
        }
    }

    private class FireConfigurationEvent
    implements Runnable {
        private int type;
        private String pid;
        private String factoryPid;

        FireConfigurationEvent(int type, String pid, String factoryPid) {
            this.type = type;
            this.pid = pid;
            this.factoryPid = factoryPid;
        }

        public void run() {
            ServiceReference[] srs = ConfigurationManager.this.configurationListenerTracker.getServiceReferences();
            if (srs == null || srs.length == 0) {
                return;
            }
            ConfigurationEvent event = new ConfigurationEvent(ConfigurationManager.this.configurationAdminReference, this.type, this.factoryPid, this.pid);
            for (int i = 0; i < srs.length; ++i) {
                ConfigurationListener cl = (ConfigurationListener)ConfigurationManager.this.configurationListenerTracker.getService(srs[i]);
                try {
                    cl.configurationEvent(event);
                    continue;
                }
                catch (Throwable t) {
                    ConfigurationManager.this.log(1, "Unexpected problem delivery configuration event to " + srs[i], t);
                }
            }
        }
    }

    private class DeleteConfiguration
    implements Runnable {
        private String pid;
        private String factoryPid;

        DeleteConfiguration(ConfigurationImpl config) {
            this.pid = config.getPid();
            this.factoryPid = config.getFactoryPid();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block12: {
                try {
                    if (this.factoryPid == null) {
                        ServiceReference[] sr = ConfigurationManager.this.bundleContext.getServiceReferences((class$org$osgi$service$cm$ManagedService == null ? (class$org$osgi$service$cm$ManagedService = ConfigurationManager.class$("org.osgi.service.cm.ManagedService")) : class$org$osgi$service$cm$ManagedService).getName(), "(service.pid=" + this.pid + ")");
                        if (sr == null || sr.length <= 0) break block12;
                        ManagedService srv = (ManagedService)ConfigurationManager.this.bundleContext.getService(sr[0]);
                        try {
                            srv.updated(null);
                            break block12;
                        }
                        finally {
                            ConfigurationManager.this.bundleContext.ungetService(sr[0]);
                        }
                    }
                    Factory factory = ConfigurationManager.this.getFactory(this.factoryPid);
                    factory.removePID(this.pid);
                    factory.store();
                    ServiceReference[] sr = ConfigurationManager.this.bundleContext.getServiceReferences((class$org$osgi$service$cm$ManagedServiceFactory == null ? (class$org$osgi$service$cm$ManagedServiceFactory = ConfigurationManager.class$("org.osgi.service.cm.ManagedServiceFactory")) : class$org$osgi$service$cm$ManagedServiceFactory).getName(), "(service.pid=" + this.factoryPid + ")");
                    if (sr == null || sr.length <= 0) break block12;
                    ManagedServiceFactory srv = (ManagedServiceFactory)ConfigurationManager.this.bundleContext.getService(sr[0]);
                    try {
                        srv.deleted(this.pid);
                    }
                    finally {
                        ConfigurationManager.this.bundleContext.ungetService(sr[0]);
                    }
                }
                catch (ConfigurationException ce) {
                    if (ce.getProperty() != null) {
                        ConfigurationManager.this.log(1, "Updating configuration property " + ce.getProperty() + " caused a problem: " + ce.getReason(), ce);
                    } else {
                        ConfigurationManager.this.log(1, "Updating configuration caused a problem: " + ce.getReason(), ce);
                    }
                }
                catch (Throwable t) {
                    ConfigurationManager.this.log(1, "Unexpected problem updating configuration", t);
                }
            }
            ConfigurationManager.this.fireConfigurationEvent(2, this.pid, this.factoryPid);
        }
    }

    private class UpdateConfiguration
    implements Runnable {
        private ConfigurationImpl config;

        UpdateConfiguration(ConfigurationImpl config) {
            this.config = config;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block21: {
                try {
                    if (this.config.getFactoryPid() == null) {
                        ServiceReference[] sr = ConfigurationManager.this.bundleContext.getServiceReferences((class$org$osgi$service$cm$ManagedService == null ? (class$org$osgi$service$cm$ManagedService = ConfigurationManager.class$("org.osgi.service.cm.ManagedService")) : class$org$osgi$service$cm$ManagedService).getName(), "(service.pid=" + this.config.getPid() + ")");
                        if (sr == null || sr.length <= 0) break block21;
                        ManagedService srv = (ManagedService)ConfigurationManager.this.bundleContext.getService(sr[0]);
                        try {
                            String bundleLocation = sr[0].getBundle().getLocation();
                            if (this.config.getBundleLocation() == null) {
                                this.config.setBundleLocation(bundleLocation);
                            } else if (!bundleLocation.equals(this.config.getBundleLocation())) {
                                ConfigurationManager.this.log(1, "Configuration " + this.config.getPid() + " belongs to bundle " + this.config.getBundleLocation() + " but was requested for bundle " + bundleLocation, null);
                                return;
                            }
                            Dictionary dictionary = ConfigurationManager.this.callPlugins(sr[0], this.config);
                            srv.updated(dictionary);
                            break block21;
                        }
                        finally {
                            ConfigurationManager.this.bundleContext.ungetService(sr[0]);
                        }
                    }
                    ServiceReference[] sr = ConfigurationManager.this.bundleContext.getServiceReferences((class$org$osgi$service$cm$ManagedServiceFactory == null ? (class$org$osgi$service$cm$ManagedServiceFactory = ConfigurationManager.class$("org.osgi.service.cm.ManagedServiceFactory")) : class$org$osgi$service$cm$ManagedServiceFactory).getName(), "(service.pid=" + this.config.getFactoryPid() + ")");
                    if (sr == null || sr.length <= 0) break block21;
                    ManagedServiceFactory srv = (ManagedServiceFactory)ConfigurationManager.this.bundleContext.getService(sr[0]);
                    try {
                        String bundleLocation = sr[0].getBundle().getLocation();
                        if (this.config.getBundleLocation() == null) {
                            this.config.setBundleLocation(bundleLocation);
                        } else if (!bundleLocation.equals(this.config.getBundleLocation())) {
                            ConfigurationManager.this.log(1, "Configuration " + this.config.getPid() + " (factory " + this.config.getFactoryPid() + ") belongs to bundle " + this.config.getBundleLocation() + " but was requested for bundle " + bundleLocation, null);
                            return;
                        }
                        Dictionary dictionary = ConfigurationManager.this.callPlugins(sr[0], this.config);
                        if (dictionary != null) {
                            srv.updated(this.config.getPid(), dictionary);
                        }
                    }
                    finally {
                        ConfigurationManager.this.bundleContext.ungetService(sr[0]);
                    }
                }
                catch (ConfigurationException ce) {
                    if (ce.getProperty() != null) {
                        ConfigurationManager.this.log(1, "Updating configuration property " + ce.getProperty() + " caused a problem: " + ce.getReason(), ce);
                    } else {
                        ConfigurationManager.this.log(1, "Updating configuration caused a problem: " + ce.getReason(), ce);
                    }
                }
                catch (Throwable t) {
                    ConfigurationManager.this.log(1, "Unexpected problem updating configuration", t);
                }
            }
            ConfigurationManager.this.fireConfigurationEvent(1, this.config.getPid(), this.config.getFactoryPid());
        }
    }

    private class ManagedServiceFactoryUpdate
    implements Runnable {
        private String factoryPid;
        private ServiceReference sr;
        private ManagedServiceFactory service;

        ManagedServiceFactoryUpdate(String factoryPid, ServiceReference sr, ManagedServiceFactory service) {
            this.factoryPid = factoryPid;
            this.sr = sr;
            this.service = service;
        }

        public void run() {
            Factory factory;
            try {
                factory = ConfigurationManager.this.getFactory(this.factoryPid);
            }
            catch (IOException ioe) {
                ConfigurationManager.this.log(1, "Cannot get factory mapping for factory PID " + this.factoryPid, ioe);
                return;
            }
            String bundleLocation = this.sr.getBundle().getLocation();
            if (factory.getBundleLocation() == null) {
                factory.setBundleLocation(bundleLocation);
            } else if (!bundleLocation.equals(factory.getBundleLocation())) {
                ConfigurationManager.this.log(1, "Cannot use Factory configuration for " + this.factoryPid + " requested by bundle " + this.sr.getBundle().getLocation() + " but belongs to " + factory.getBundleLocation(), null);
                return;
            }
            Set pids = factory.getPIDs();
            Iterator pi = pids.iterator();
            while (pi.hasNext()) {
                ConfigurationImpl cfg;
                String pid = (String)pi.next();
                try {
                    cfg = ConfigurationManager.this.getExistingConfiguration(pid);
                }
                catch (IOException ioe) {
                    ConfigurationManager.this.log(1, "Error loading configuration for " + pid, ioe);
                    continue;
                }
                if (cfg == null) {
                    ConfigurationManager.this.log(1, "Configuration " + pid + " referred to by factory " + this.factoryPid + " does not exist", null);
                    factory.removePID(pid);
                    factory.storeSilently();
                    continue;
                }
                if (cfg.isNew()) continue;
                if (!this.factoryPid.equals(cfg.getFactoryPid())) {
                    ConfigurationManager.this.log(1, "Configuration " + pid + " referred to by factory " + this.factoryPid + " seems to belong to factory " + cfg.getFactoryPid(), null);
                    factory.removePID(pid);
                    factory.storeSilently();
                    continue;
                }
                if (cfg.getBundleLocation() == null) {
                    cfg.setBundleLocation(bundleLocation);
                } else if (!bundleLocation.equals(cfg.getBundleLocation())) {
                    ConfigurationManager.this.log(1, "Configuration " + pid + " (factory " + this.factoryPid + ") belongs to bundle " + cfg.getBundleLocation() + " but was requested for bundle " + bundleLocation, null);
                    continue;
                }
                Dictionary dictionary = ConfigurationManager.this.callPlugins(this.sr, cfg);
                try {
                    if (dictionary == null) continue;
                    this.service.updated(pid, dictionary);
                }
                catch (ConfigurationException ce) {
                    if (ce.getProperty() != null) {
                        ConfigurationManager.this.log(1, this.sr + ": Updating configuration property " + ce.getProperty() + " caused a problem: " + ce.getReason(), ce);
                        continue;
                    }
                    ConfigurationManager.this.log(1, this.sr + ": Updating configuration caused a problem: " + ce.getReason(), ce);
                }
                catch (Throwable t) {
                    ConfigurationManager.this.log(1, this.sr + ": Unexpected problem updating configuration", t);
                }
            }
        }
    }

    private class ManagedServiceUpdate
    implements Runnable {
        private String pid;
        private ServiceReference sr;
        private ManagedService service;

        ManagedServiceUpdate(String pid, ServiceReference sr, ManagedService service) {
            this.pid = pid;
            this.sr = sr;
            this.service = service;
        }

        public void run() {
            Dictionary dictionary;
            ConfigurationImpl cfg;
            try {
                cfg = ConfigurationManager.this.getExistingConfiguration(this.pid);
            }
            catch (IOException ioe) {
                ConfigurationManager.this.log(1, "Error loading configuration for " + this.pid, ioe);
                return;
            }
            if (cfg != null && !cfg.isNew()) {
                String bundleLocation = this.sr.getBundle().getLocation();
                if (cfg.getBundleLocation() == null) {
                    cfg.setBundleLocation(bundleLocation);
                } else if (!bundleLocation.equals(cfg.getBundleLocation())) {
                    ConfigurationManager.this.log(1, "Cannot use configuration for " + this.pid + " requested by bundle " + this.sr.getBundle().getLocation() + " but belongs to " + cfg.getBundleLocation(), null);
                    return;
                }
                if (cfg.getServiceReference() != null && !this.sr.equals(cfg.getServiceReference())) {
                    ConfigurationManager.this.log(1, "Configuration for " + this.pid + " has already been used for service " + cfg.getServiceReference() + " and will now also be given to " + this.sr, null);
                } else {
                    cfg.setServiceReference(this.sr);
                }
                dictionary = ConfigurationManager.this.callPlugins(this.sr, cfg);
            } else {
                dictionary = null;
            }
            try {
                this.service.updated(dictionary);
            }
            catch (ConfigurationException ce) {
                if (ce.getProperty() != null) {
                    ConfigurationManager.this.log(1, this.sr + ": Updating configuration property " + ce.getProperty() + " caused a problem: " + ce.getReason(), ce);
                } else {
                    ConfigurationManager.this.log(1, this.sr + ": Updating configuration caused a problem: " + ce.getReason(), ce);
                }
            }
            catch (Throwable t) {
                ConfigurationManager.this.log(1, this.sr + ": Unexpected problem updating configuration", t);
            }
        }
    }
}

