/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handlers.providedservice;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.handlers.providedservice.Property;
import org.apache.felix.ipojo.handlers.providedservice.ProvidedServiceHandler;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ProvidedService
implements ServiceFactory {
    public static final int REGISTERED = 1;
    public static final int UNREGISTERED = 0;
    public static final int SINGLETON_FACTORY = 0;
    public static final int SERVICE_FACTORY = 1;
    private String[] m_serviceSpecification = new String[0];
    private int m_factoryPolicy = 0;
    private ServiceRegistration m_serviceRegistration;
    private ProvidedServiceHandler m_handler;
    private Property[] m_properties = new Property[0];

    public ProvidedService(ProvidedServiceHandler handler, String[] specification, int factoryPolicy) {
        this.m_handler = handler;
        this.m_serviceSpecification = specification;
        this.m_factoryPolicy = factoryPolicy;
        this.addProperty(new Property(this, "instance.name", handler.getInstanceManager().getInstanceName()));
        this.addProperty(new Property(this, "factory.name", handler.getInstanceManager().getFactory().getName()));
    }

    protected void setProperties(Property[] props) {
        for (int i = 0; i < props.length; ++i) {
            this.addProperty(props[i]);
        }
    }

    private synchronized void addProperty(Property p) {
        for (int i = 0; this.m_properties != null && i < this.m_properties.length; ++i) {
            if (this.m_properties[i] != p) continue;
            return;
        }
        if (this.m_properties.length > 0) {
            Property[] newProp = new Property[this.m_properties.length + 1];
            System.arraycopy(this.m_properties, 0, newProp, 0, this.m_properties.length);
            newProp[this.m_properties.length] = p;
            this.m_properties = newProp;
        } else {
            this.m_properties = new Property[]{p};
        }
    }

    private synchronized void removeProperty(String name) {
        int idx = -1;
        for (int i = 0; i < this.m_properties.length; ++i) {
            if (!this.m_properties[i].getName().equals(name)) continue;
            idx = i;
            break;
        }
        if (idx >= 0) {
            if (this.m_properties.length - 1 == 0) {
                this.m_properties = new Property[0];
            } else {
                Property[] newPropertiesList = new Property[this.m_properties.length - 1];
                System.arraycopy(this.m_properties, 0, newPropertiesList, 0, idx);
                if (idx < newPropertiesList.length) {
                    System.arraycopy(this.m_properties, idx + 1, newPropertiesList, idx, newPropertiesList.length - idx);
                }
                this.m_properties = newPropertiesList;
            }
        }
    }

    public ServiceReference getServiceReference() {
        if (this.m_serviceRegistration != null) {
            return this.m_serviceRegistration.getReference();
        }
        return null;
    }

    public Object getService(Bundle bundle, ServiceRegistration registration) {
        Object svc = null;
        switch (this.m_factoryPolicy) {
            case 0: {
                svc = this.m_handler.getInstanceManager().getPojoObject();
                break;
            }
            case 1: {
                svc = this.m_handler.getInstanceManager().createPojoObject();
                break;
            }
            default: {
                this.m_handler.getInstanceManager().getFactory().getLogger().log(1, "[" + this.m_handler.getInstanceManager().getClassName() + "] Unknown factory policy for " + this.m_serviceSpecification + " : " + this.m_factoryPolicy);
                this.getInstanceManager().stop();
            }
        }
        return svc;
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
    }

    protected synchronized void registerService() {
        if (this.m_serviceRegistration == null) {
            Properties serviceProperties = this.getServiceProperties();
            this.m_serviceRegistration = this.m_handler.getInstanceManager().getContext().registerService(this.m_serviceSpecification, (Object)this, (Dictionary)serviceProperties);
        }
    }

    protected synchronized void unregisterService() {
        if (this.m_serviceRegistration != null) {
            this.m_serviceRegistration.unregister();
            this.m_serviceRegistration = null;
        }
    }

    public int getState() {
        if (this.m_serviceRegistration == null) {
            return 0;
        }
        return 1;
    }

    protected InstanceManager getInstanceManager() {
        return this.m_handler.getInstanceManager();
    }

    private Properties getServiceProperties() {
        Properties serviceProperties = new Properties();
        for (int i = 0; i < this.m_properties.length; ++i) {
            if (this.m_properties[i].get() == null) continue;
            serviceProperties.put(this.m_properties[i].getName(), this.m_properties[i].get());
        }
        return serviceProperties;
    }

    public Property[] getProperties() {
        return this.m_properties;
    }

    public synchronized void update() {
        Properties serviceProperties = this.getServiceProperties();
        if (serviceProperties == null) {
            this.m_handler.getInstanceManager().getFactory().getLogger().log(1, "Cannot get the properties of the provided service");
            this.getInstanceManager().stop();
            return;
        }
        if (this.m_serviceRegistration != null) {
            this.m_serviceRegistration.setProperties((Dictionary)serviceProperties);
        }
    }

    protected void addProperties(Dictionary props) {
        Enumeration keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object value = props.get(key);
            Property prop = new Property(this, key, value);
            this.addProperty(prop);
        }
    }

    protected void deleteProperties(Dictionary props) {
        Enumeration keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.removeProperty(key);
        }
    }

    public String[] getServiceSpecification() {
        return this.m_serviceSpecification;
    }

    public ServiceRegistration getServiceRegistration() {
        return this.m_serviceRegistration;
    }
}

