/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.parser;

import java.util.Dictionary;
import java.util.Properties;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.parser.ParseException;

public class ManifestMetadataParser {
    private Dictionary m_headers;
    private Element[] m_elements = new Element[0];

    public Element[] getComponentsMetadata() throws ParseException {
        int i;
        Element[] components = this.m_elements[0].getElements("Component");
        Element[] composites = this.m_elements[0].getElements("Composite");
        Element[] handlers = this.m_elements[0].getElements("Handler");
        Element[] all = new Element[components.length + composites.length + handlers.length];
        int l = 0;
        for (i = 0; i < components.length; ++i) {
            all[l] = components[i];
            ++l;
        }
        for (i = 0; i < composites.length; ++i) {
            all[l] = composites[i];
            ++l;
        }
        for (i = 0; i < handlers.length; ++i) {
            all[l] = handlers[i];
            ++l;
        }
        return all;
    }

    public Dictionary[] getInstances() throws ParseException {
        Element[] configs = this.m_elements[0].getElements("Instance");
        Dictionary[] dicts = new Dictionary[configs.length];
        for (int i = 0; i < configs.length; ++i) {
            dicts[i] = this.parseInstance(configs[i]);
        }
        return dicts;
    }

    private Dictionary parseInstance(Element instance) throws ParseException {
        Properties dict = new Properties();
        String name = instance.getAttribute("name");
        String comp = instance.getAttribute("component");
        if (name != null) {
            ((Dictionary)dict).put("name", instance.getAttribute("name"));
        }
        if (comp == null) {
            throw new ParseException("An instance does not have the 'component' attribute");
        }
        ((Dictionary)dict).put("component", comp);
        for (int i = 0; i < instance.getElements("property").length; ++i) {
            this.parseProperty(instance.getElements("property")[i], dict);
        }
        return dict;
    }

    private void parseProperty(Element prop, Dictionary dict) throws ParseException {
        String name = prop.getAttribute("name");
        String value = prop.getAttribute("value");
        if (name == null) {
            throw new ParseException("A property does not have the 'name' attribute");
        }
        if (value != null) {
            dict.put(prop.getAttribute("name"), prop.getAttribute("value"));
        } else {
            Element[] subProps = prop.getElements("property");
            if (subProps.length == 0) {
                throw new ParseException("A complex property must have at least one 'property' sub-element");
            }
            Properties dict2 = new Properties();
            for (int i = 0; i < subProps.length; ++i) {
                this.parseProperty(subProps[i], dict2);
                dict.put(name, dict2);
            }
        }
    }

    private void addElement(Element elem) {
        if (this.m_elements != null) {
            Element[] newElementsList = new Element[this.m_elements.length + 1];
            System.arraycopy(this.m_elements, 0, newElementsList, 0, this.m_elements.length);
            newElementsList[this.m_elements.length] = elem;
            this.m_elements = newElementsList;
        } else {
            this.m_elements = new Element[]{elem};
        }
    }

    private Element removeLastElement() {
        int idx = -1;
        idx = this.m_elements.length - 1;
        Element last = this.m_elements[idx];
        if (idx >= 0) {
            if (this.m_elements.length - 1 == 0) {
                this.m_elements = new Element[0];
            } else {
                Element[] newElementsList = new Element[this.m_elements.length - 1];
                System.arraycopy(this.m_elements, 0, newElementsList, 0, idx);
                this.m_elements = newElementsList;
            }
        }
        return last;
    }

    public void parse(Dictionary dict) throws ParseException {
        this.m_headers = dict;
        String componentClassesStr = (String)this.m_headers.get("iPOJO-Components");
        this.addElement(new Element("iPOJO", ""));
        this.parseElements(componentClassesStr.trim());
    }

    public void parseHeader(String header) throws ParseException {
        this.addElement(new Element("iPOJO", ""));
        this.parseElements(header.trim());
    }

    public static Element parse(String metadata) throws ParseException {
        ManifestMetadataParser parser2 = new ManifestMetadataParser();
        parser2.parseElements(metadata);
        if (parser2.m_elements.length != 1) {
            throw new ParseException("Error in parsing, root element not found : " + metadata);
        }
        return parser2.m_elements[0];
    }

    private void parseElements(String s) {
        char[] string = s.toCharArray();
        block5: for (int i = 0; i < string.length; ++i) {
            char c = string[i];
            switch (c) {
                case '$': {
                    String attName = "";
                    String attValue = "";
                    String attNs = "";
                    c = string[++i];
                    while (c != '=') {
                        if (c == ':') {
                            attNs = attName;
                            attName = "";
                        } else {
                            attName = attName + c;
                        }
                        c = string[++i];
                    }
                    ++i;
                    c = string[++i];
                    while (c != '\"') {
                        attValue = attValue + c;
                        c = string[++i];
                    }
                    c = string[++i];
                    Attribute att = new Attribute(attName, attNs, attValue);
                    this.m_elements[this.m_elements.length - 1].addAttribute(att);
                    continue block5;
                }
                case '}': {
                    Element lastElement = this.removeLastElement();
                    if (this.m_elements.length != 0) {
                        Element newQueue = this.m_elements[this.m_elements.length - 1];
                        newQueue.addElement(lastElement);
                        continue block5;
                    }
                    this.addElement(lastElement);
                    continue block5;
                }
                case ' ': {
                    continue block5;
                }
                default: {
                    String name = "";
                    String ns = "";
                    c = string[i];
                    while (c != ' ') {
                        if (c == ':') {
                            ns = name;
                            name = "";
                            c = string[++i];
                            continue;
                        }
                        name = name + c;
                        c = string[++i];
                    }
                    while (string[i] == ' ') {
                        ++i;
                    }
                    ++i;
                    Element elem = new Element(name, ns);
                    this.addElement(elem);
                }
            }
        }
    }
}

