/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.signature;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.security.algorithms.SignatureAlgorithm;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.Manifest;
import org.apache.xml.security.signature.MissingResourceFailureException;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SignedInfo
extends Manifest {
    private SignatureAlgorithm _signatureAlgorithm = null;
    private byte[] _c14nizedBytes = null;

    public SignedInfo(Document document) throws XMLSecurityException {
        this(document, "http://www.w3.org/2000/09/xmldsig#dsa-sha1", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
    }

    public SignedInfo(Document document, String string, String string2) throws XMLSecurityException {
        this(document, string, 0, string2);
    }

    public SignedInfo(Document document, String string, int n, String string2) throws XMLSecurityException {
        super(document);
        Element element = XMLUtils.createElementInSignatureSpace(this._doc, "CanonicalizationMethod");
        element.setAttributeNS(null, "Algorithm", string2);
        this._constructionElement.appendChild(element);
        XMLUtils.addReturnToElement(this._constructionElement);
        this._signatureAlgorithm = n > 0 ? new SignatureAlgorithm(this._doc, string, n) : new SignatureAlgorithm(this._doc, string);
        this._constructionElement.appendChild(this._signatureAlgorithm.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public SignedInfo(Document document, Element element, Element element2) throws XMLSecurityException {
        super(document);
        this._constructionElement.appendChild(element2);
        XMLUtils.addReturnToElement(this._constructionElement);
        this._signatureAlgorithm = new SignatureAlgorithm(element, null);
        this._constructionElement.appendChild(this._signatureAlgorithm.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public SignedInfo(Element element, String string) throws XMLSecurityException {
        super(element, string);
        String string2 = this.getCanonicalizationMethodURI();
        if (!(string2.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315") || string2.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments") || string2.equals("http://www.w3.org/2001/10/xml-exc-c14n#") || string2.equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments"))) {
            try {
                Canonicalizer canonicalizer = Canonicalizer.getInstance(this.getCanonicalizationMethodURI());
                this._c14nizedBytes = canonicalizer.canonicalizeSubtree(this._constructionElement);
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(new ByteArrayInputStream(this._c14nizedBytes));
                Node node = this._doc.importNode(document.getDocumentElement(), true);
                this._constructionElement.getParentNode().replaceChild(node, this._constructionElement);
                this._constructionElement = (Element)node;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new XMLSecurityException("empty", parserConfigurationException);
            }
            catch (IOException iOException) {
                throw new XMLSecurityException("empty", iOException);
            }
            catch (SAXException sAXException) {
                throw new XMLSecurityException("empty", sAXException);
            }
        }
        this._signatureAlgorithm = new SignatureAlgorithm(this.getSignatureMethodElement(), this.getBaseURI());
    }

    public boolean verify() throws MissingResourceFailureException, XMLSecurityException {
        return super.verifyReferences(false);
    }

    public boolean verify(boolean bl) throws MissingResourceFailureException, XMLSecurityException {
        return super.verifyReferences(bl);
    }

    public byte[] getCanonicalizedOctetStream() throws CanonicalizationException, InvalidCanonicalizerException, XMLSecurityException {
        Object object;
        if (this._c14nizedBytes == null) {
            object = Canonicalizer.getInstance(this.getCanonicalizationMethodURI());
            this._c14nizedBytes = ((Canonicalizer)object).canonicalizeSubtree(this._constructionElement);
        }
        object = new byte[this._c14nizedBytes.length];
        System.arraycopy(this._c14nizedBytes, 0, object, 0, ((Object)object).length);
        return object;
    }

    public void signInOctectStream(OutputStream outputStream) throws CanonicalizationException, InvalidCanonicalizerException, XMLSecurityException {
        if (this._c14nizedBytes == null) {
            Canonicalizer canonicalizer = Canonicalizer.getInstance(this.getCanonicalizationMethodURI());
            canonicalizer.setWriter(outputStream);
            canonicalizer.canonicalizeSubtree(this._constructionElement);
        } else {
            try {
                outputStream.write(this._c14nizedBytes);
            }
            catch (IOException iOException) {
                throw new RuntimeException("" + iOException);
            }
        }
    }

    public String getCanonicalizationMethodURI() {
        Element element = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "CanonicalizationMethod", 0);
        if (element == null) {
            return null;
        }
        return element.getAttributeNS(null, "Algorithm");
    }

    public String getSignatureMethodURI() {
        Element element = this.getSignatureMethodElement();
        if (element != null) {
            return element.getAttributeNS(null, "Algorithm");
        }
        return null;
    }

    public Element getSignatureMethodElement() {
        return XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "SignatureMethod", 0);
    }

    public SecretKey createSecretKey(byte[] byArray) {
        return new SecretKeySpec(byArray, this._signatureAlgorithm.getJCEAlgorithmString());
    }

    public String getBaseLocalName() {
        return "SignedInfo";
    }
}

