/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils.resolver.implementations;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.CachedXPathAPIHolder;
import org.apache.xml.security.utils.IdResolver;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.xml.utils.URI;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ResolverFragment
extends ResourceResolverSpi {
    static Log log = LogFactory.getLog((class$org$apache$xml$security$utils$resolver$implementations$ResolverFragment == null ? (class$org$apache$xml$security$utils$resolver$implementations$ResolverFragment = ResolverFragment.class$("org.apache.xml.security.utils.resolver.implementations.ResolverFragment")) : class$org$apache$xml$security$utils$resolver$implementations$ResolverFragment).getName());
    static /* synthetic */ Class class$org$apache$xml$security$utils$resolver$implementations$ResolverFragment;

    public XMLSignatureInput engineResolve(Attr attr, String string) throws ResourceResolverException {
        Object object;
        String string2 = attr.getNodeValue();
        Document document = attr.getOwnerElement().getOwnerDocument();
        Node node = null;
        if (string2.equals("")) {
            log.debug("ResolverFragment with empty URI (means complete document)");
            node = document;
        } else {
            object = string2.substring(1);
            node = IdResolver.getElementById(document, (String)object);
            if (node == null) {
                Object[] objectArray = new Object[]{object};
                throw new ResourceResolverException("signature.Verification.MissingID", objectArray, attr, string);
            }
            if (log.isDebugEnabled()) {
                log.debug("Try to catch an Element with ID " + (String)object + " and Element was " + node);
            }
        }
        CachedXPathAPIHolder.setDoc(document);
        object = new XMLSignatureInput(node);
        ((XMLSignatureInput)object).setExcludeComments(true);
        ((XMLSignatureInput)object).setMIMEType("text/xml");
        try {
            URI uRI = new URI(new URI(string), attr.getNodeValue());
            ((XMLSignatureInput)object).setSourceURI(uRI.toString());
        }
        catch (URI.MalformedURIException malformedURIException) {
            ((XMLSignatureInput)object).setSourceURI(string);
        }
        return object;
    }

    public boolean engineCanResolve(Attr attr, String string) {
        if (attr == null) {
            log.debug("Quick fail for null uri");
            return false;
        }
        String string2 = attr.getNodeValue();
        if (string2.equals("") || string2.startsWith("#") && !string2.startsWith("#xpointer(")) {
            if (log.isDebugEnabled()) {
                log.debug("State I can resolve reference: \"" + string2 + "\"");
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("Do not seem to be able to resolve reference: \"" + string2 + "\"");
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

