/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.xml2mi.lib;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.ClassRef;
import org.objectweb.jorm.metainfo.api.GenClassRef;
import org.objectweb.jorm.metainfo.api.Manager;
import org.objectweb.jorm.metainfo.api.Mapping;
import org.objectweb.jorm.metainfo.api.NameDef;
import org.objectweb.jorm.metainfo.api.PrimitiveElement;
import org.objectweb.jorm.metainfo.api.TypedElement;
import org.objectweb.jorm.util.io.api.PathExplorer;
import org.objectweb.jorm.util.io.lib.DirJavaExplorer;
import org.objectweb.jorm.xml2mi.api.MappingParser;
import org.objectweb.jorm.xml2mi.lib.ParserHelper;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.w3c.dom.Element;

public abstract class BasicMappingParser
extends ParserHelper
implements MappingParser {
    protected Manager metaInfoManager;
    protected Class currentClass;
    protected PathExplorer pathExplorer;
    protected Map idvalue2genclassref;
    static String fileSeparator = System.getProperty("file.separator");

    public void setMetaInfoManager(Manager mim) {
        this.metaInfoManager = mim;
    }

    public void setPathExplorer(PathExplorer pathExpl) {
        this.pathExplorer = pathExpl;
        if (this.pathExplorer == null) {
            this.pathExplorer = new DirJavaExplorer();
        }
    }

    public void setCurrentClass(Class currentClass) {
        this.currentClass = currentClass;
    }

    protected NameDef getRefNameDef(String linkend, String tagName) {
        TypedElement typedElement = null;
        NameDef nameDef = null;
        String fieldName = null;
        String namedefName = null;
        int idx1 = linkend.indexOf("/");
        if (idx1 == 0) {
            int idx2 = linkend.indexOf("/", idx1 + 1);
            String fqcn = linkend.substring(1, idx2);
            int idx3 = linkend.indexOf("/", idx2 + 1);
            fieldName = linkend.substring(idx2 + 1, idx3);
            namedefName = linkend.substring(idx3 + 1);
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)(" fqcn " + fqcn + " fieldname " + fieldName + " namdefname " + namedefName));
            }
            fqcn = fqcn.replace('.', fileSeparator.charAt(0)) + ".pd";
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                if (this.motable.contains(fqcn)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("fqcn is there " + fqcn));
                } else {
                    this.logger.log(BasicLevel.DEBUG, (Object)("fqcn is not there " + fqcn));
                }
            }
            Class clazz = (Class)this.motable.get(fqcn);
            typedElement = clazz.getTypedElement(fieldName);
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Get the field " + fieldName + "defined in <" + clazz.getFQName() + ">: <" + typedElement + ">"));
            }
        } else {
            fieldName = linkend.substring(0, idx1);
            namedefName = linkend.substring(idx1 + 1);
            typedElement = this.currentClass.getTypedElement(fieldName);
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Get the field [" + fieldName + "] in current class <" + this.currentClass.getFQName() + ">: <" + typedElement + ">"));
            }
        }
        if (typedElement instanceof ClassRef) {
            ClassRef classRef = (ClassRef)typedElement;
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Get the ref name def of the ClassRef " + fieldName));
            }
            nameDef = classRef.getRefNameDef(namedefName);
        } else if (typedElement instanceof GenClassRef) {
            GenClassRef genClassRef = (GenClassRef)typedElement;
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Get the ref name def of the GenClassRef " + fieldName));
            }
            nameDef = genClassRef.getRefNameDef(namedefName);
        }
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Returned name def: " + nameDef));
        }
        return nameDef;
    }

    protected NameDef getNameDefFromSuper(String linkend) {
        int idx1 = linkend.indexOf("/");
        if (idx1 == 0) {
            int idx2 = linkend.indexOf("/", idx1 + 1);
            String namedefName = null;
            String fqcn = null;
            if (idx2 != -1) {
                fqcn = linkend.substring(1, idx2);
                namedefName = linkend.substring(idx2 + 1);
            } else {
                fqcn = linkend.substring(1);
                namedefName = "";
            }
            Class superClass = this.currentClass.getSuperClass(fqcn);
            Iterator ndIt = superClass.getNameDefs().iterator();
            while (ndIt.hasNext()) {
                NameDef nd = (NameDef)ndIt.next();
                if (!namedefName.equals(nd.getName())) continue;
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("Returned name def: " + nd));
                }
                return nd;
            }
        }
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("No nameDef found for the linkend " + linkend));
        }
        return null;
    }

    protected PrimitiveElement getPrimitiveElement(String linkend) {
        PrimitiveElement pe = null;
        int idx1 = linkend.indexOf("/");
        if (idx1 == 0) {
            int idx2 = linkend.indexOf("/", idx1 + 1);
            if (idx2 != -1) {
                String fqcn = linkend.substring(1, idx2);
                String fieldname = linkend.substring(idx2 + 1);
                Class superClass = this.currentClass.getSuperClass(fqcn);
                pe = (PrimitiveElement)superClass.getTypedElement(fieldname);
            }
        } else {
            pe = (PrimitiveElement)this.currentClass.getTypedElement(linkend);
        }
        return pe;
    }

    protected String getFieldName(Element nameDef) {
        Element currentElem;
        this.logger.log(BasicLevel.DEBUG, (Object)("Fetching field name of the name def element " + nameDef.getNodeName()));
        for (currentElem = nameDef; currentElem != null && !currentElem.getNodeName().equals("field"); currentElem = (Element)currentElem.getParentNode()) {
            this.logger.log(BasicLevel.DEBUG, (Object)("current: " + currentElem.getNodeName()));
        }
        if (currentElem != null) {
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("last: " + currentElem.getNodeName() + " => name=" + currentElem.getAttribute("name")));
            }
            return currentElem.getAttribute("name");
        }
        return null;
    }

    protected NameDef getClassRefNameDef(Class clazz, String fieldName, String name) {
        NameDef res = null;
        TypedElement typedElement = clazz.getTypedElement(fieldName);
        this.logger.log(BasicLevel.DEBUG, (Object)("Fetching field <" + clazz.getFQName() + "." + fieldName + ">: <" + typedElement + ">"));
        if (typedElement instanceof ClassRef) {
            ClassRef classRef = (ClassRef)typedElement;
            this.logger.log(BasicLevel.DEBUG, (Object)("Fetching name def of the ClassRef " + fieldName));
            res = classRef.getRefNameDef(name);
        } else if (typedElement instanceof GenClassRef) {
            GenClassRef genClassRef;
            this.logger.log(BasicLevel.DEBUG, (Object)("Fetching name def of the ClassRef inside GenClassRef*: " + fieldName));
            for (genClassRef = (GenClassRef)typedElement; genClassRef != null && !genClassRef.isClassRef(); genClassRef = genClassRef.getGenClassRef()) {
            }
            if (genClassRef != null) {
                res = genClassRef.getRefNameDef(name);
            }
        }
        this.logger.log(BasicLevel.DEBUG, (Object)("Returned name def: " + res));
        return res;
    }

    protected int getGenClassNestingLevel(Element fromElem, String fieldName) {
        int nestingLevel = 0;
        Element currentElem = (Element)fromElem.getParentNode();
        while (currentElem != null && !currentElem.getNodeName().equals("field")) {
            if (!(currentElem = (Element)currentElem.getParentNode()).getNodeName().equals("class-ref") && !currentElem.getNodeName().equals("gen-class-ref")) continue;
            ++nestingLevel;
        }
        if (currentElem != null) {
            fieldName = currentElem.getAttribute("field-name");
        }
        return nestingLevel;
    }

    protected NameDef getGenClassRefNameDef(Class clazz, String fieldName, String name, int nestingLevel) {
        NameDef res = null;
        GenClassRef genClassRef = this.getGenClassRef(clazz, fieldName, nestingLevel);
        if (genClassRef != null) {
            res = genClassRef.getRefNameDef(name);
        }
        return res;
    }

    protected GenClassRef getGenClassRef(Class clazz, String fieldName, int nestingLevel) {
        GenClassRef res = null;
        TypedElement typedElement = clazz.getTypedElement(fieldName);
        if (typedElement instanceof GenClassRef) {
            res = (GenClassRef)typedElement;
            GenClassRef genClassRef = (GenClassRef)typedElement;
            while (genClassRef != null && nestingLevel != 0) {
                res = genClassRef.getGenClassRef();
                --nestingLevel;
            }
        }
        return res;
    }

    public abstract void parseMapping(Element var1, Mapping var2) throws PException;

    public void setidvalue2genclassref(Map idvalue2genclassref) {
        this.idvalue2genclassref = idvalue2genclassref;
    }

    public void setmotable(Hashtable motable) {
        this.motable = motable;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setLoggerFactory(LoggerFactory loggerfactory) {
        this.loggerFactory = loggerfactory;
        if (this.logger == null && this.loggerFactory != null) {
            this.logger = this.loggerFactory.getLogger("org.objectweb.jorm.xml2mi.rdb");
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }
}

