/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.eval.prefetch.lib;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.eval.prefetch.api.PrefetchBuffer;
import org.objectweb.medor.eval.prefetch.api.PrefetchBufferHolder;
import org.objectweb.medor.eval.prefetch.lib.PrefetchCacheImpl;
import org.objectweb.medor.tuple.api.Tuple;
import org.objectweb.medor.tuple.api.TupleCollection;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class PrefetchBufferImpl
implements PrefetchBuffer {
    private int indexPos;
    private TupleCollection tupleCollection = null;
    private Map tupleMap = null;
    private Logger logger;
    private boolean multithread;
    private boolean closed;

    PrefetchBufferImpl(int indexpos, boolean multithread, Logger logger) {
        this.indexPos = indexpos;
        this.logger = logger;
        this.multithread = multithread;
        this.closed = false;
    }

    public void addPrefetchTuple() throws MedorException {
        block6: {
            TupleCollection localTC = this.tupleCollection;
            if (localTC == null) {
                return;
            }
            try {
                int row = localTC.getRow();
                if (row < 1) {
                    return;
                }
                if (this.tupleMap == null) {
                    this.tupleMap = new HashMap();
                }
                Tuple pt = localTC.getTuple();
                Object index = pt.getObject(this.indexPos);
                if (this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("Add Tuple in PreftechBuffer:\n\tindex=" + index + "\n\trow=" + row));
                }
                this.tupleMap.put(index, new Integer(row));
            }
            catch (MedorException e) {
                if (this.logger == null) break block6;
                this.logger.log(BasicLevel.WARN, (Object)"Error during the adding of a prefetched tuple: ", (Throwable)e);
            }
        }
    }

    public void setTupleCollection(TupleCollection tc) throws MedorException {
        if (this.tupleCollection != null) {
            throw new MedorException("A tuple collection has already been assigned to this PrefetchBuffer!!");
        }
        this.tupleCollection = tc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Tuple getTuple(Object index) throws MedorException {
        block15: {
            m = this.tupleMap;
            if (m == null) {
                return null;
            }
            i = (Integer)m.get(index);
            if (i == null) {
                return null;
            }
            m.remove(index);
            row = i;
            oldrow = -1;
            res = null;
            localTC = this.tupleCollection;
            if (localTC == null) {
                return null;
            }
            try {
                oldrow = localTC.getRow();
                res = localTC.getTuple(row);
                var10_8 = null;
                ** if (!this.multithread || this.tupleCollection == null || oldrow == row) goto lbl-1000
            }
            catch (Throwable var9_15) {
                var10_10 = null;
                if (this.multithread && this.tupleCollection != null && oldrow != row) {
                    try {
                        localTC.row(oldrow);
                    }
                    catch (MedorException e) {
                        // empty catch block
                    }
                }
                throw var9_15;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    localTC.row(oldrow);
                }
                catch (MedorException e) {}
            }
lbl-1000:
            // 2 sources

            {
                break block15;
                catch (MedorException e) {
                    res = null;
                    var10_9 = null;
                    if (this.multithread && this.tupleCollection != null && oldrow != row) {
                        try {
                            localTC.row(oldrow);
                        }
                        catch (MedorException e) {}
                    }
                }
            }
        }
        if (this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Tuple found :\n\trow=" + row + "\toldrow=" + oldrow + "\n\tindex=" + index + "\n\ttuple=" + PrefetchCacheImpl.printTuple(res)));
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public TupleCollection getTupleCollection(Object index) throws MedorException {
        block15: {
            m = this.tupleMap;
            if (m == null) {
                return null;
            }
            i = (Integer)m.get(index);
            if (i == null) {
                return null;
            }
            m.remove(index);
            row = i;
            oldrow = -1;
            res = null;
            localTC = this.tupleCollection;
            if (localTC == null) {
                return null;
            }
            try {
                oldrow = localTC.getRow();
                localTC.getTuple(row);
                res = localTC;
                var10_8 = null;
                ** if (!this.multithread || this.tupleCollection == null || oldrow == row) goto lbl-1000
            }
            catch (Throwable var9_15) {
                var10_10 = null;
                if (this.multithread && this.tupleCollection != null && oldrow != row) {
                    try {
                        localTC.row(oldrow);
                    }
                    catch (MedorException e) {
                        // empty catch block
                    }
                }
                throw var9_15;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    localTC.row(oldrow);
                }
                catch (MedorException e) {}
            }
lbl-1000:
            // 2 sources

            {
                break block15;
                catch (MedorException e) {
                    res = null;
                    var10_9 = null;
                    if (this.multithread && this.tupleCollection != null && oldrow != row) {
                        try {
                            localTC.row(oldrow);
                        }
                        catch (MedorException e) {}
                    }
                }
            }
        }
        if (this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Tuple found :\n\trow=" + row + "\toldrow=" + oldrow + "\n\tindex=" + index + "\n\ttuple=" + PrefetchCacheImpl.printTuple(res.getTuple())));
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws MedorException {
        this.closed = true;
        if (this.tupleCollection != null) {
            if (this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Closing PrefetchBuffer: " + this));
            }
            try {
                ((PrefetchBufferHolder)((Object)this.tupleCollection)).invalidatePrefetchBuffer();
            }
            finally {
                this.tupleCollection = null;
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }
}

