/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.controller.client;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.ejb.EJBObject;
import net.jcip.annotations.ThreadSafe;
import org.ow2.carol.cmi.lb.data.LBPolicyData;
import org.ow2.carol.cmi.lb.policy.ILBPolicy;
import org.ow2.carol.cmi.lb.strategy.ILBStrategy;
import org.ow2.carol.cmi.reference.CMIReference;
import org.ow2.carol.cmi.reference.ServerRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
final class ClientClusterViewCache {
    private final Map<String, LBPolicyData> lbPolicyData = new ConcurrentHashMap<String, LBPolicyData>();
    private final Map<String, Class<?>> itfNames = new ConcurrentHashMap();
    private final Set<String> replicatedObjects = Collections.synchronizedSet(new HashSet());
    private final Set<String> statefulObjects = Collections.synchronizedSet(new HashSet());
    private final Map<String, Class<? extends EJBObject>> businessNames = new ConcurrentHashMap<String, Class<? extends EJBObject>>();
    private final Map<String, Class<? extends ILBPolicy>> lbPolicyClasses = new ConcurrentHashMap<String, Class<? extends ILBPolicy>>();
    private final Map<String, Class<? extends ILBStrategy>> lbStrategyClasses = new ConcurrentHashMap<String, Class<? extends ILBStrategy>>();
    private final Map<String, List<CMIReference>> cmiReferences = new ConcurrentHashMap<String, List<CMIReference>>();
    private final Map<ServerRef, Integer> loadFactors = new ConcurrentHashMap<ServerRef, Integer>();
    private final Map<String, Set<String>> applicationExceptionNames = new ConcurrentHashMap<String, Set<String>>();

    void setLBPolicyData(String objectName, LBPolicyData lbPolicyData) {
        this.lbPolicyData.put(objectName, lbPolicyData);
    }

    LBPolicyData getLBPolicyData(String objectName) {
        return this.lbPolicyData.get(objectName);
    }

    void setItfName(String objectName, Class<?> itfName) {
        this.itfNames.put(objectName, itfName);
    }

    Class<?> getItfName(String objectName) {
        return this.itfNames.get(objectName);
    }

    void setBusinessName(String objectName, Class<? extends EJBObject> businessName) {
        this.businessNames.put(objectName, businessName);
    }

    Class<? extends EJBObject> getBusinessName(String objectName) {
        return this.businessNames.get(objectName);
    }

    Class<? extends ILBPolicy> getLBPolicyClass(String className) {
        return this.lbPolicyClasses.get(className);
    }

    void setLBPolicyClass(String className, Class<? extends ILBPolicy> lbPolicyClass) {
        this.lbPolicyClasses.put(className, lbPolicyClass);
    }

    void setCMIReferences(String objectName, List<CMIReference> cmiReferences) {
        this.cmiReferences.put(objectName, cmiReferences);
    }

    List<CMIReference> getCMIReferences(String objectName) {
        return this.cmiReferences.get(objectName);
    }

    Class<? extends ILBStrategy> getLBStrategyClass(String className) {
        return this.lbStrategyClasses.get(className);
    }

    void setLBStrategyClass(String className, Class<? extends ILBStrategy> lbStrategyClass) {
        this.lbStrategyClasses.put(className, lbStrategyClass);
    }

    int getLoadFactor(ServerRef serverRef) {
        return this.loadFactors.get(serverRef);
    }

    void setLoadFactor(ServerRef serverRef, int loadFactor) {
        this.loadFactors.put(serverRef, loadFactor);
    }

    Set<ServerRef> getAddressesOfServer() {
        return this.loadFactors.keySet();
    }

    Set<String> getObjectNames() {
        return new HashSet<String>(this.itfNames.keySet());
    }

    boolean hasState(String objectName) {
        return this.statefulObjects.contains(objectName);
    }

    void setState(String objectName) {
        this.statefulObjects.add(objectName);
    }

    boolean isReplicated(String objectName) {
        return this.replicatedObjects.contains(objectName);
    }

    void setReplicated(String objectName) {
        this.replicatedObjects.add(objectName);
    }

    Set<String> getApplicationExceptionNames(String objectName) {
        return this.applicationExceptionNames.get(objectName);
    }

    void setApplicationExceptionNames(String objectName, Set<String> applicationExceptionNames) {
        this.applicationExceptionNames.put(objectName, applicationExceptionNames);
    }
}

