/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.info;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJBObject;
import net.jcip.annotations.Immutable;
import org.ow2.carol.cmi.annotation.Cluster;
import org.ow2.carol.cmi.annotation.LBArrayProperty;
import org.ow2.carol.cmi.annotation.LBPolicy;
import org.ow2.carol.cmi.annotation.LBProperties;
import org.ow2.carol.cmi.annotation.LBProperty;
import org.ow2.carol.cmi.annotation.LBStrategy;
import org.ow2.carol.cmi.info.CMIInfoExtractorException;
import org.ow2.carol.cmi.info.ClusteredObjectInfo;
import org.ow2.carol.cmi.info.mapping.LBArrayPropertyInfo;
import org.ow2.carol.cmi.info.mapping.LBPropertiesInfo;
import org.ow2.carol.cmi.info.mapping.LBPropertyInfo;
import org.ow2.carol.cmi.info.mapping.MappedClusteredObjectInfo;
import org.ow2.carol.cmi.info.mapping.MappedClusteredObjects;
import org.ow2.carol.cmi.info.mapping.PoolInfo;
import org.ow2.carol.cmi.lb.PropertyConfigurationException;
import org.ow2.carol.cmi.lb.policy.ILBPolicy;
import org.ow2.carol.cmi.lb.strategy.NoStrategy;
import org.ow2.carol.cmi.lb.util.LBPolicyFactory;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.xmlconfig.XMLConfiguration;
import org.ow2.util.xmlconfig.XMLConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public final class CMIInfoExtractor {
    private static Log logger = LogFactory.getLog(CMIInfoExtractor.class);

    private CMIInfoExtractor() {
    }

    public static ClusteredObjectInfo extractClusteringInfoFromAnnotatedPOJO(Class<?> itfName, Class<?> impl, boolean stateful, boolean replicated, Set<String> applicationExceptionNames) throws CMIInfoExtractorException {
        Cluster cluster = impl.getAnnotation(Cluster.class);
        if (cluster == null) {
            logger.info("No annotation @Cluster found", new Object[0]);
            return null;
        }
        String clusterName = cluster.name();
        int minPoolSize = cluster.minPoolSize();
        int maxPoolSize = cluster.maxPoolSize();
        LBPolicy lbPolicy = impl.getAnnotation(LBPolicy.class);
        if (lbPolicy == null) {
            logger.error("No annotation @LBPolicy found !", new Object[0]);
            throw new CMIInfoExtractorException("No annotation @LBPolicy found !");
        }
        Class<? extends ILBPolicy> lbPolicyType = lbPolicy.value();
        LBStrategy lbStrategy = impl.getAnnotation(LBStrategy.class);
        Class lbStrategyType = null;
        lbStrategyType = lbStrategy != null ? lbStrategy.value() : NoStrategy.class;
        HashMap<String, Object> policyProperties = null;
        LBProperties aLBProperties = impl.getAnnotation(LBProperties.class);
        if (aLBProperties != null) {
            String propertyName;
            LBProperty[] lbProperties = aLBProperties.value();
            LBArrayProperty[] lbArrayProperties = aLBProperties.values();
            policyProperties = new HashMap<String, Object>();
            for (LBProperty lBProperty : lbProperties) {
                Object propertyValue;
                propertyName = lBProperty.name();
                String svalue = lBProperty.value();
                try {
                    propertyValue = LBPolicyFactory.convertString(lbPolicyType, propertyName, svalue);
                }
                catch (PropertyConfigurationException e) {
                    throw new CMIInfoExtractorException("Cannot cast properties", e);
                }
                logger.debug("Adding pair ({0},{1})", propertyName, propertyValue);
                policyProperties.put(propertyName, propertyValue);
            }
            for (Annotation annotation : lbArrayProperties) {
                List<?> propertyValues;
                propertyName = annotation.name();
                String[] svalues = annotation.values();
                try {
                    propertyValues = LBPolicyFactory.convertStrings(lbPolicyType, propertyName, Arrays.asList(svalues));
                }
                catch (PropertyConfigurationException e) {
                    throw new CMIInfoExtractorException("Cannot cast properties", e);
                }
                logger.debug("Adding pair ({0},{1})", propertyName, propertyValues);
                policyProperties.put(propertyName, propertyValues);
            }
        }
        return new ClusteredObjectInfo(itfName, null, clusterName, minPoolSize, maxPoolSize, lbPolicyType, lbStrategyType, policyProperties, stateful, replicated, applicationExceptionNames);
    }

    public static ClusteredObjectInfo extractClusteringInfoFromDD(Class<?> itfClass, Class<? extends EJBObject> businessClass, URL url, boolean stateful, boolean replicated, Set<String> applicationExceptionNames) throws CMIInfoExtractorException {
        Class lbStrategyClass;
        Class<?> lbPolicyClass;
        XMLConfiguration xmlConfiguration = new XMLConfiguration(url, "http://cmi.ow2.org/xml/ns/mapping", "cmi-mapping.xml");
        MappedClusteredObjects mappedClusteredObjects = new MappedClusteredObjects();
        try {
            xmlConfiguration.configure(mappedClusteredObjects);
        }
        catch (XMLConfigurationException e) {
            logger.error("Cannot set informations for the clustered object with interface {0}", itfClass.getName(), e);
            throw new CMIInfoExtractorException("Cannot set informations for the clustered object with interface " + itfClass.getName(), e);
        }
        List<MappedClusteredObjectInfo> mappedClusteredObjectInfos = mappedClusteredObjects.getMappedClusteredObjectInfos();
        logger.debug("Clustered objects found: {0}", mappedClusteredObjectInfos);
        MappedClusteredObjectInfo mappedClusteredObjectInfo = mappedClusteredObjectInfos.get(0);
        String clusterName = mappedClusteredObjectInfo.getClusterName();
        if (clusterName == null || clusterName.equals("")) {
            logger.error("The cluster name is not set", new Object[0]);
            throw new CMIInfoExtractorException("The cluster name is not set");
        }
        String lbPolicyClassName = mappedClusteredObjectInfo.getPolicyType();
        if (lbPolicyClassName == null || lbPolicyClassName.equals("")) {
            logger.error("The LB policy name is not set", new Object[0]);
            throw new CMIInfoExtractorException("The LB policy name is not set");
        }
        try {
            lbPolicyClass = Class.forName(lbPolicyClassName);
        }
        catch (ClassNotFoundException e) {
            logger.error("Cannot load the class {0} that define a LB policy", lbPolicyClassName, e);
            throw new CMIInfoExtractorException("Cannot load the class " + lbPolicyClassName + " that define a LB policy", e);
        }
        String lbStrategyClassName = mappedClusteredObjectInfo.getStrategyType();
        if (lbStrategyClassName == null || lbStrategyClassName.equals("")) {
            lbStrategyClass = NoStrategy.class;
        } else {
            try {
                lbStrategyClass = Class.forName(lbStrategyClassName);
            }
            catch (ClassNotFoundException e) {
                logger.error("Cannot load the class {0} that define a LB strategy", lbStrategyClassName, e);
                throw new CMIInfoExtractorException("Cannot load the class " + lbStrategyClassName + " that define a LB strategy", e);
            }
        }
        PoolInfo poolInfo = mappedClusteredObjectInfo.getPoolInfo();
        int minPoolSize = -1;
        int maxPoolSize = -1;
        if (poolInfo != null) {
            minPoolSize = poolInfo.getMinPoolSize();
            maxPoolSize = poolInfo.getMaxPoolSize();
        }
        LBPropertiesInfo lbPropertiesInfo = mappedClusteredObjectInfo.getLBPropertiesInfo();
        Map<String, Object> policyProperties = null;
        if (lbPropertiesInfo != null) {
            try {
                policyProperties = CMIInfoExtractor.extractLBProperties(lbPolicyClass, lbPropertiesInfo);
            }
            catch (PropertyConfigurationException e) {
                logger.error("Cannot convert properties", e);
                throw new CMIInfoExtractorException("Cannot convert properties", e);
            }
        }
        return new ClusteredObjectInfo(itfClass, businessClass, clusterName, minPoolSize, maxPoolSize, lbPolicyClass, lbStrategyClass, policyProperties, stateful, replicated, applicationExceptionNames);
    }

    private static Map<String, Object> extractLBProperties(Class<? extends ILBPolicy> lbPolicyClass, LBPropertiesInfo lbPropertiesInfo) throws PropertyConfigurationException {
        String propertyName;
        HashMap<String, Object> policyProperties = new HashMap<String, Object>();
        for (LBPropertyInfo lbPropertyInfo : lbPropertiesInfo.getLBPropertyInfos()) {
            propertyName = lbPropertyInfo.getName();
            String svalue = lbPropertyInfo.getValue();
            Object propertyValue = LBPolicyFactory.convertString(lbPolicyClass, propertyName, svalue);
            logger.debug("Adding pair ({0},{1})", propertyName, propertyValue);
            policyProperties.put(propertyName, propertyValue);
        }
        for (LBArrayPropertyInfo lbArrayPropertyInfo : lbPropertiesInfo.getLBArrayPropertyInfos()) {
            propertyName = lbArrayPropertyInfo.getName();
            ArrayList<String> svalues = new ArrayList<String>();
            for (String lbValue : lbArrayPropertyInfo.getValues()) {
                svalues.add(lbValue);
            }
            List<?> propertyValues = LBPolicyFactory.convertStrings(lbPolicyClass, propertyName, svalues);
            logger.debug("Adding pair ({0},{1})", propertyName, propertyValues);
            policyProperties.put(propertyName, propertyValues);
        }
        return policyProperties;
    }
}

