/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.jndi.ns;

import java.io.InputStream;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.omg.CORBA.ORB;
import org.ow2.carol.jndi.ns.AbsRegistry;
import org.ow2.carol.jndi.ns.NameService;
import org.ow2.carol.jndi.ns.NameServiceException;
import org.ow2.carol.jndi.spi.URLInitialContextFactory;
import org.ow2.carol.util.configuration.TraceCarol;

public class IIOPCosNaming
extends AbsRegistry
implements NameService {
    private static final int DEFAULT_PORT_NUMBER = 12350;
    private static final int SLEEP_TIME = 2000;
    private Process cosNamingProcess = null;
    private static ORB orb = null;

    public IIOPCosNaming() {
        super(12350);
    }

    public void start() throws NameServiceException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("IIOPCosNaming.start() on port:" + this.getPort());
        }
        try {
            if (!this.isStarted()) {
                if (this.getPort() >= 0) {
                    this.cosNamingProcess = Runtime.getRuntime().exec(System.getProperty("java.home") + System.getProperty("file.separator") + "bin" + System.getProperty("file.separator") + "tnameserv -ORBInitialPort " + this.getPort());
                    Thread.sleep(2000L);
                    InputStream cosError = this.cosNamingProcess.getErrorStream();
                    if (cosError.available() != 0) {
                        byte[] b = new byte[cosError.available()];
                        cosError.read(b);
                        cosError.close();
                        throw new NameServiceException("can not start cosnaming daemon:" + new String(b));
                    }
                    InputStream cosOut = this.cosNamingProcess.getInputStream();
                    if (cosOut.available() != 0) {
                        byte[] b = new byte[cosOut.available()];
                        cosOut.read(b);
                        cosOut.close();
                        if (TraceCarol.isDebugJndiCarol()) {
                            TraceCarol.debugJndiCarol("IIOPCosNaming:");
                            TraceCarol.debugJndiCarol(new String(b));
                        }
                    }
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        public void run() {
                            try {
                                IIOPCosNaming.this.stop();
                            }
                            catch (Exception e) {
                                TraceCarol.error("IIOPCosNaming ShutdownHook problem", e);
                            }
                        }
                    });
                } else if (TraceCarol.isDebugJndiCarol()) {
                    TraceCarol.debugJndiCarol("Can't start IIOPCosNaming, port=" + this.getPort() + " is < 0");
                }
            } else if (TraceCarol.isDebugJndiCarol()) {
                TraceCarol.debugJndiCarol("IIOPCosNaming is already start on port:" + this.getPort());
            }
        }
        catch (Exception e) {
            TraceCarol.error("Can not start IIOPCosNaming for an unknow Reason", e);
            throw new NameServiceException("can not start cosnaming daemon: " + e);
        }
    }

    public void stop() throws NameServiceException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("IIOPCosNaming.stop()");
        }
        try {
            if (this.cosNamingProcess != null) {
                this.cosNamingProcess.destroy();
            }
            this.cosNamingProcess = null;
        }
        catch (Exception e) {
            throw new NameServiceException("can not stop cosnaming daemon: " + e);
        }
    }

    public boolean isStarted() {
        if (this.cosNamingProcess != null) {
            return true;
        }
        Properties prop = new Properties();
        prop.put("java.naming.factory.initial", URLInitialContextFactory.class.getName());
        prop.put("java.naming.provider.url", "iiop://localhost:" + this.getPort());
        if (orb == null) {
            IIOPCosNaming.initORB();
        }
        prop.put("java.naming.corba.orb", orb);
        try {
            new InitialContext(prop);
        }
        catch (NamingException ex) {
            return false;
        }
        return true;
    }

    public static ORB getOrb() {
        if (orb == null) {
            IIOPCosNaming.initORB();
        }
        return orb;
    }

    private static void initORB() {
        orb = ORB.init(new String[0], null);
    }
}

