/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.util.configuration;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProviderURLsParser {
    private static String scheme = "";
    private static final int URL_HOSTPORT_INDEX = 2;
    private static Map<String, String> mapping = new HashMap<String, String>();

    private ProviderURLsParser() {
    }

    private static void parseScheme(String protocol, String inputscheme) throws MalformedURLException {
        if (inputscheme.length() == 0) {
            scheme = "";
        } else {
            if (inputscheme.length() <= 1 || !inputscheme.endsWith(":")) {
                throw new MalformedURLException("badly formed scheme");
            }
            scheme = inputscheme.substring(0, inputscheme.length() - 1);
            if (!ProviderURLsParser.isConsistent(protocol, scheme)) {
                throw new MalformedURLException("Invalid scheme : " + scheme);
            }
        }
    }

    private static boolean isConsistent(String protocol, String scheme) throws MalformedURLException {
        String sch = mapping.get(protocol);
        if (sch == null) {
            throw new MalformedURLException("Invalid protocol: " + protocol);
        }
        return sch.equals(scheme);
    }

    private static List<String> parseName(String inputurl) throws MalformedURLException {
        String inputhostport = "";
        int n = inputurl.indexOf("/", 2);
        if (n != -1 || inputurl.length() <= 2) {
            throw new MalformedURLException("The syntax for URL is: <scheme>://<host>:<port>(,<host>:<port>)*");
        }
        inputhostport = inputurl.substring(2);
        return ProviderURLsParser.parseHostsPorts(inputhostport);
    }

    private static List<String> parseHostsPorts(String inputhostsports) throws MalformedURLException {
        int end;
        int start = 0;
        ArrayList<String> providerURLs = new ArrayList<String>();
        do {
            if ((end = inputhostsports.indexOf(44, start)) < 0) {
                providerURLs.add(scheme + "://" + inputhostsports.substring(start));
                continue;
            }
            providerURLs.add(scheme + "://" + inputhostsports.substring(start, end));
        } while ((start = end + 1) > 0);
        return providerURLs;
    }

    public static List<String> parse(String protocol, String input) throws MalformedURLException {
        if (input == null || input.length() == 0) {
            throw new MalformedURLException("null or empty registry URL");
        }
        if (input.indexOf("//") == -1) {
            throw new MalformedURLException("badly formed registry URL " + input);
        }
        try {
            ProviderURLsParser.parseScheme(protocol, input.substring(0, input.indexOf("//")));
            return ProviderURLsParser.parseName(input.substring(input.indexOf("//")));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MalformedURLException("badly formed registry URL " + input);
        }
    }

    static {
        mapping.put("jrmp", "rmi");
        mapping.put("irmi", "rmi");
        mapping.put("iiop", "iiop");
    }
}

