/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.annotations.analyzer;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import org.ow2.easybeans.asm.ClassReader;
import org.ow2.easybeans.deployment.annotations.analyzer.AnnotationNameFilter;
import org.ow2.easybeans.deployment.annotations.analyzer.ScanClassVisitor;
import org.ow2.easybeans.deployment.annotations.exceptions.AnalyzerException;
import org.ow2.easybeans.deployment.annotations.metadata.EjbJarAnnotationMetadata;
import org.ow2.util.ee.deploy.api.archive.ArchiveException;
import org.ow2.util.ee.deploy.api.archive.IArchive;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class AnnotationDeploymentAnalyzer {
    private IArchive archive = null;
    private EjbJarAnnotationMetadata ejbJarAnnotationMetadata = null;
    private static Log logger = LogFactory.getLog(AnnotationDeploymentAnalyzer.class);
    private ScanClassVisitor scanVisitor = null;

    public AnnotationDeploymentAnalyzer(IArchive archive) {
        this.archive = archive;
        this.ejbJarAnnotationMetadata = new EjbJarAnnotationMetadata();
        this.scanVisitor = new ScanClassVisitor(this.ejbJarAnnotationMetadata);
    }

    public AnnotationDeploymentAnalyzer(IArchive archive, AnnotationNameFilter annotationNameFilter) {
        this.archive = archive;
        this.ejbJarAnnotationMetadata = new EjbJarAnnotationMetadata();
        this.scanVisitor = new ScanClassVisitor(this.ejbJarAnnotationMetadata, annotationNameFilter);
    }

    public void analyze() throws AnalyzerException {
        try {
            Iterator<URL> iterator = this.archive.getResources();
            while (iterator.hasNext()) {
                URL url = iterator.next();
                if (!url.getPath().toLowerCase().endsWith(".class")) continue;
                InputStream is = null;
                try {
                    URLConnection urlConnection = url.openConnection();
                    urlConnection.setDefaultUseCaches(false);
                    is = urlConnection.getInputStream();
                    new ClassReader(is).accept(this.scanVisitor, 0);
                }
                catch (Exception ioe) {
                    throw new AnalyzerException("Error while analyzing file entry '" + url + "' in archive '" + this.archive.getName() + "'", ioe);
                }
                finally {
                    if (is == null) continue;
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        throw new AnalyzerException("Error while closing input stream of the entry '" + url + "' in archive '" + this.archive.getName() + "'", e);
                    }
                }
            }
        }
        catch (ArchiveException e) {
            throw new AnalyzerException("Error while analyzing archive '" + this.archive.getName() + "'", e);
        }
        finally {
            this.archive.close();
        }
    }

    public EjbJarAnnotationMetadata getEjbJarAnnotationMetadata() {
        return this.ejbJarAnnotationMetadata;
    }
}

