/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.annotations.analyzer;

import org.ow2.easybeans.asm.ClassVisitor;
import org.ow2.easybeans.asm.FieldVisitor;
import org.ow2.easybeans.asm.MethodVisitor;
import org.ow2.easybeans.deployment.annotations.JField;
import org.ow2.easybeans.deployment.annotations.JMethod;
import org.ow2.easybeans.deployment.annotations.analyzer.AnnotationNameFilter;
import org.ow2.easybeans.deployment.annotations.analyzer.JavaxAnnotationSecurityPermitAllVisitor;
import org.ow2.easybeans.deployment.annotations.analyzer.JavaxAnnotationSecurityRolesAllowedVisitor;
import org.ow2.easybeans.deployment.annotations.analyzer.JavaxEjbTransactionAttributeVisitor;
import org.ow2.easybeans.deployment.annotations.analyzer.JavaxInterceptorExcludeDefaultInterceptorsVisitor;
import org.ow2.easybeans.deployment.annotations.analyzer.JavaxInterceptorInterceptorsVisitor;
import org.ow2.easybeans.deployment.annotations.analyzer.ScanCommonVisitor;
import org.ow2.easybeans.deployment.annotations.analyzer.ScanFieldVisitor;
import org.ow2.easybeans.deployment.annotations.analyzer.ScanMethodVisitor;
import org.ow2.easybeans.deployment.annotations.analyzer.classes.JavaxAnnotationResourcesVisitor;
import org.ow2.easybeans.deployment.annotations.analyzer.classes.JavaxAnnotationSecurityDeclareRolesVisitor;
import org.ow2.easybeans.deployment.annotations.analyzer.classes.JavaxAnnotationSecurityRunAs;
import org.ow2.easybeans.deployment.annotations.analyzer.classes.JavaxEjbApplicationExceptionVisitor;
import org.ow2.easybeans.deployment.annotations.analyzer.classes.JavaxEjbEJBsVisitor;
import org.ow2.easybeans.deployment.annotations.analyzer.classes.JavaxEjbLocalHomeVisitor;
import org.ow2.easybeans.deployment.annotations.analyzer.classes.JavaxEjbLocalVisitor;
import org.ow2.easybeans.deployment.annotations.analyzer.classes.JavaxEjbMessageDrivenVisitor;
import org.ow2.easybeans.deployment.annotations.analyzer.classes.JavaxEjbRemoteHomeVisitor;
import org.ow2.easybeans.deployment.annotations.analyzer.classes.JavaxEjbRemoteVisitor;
import org.ow2.easybeans.deployment.annotations.analyzer.classes.JavaxEjbStatefulVisitor;
import org.ow2.easybeans.deployment.annotations.analyzer.classes.JavaxEjbStatelessVisitor;
import org.ow2.easybeans.deployment.annotations.analyzer.classes.JavaxEjbTransactionManagementVisitor;
import org.ow2.easybeans.deployment.annotations.analyzer.classes.JavaxPersistencePersistenceContextsVisitor;
import org.ow2.easybeans.deployment.annotations.analyzer.classes.JavaxPersistencePersistenceUnitsVisitor;
import org.ow2.easybeans.deployment.annotations.metadata.ClassAnnotationMetadata;
import org.ow2.easybeans.deployment.annotations.metadata.EjbJarAnnotationMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScanClassVisitor
extends ScanCommonVisitor<ClassAnnotationMetadata>
implements ClassVisitor {
    private ClassAnnotationMetadata classAnnotationMetadata = null;
    private EjbJarAnnotationMetadata ejbJarAnnotationMetadata = null;

    public ScanClassVisitor(EjbJarAnnotationMetadata ejbJarAnnotationMetadata) {
        this.ejbJarAnnotationMetadata = ejbJarAnnotationMetadata;
    }

    public ScanClassVisitor(EjbJarAnnotationMetadata ejbJarAnnotationMetadata, AnnotationNameFilter annotationNameFilter) {
        super(annotationNameFilter);
        this.ejbJarAnnotationMetadata = ejbJarAnnotationMetadata;
    }

    private void init(String className, String superName, String[] interfaces) {
        this.classAnnotationMetadata = new ClassAnnotationMetadata(className, this.ejbJarAnnotationMetadata);
        this.classAnnotationMetadata.setSuperName(superName);
        this.classAnnotationMetadata.setInterfaces(interfaces);
        this.initVisitors();
    }

    protected void initVisitors() {
        super.initVisitors(this.classAnnotationMetadata);
        this.getAnnotationVisitors().put("Ljavax/ejb/Local;", new JavaxEjbLocalVisitor(this.classAnnotationMetadata));
        this.getAnnotationVisitors().put("Ljavax/ejb/Remote;", new JavaxEjbRemoteVisitor(this.classAnnotationMetadata));
        this.getAnnotationVisitors().put("Ljavax/ejb/Stateless;", new JavaxEjbStatelessVisitor(this.classAnnotationMetadata));
        this.getAnnotationVisitors().put("Ljavax/ejb/Stateful;", new JavaxEjbStatefulVisitor(this.classAnnotationMetadata));
        this.getAnnotationVisitors().put("Ljavax/ejb/MessageDriven;", new JavaxEjbMessageDrivenVisitor(this.classAnnotationMetadata));
        this.getAnnotationVisitors().put("Ljavax/ejb/LocalHome;", new JavaxEjbLocalHomeVisitor(this.classAnnotationMetadata));
        this.getAnnotationVisitors().put("Ljavax/ejb/RemoteHome;", new JavaxEjbRemoteHomeVisitor(this.classAnnotationMetadata));
        this.getAnnotationVisitors().put("Ljavax/ejb/TransactionManagement;", new JavaxEjbTransactionManagementVisitor(this.classAnnotationMetadata));
        this.getAnnotationVisitors().put("Ljavax/ejb/TransactionAttribute;", new JavaxEjbTransactionAttributeVisitor<ClassAnnotationMetadata>(this.classAnnotationMetadata));
        this.getAnnotationVisitors().put("Ljavax/interceptor/Interceptors;", new JavaxInterceptorInterceptorsVisitor<ClassAnnotationMetadata>(this.classAnnotationMetadata));
        this.getAnnotationVisitors().put("Ljavax/ejb/ApplicationException;", new JavaxEjbApplicationExceptionVisitor(this.classAnnotationMetadata));
        this.getAnnotationVisitors().put("Ljavax/ejb/EJBs;", new JavaxEjbEJBsVisitor(this.classAnnotationMetadata));
        this.getAnnotationVisitors().put("Ljavax/annotation/Resources;", new JavaxAnnotationResourcesVisitor(this.classAnnotationMetadata));
        this.getAnnotationVisitors().put("Ljavax/persistence/PersistenceContexts;", new JavaxPersistencePersistenceContextsVisitor(this.classAnnotationMetadata));
        this.getAnnotationVisitors().put("Ljavax/persistence/PersistenceUnits;", new JavaxPersistencePersistenceUnitsVisitor(this.classAnnotationMetadata));
        this.getAnnotationVisitors().put("Ljavax/annotation/security/DeclareRoles;", new JavaxAnnotationSecurityDeclareRolesVisitor(this.classAnnotationMetadata));
        this.getAnnotationVisitors().put("Ljavax/annotation/security/RolesAllowed;", new JavaxAnnotationSecurityRolesAllowedVisitor<ClassAnnotationMetadata>(this.classAnnotationMetadata));
        this.getAnnotationVisitors().put("Ljavax/annotation/security/PermitAll;", new JavaxAnnotationSecurityPermitAllVisitor<ClassAnnotationMetadata>(this.classAnnotationMetadata));
        this.getAnnotationVisitors().put("Ljavax/annotation/security/RunAs;", new JavaxAnnotationSecurityRunAs(this.classAnnotationMetadata));
        this.getAnnotationVisitors().put("Ljavax/interceptor/ExcludeDefaultInterceptors;", new JavaxInterceptorExcludeDefaultInterceptorsVisitor<ClassAnnotationMetadata>(this.classAnnotationMetadata));
    }

    @Override
    public void visit(int version2, int access, String name, String signature, String superName, String[] interfaces) {
        this.init(name, superName, interfaces);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        JMethod jMethod = new JMethod(access, name, desc, signature, exceptions);
        return new ScanMethodVisitor(jMethod, this.classAnnotationMetadata);
    }

    @Override
    public void visitEnd() {
        this.ejbJarAnnotationMetadata.addClassAnnotationMetadata(this.classAnnotationMetadata);
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        JField jField = new JField(access, name, desc, signature, value);
        return new ScanFieldVisitor(jField, this.classAnnotationMetadata);
    }
}

