/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.annotations.analyzer;

import java.util.HashMap;
import java.util.Map;
import org.ow2.easybeans.asm.AnnotationVisitor;
import org.ow2.easybeans.asm.commons.EmptyVisitor;
import org.ow2.easybeans.deployment.annotations.JUnknownAnnotation;
import org.ow2.easybeans.deployment.annotations.analyzer.AnnotationNameFilter;
import org.ow2.easybeans.deployment.annotations.analyzer.JavaxAnnotationResourceVisitor;
import org.ow2.easybeans.deployment.annotations.analyzer.JavaxEjbEJBVisitor;
import org.ow2.easybeans.deployment.annotations.analyzer.JavaxPersistencePersistenceContextVisitor;
import org.ow2.easybeans.deployment.annotations.analyzer.JavaxPersistencePersistenceUnitVisitor;
import org.ow2.easybeans.deployment.annotations.analyzer.ScanUnknownAnnotationVisitor;
import org.ow2.easybeans.deployment.annotations.metadata.interfaces.ISharedMetadata;
import org.ow2.easybeans.deployment.annotations.metadata.interfaces.IUnknownAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScanCommonVisitor<T extends ISharedMetadata>
extends EmptyVisitor {
    private static final AnnotationVisitor EMPTY_VISITOR = new EmptyVisitor();
    private Map<String, AnnotationVisitor> annotationVisitors = new HashMap<String, AnnotationVisitor>();
    private AnnotationNameFilter annotationNameFilter = null;
    private T annotationMetadata = null;

    public ScanCommonVisitor() {
    }

    public ScanCommonVisitor(AnnotationNameFilter annotationNameFilter) {
        this.annotationNameFilter = annotationNameFilter;
    }

    protected void initVisitors(T annotationMetadata) {
        this.annotationMetadata = annotationMetadata;
        this.annotationVisitors.put("Ljavax/ejb/EJB;", new JavaxEjbEJBVisitor<T>(annotationMetadata));
        this.annotationVisitors.put("Ljavax/annotation/Resource;", new JavaxAnnotationResourceVisitor<T>(annotationMetadata));
        this.annotationVisitors.put("Ljavax/persistence/PersistenceContext;", new JavaxPersistencePersistenceContextVisitor<T>(annotationMetadata));
        this.annotationVisitors.put("Ljavax/persistence/PersistenceUnit;", new JavaxPersistencePersistenceUnitVisitor<T>(annotationMetadata));
    }

    protected AnnotationVisitor getEmptyVisitor() {
        return EMPTY_VISITOR;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationVisitor av = this.annotationVisitors.get(desc);
        if (av != null) {
            return av;
        }
        if (this.annotationNameFilter != null && this.annotationNameFilter.accept(desc)) {
            return new ScanUnknownAnnotationVisitor(new JUnknownAnnotation(desc), (IUnknownAnnotation)this.annotationMetadata);
        }
        return EMPTY_VISITOR;
    }

    protected Map<String, AnnotationVisitor> getAnnotationVisitors() {
        return this.annotationVisitors;
    }
}

