/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.annotations.analyzer.classes;

import org.ow2.easybeans.asm.AnnotationVisitor;
import org.ow2.easybeans.asm.Type;
import org.ow2.easybeans.asm.commons.EmptyVisitor;
import org.ow2.easybeans.deployment.annotations.ClassType;
import org.ow2.easybeans.deployment.annotations.analyzer.AnnotationType;
import org.ow2.easybeans.deployment.annotations.analyzer.classes.AbsCommonEjbVisitor;
import org.ow2.easybeans.deployment.annotations.impl.JActivationConfigProperty;
import org.ow2.easybeans.deployment.annotations.impl.JMessageDriven;
import org.ow2.easybeans.deployment.annotations.metadata.ClassAnnotationMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaxEjbMessageDrivenVisitor
extends AbsCommonEjbVisitor<JMessageDriven>
implements AnnotationType {
    public static final String TYPE = "Ljavax/ejb/MessageDriven;";
    private static final String MESSAGE_LISTENER_INTERFACE = "messageListenerInterface";
    private static final String ACTIVATION_CONFIG = "activationConfig";
    private String messageListenerInterface = null;

    public JavaxEjbMessageDrivenVisitor(ClassAnnotationMetadata classAnnotationMetadata) {
        super(classAnnotationMetadata);
    }

    @Override
    public void visit(String name, Object value) {
        super.visit(name, value);
        if (name.equals(MESSAGE_LISTENER_INTERFACE)) {
            this.messageListenerInterface = ((Type)value).getInternalName();
        }
    }

    @Override
    public void visitEnum(String name, String desc, String value) {
    }

    @Override
    public AnnotationVisitor visitAnnotation(String name, String desc) {
        return this;
    }

    @Override
    public AnnotationVisitor visitArray(String name) {
        if (name.equals(ACTIVATION_CONFIG)) {
            return new ActivationConfigPropertyVisitor();
        }
        return this;
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
        this.getJCommonBean().setMessageListenerInterface(this.messageListenerInterface);
        ((ClassAnnotationMetadata)this.getAnnotationMetadata()).setClassType(ClassType.MDB);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public JMessageDriven getJCommonBean() {
        JMessageDriven jMessageDriven = ((ClassAnnotationMetadata)this.getAnnotationMetadata()).getJMessageDriven();
        if (jMessageDriven == null) {
            jMessageDriven = new JMessageDriven();
            ((ClassAnnotationMetadata)this.getAnnotationMetadata()).setJMessageDriven(jMessageDriven);
        }
        return jMessageDriven;
    }

    class ActivationConfigPropertyVisitor
    extends EmptyVisitor {
        private static final String PROPERTY_NAME = "propertyName";
        private static final String PROPERTY_VALUE = "propertyValue";
        private String propertyName = null;
        private String propertyValue = null;

        ActivationConfigPropertyVisitor() {
        }

        public void visit(String name, Object value) {
            if (name.equals(PROPERTY_NAME)) {
                this.propertyName = (String)value;
            } else if (name.equals(PROPERTY_VALUE)) {
                this.propertyValue = (String)value;
            }
        }

        public void visitEnd() {
            JActivationConfigProperty jActivationConfigProperty = new JActivationConfigProperty(this.propertyName, this.propertyValue);
            JavaxEjbMessageDrivenVisitor.this.getJCommonBean().addActivationConfigProperty(jActivationConfigProperty);
        }
    }
}

