/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.annotations.helper;

import java.util.ArrayList;
import java.util.List;
import org.ow2.easybeans.deployment.annotations.JMethod;
import org.ow2.easybeans.deployment.annotations.exceptions.ResolverException;
import org.ow2.easybeans.deployment.annotations.helper.bean.BusinessMethodResolver;
import org.ow2.easybeans.deployment.annotations.helper.bean.EJB21Finder;
import org.ow2.easybeans.deployment.annotations.helper.bean.InheritanceInterfacesHelper;
import org.ow2.easybeans.deployment.annotations.helper.bean.InheritanceMethodResolver;
import org.ow2.easybeans.deployment.annotations.helper.bean.InterceptorsClassResolver;
import org.ow2.easybeans.deployment.annotations.helper.bean.InterfaceAnnotatedHelper;
import org.ow2.easybeans.deployment.annotations.helper.bean.SecurityResolver;
import org.ow2.easybeans.deployment.annotations.helper.bean.SessionBeanHelper;
import org.ow2.easybeans.deployment.annotations.helper.bean.TimedObjectInterface;
import org.ow2.easybeans.deployment.annotations.helper.bean.TransactionResolver;
import org.ow2.easybeans.deployment.annotations.helper.bean.checks.TimerBeanValidator;
import org.ow2.easybeans.deployment.annotations.helper.bean.mdb.MDBListenerBusinessMethodResolver;
import org.ow2.easybeans.deployment.annotations.metadata.ClassAnnotationMetadata;
import org.ow2.easybeans.deployment.annotations.metadata.EjbJarAnnotationMetadata;
import org.ow2.easybeans.deployment.annotations.metadata.MethodAnnotationMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResolverHelper {
    private ResolverHelper() {
    }

    public static void resolve(EjbJarAnnotationMetadata ejbJarAnnotationMetadata) throws ResolverException {
        for (ClassAnnotationMetadata classMetaData : ejbJarAnnotationMetadata.getClassAnnotationMetadataCollection()) {
            if (classMetaData.isBean()) {
                InheritanceInterfacesHelper.resolve(classMetaData);
                InterfaceAnnotatedHelper.resolve(classMetaData);
                InheritanceMethodResolver.resolve(classMetaData);
                EJB21Finder.resolve(classMetaData);
                if (classMetaData.isSession()) {
                    BusinessMethodResolver.resolve(classMetaData);
                } else if (classMetaData.isMdb()) {
                    MDBListenerBusinessMethodResolver.resolve(classMetaData);
                }
                SecurityResolver.resolve(classMetaData);
                TransactionResolver.resolve(classMetaData);
                InterceptorsClassResolver.resolve(classMetaData);
                TimedObjectInterface.resolve(classMetaData);
                TimerBeanValidator.validate(classMetaData);
            }
            if (!classMetaData.isSession()) continue;
            SessionBeanHelper.resolve(classMetaData);
        }
    }

    public static MethodAnnotationMetadata getMethod(ClassAnnotationMetadata bean, JMethod jMethod, boolean inherited, String interfaceName) {
        MethodAnnotationMetadata method = bean.getMethodAnnotationMetadata(jMethod);
        if (method == null) {
            throw new IllegalStateException("Bean '" + bean + "' implements " + interfaceName + " but no " + jMethod + " method found in metadata");
        }
        if (method.isInherited() && !inherited) {
            String superClassName = bean.getSuperName();
            while (!"java/lang/Object".equals(superClassName)) {
                ClassAnnotationMetadata superMetaData = bean.getEjbJarAnnotationMetadata().getClassAnnotationMetadata(superClassName);
                if (superMetaData != null) {
                    MethodAnnotationMetadata superMethod = superMetaData.getMethodAnnotationMetadata(jMethod);
                    if (superMethod != null && !superMethod.isInherited()) {
                        return superMethod;
                    }
                    superClassName = superMetaData.getSuperName();
                    continue;
                }
                superClassName = "java/lang/Object";
            }
        }
        return method;
    }

    public static List<String> getAllInterfacesFromClass(ClassAnnotationMetadata sessionBean) {
        ArrayList<String> allInterfaces = new ArrayList<String>();
        String className = sessionBean.getClassName();
        while (!"java/lang/Object".equals(className)) {
            ClassAnnotationMetadata metaData = sessionBean.getEjbJarAnnotationMetadata().getClassAnnotationMetadata(className);
            if (metaData != null) {
                String[] interfaces = metaData.getInterfaces();
                if (interfaces != null) {
                    for (String itf : interfaces) {
                        allInterfaces.add(itf);
                    }
                }
                className = metaData.getSuperName();
                continue;
            }
            className = "java/lang/Object";
        }
        return allInterfaces;
    }
}

