/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.annotations.helper.bean;

import org.ow2.easybeans.deployment.annotations.JMethod;
import org.ow2.easybeans.deployment.annotations.metadata.ClassAnnotationMetadata;
import org.ow2.easybeans.deployment.annotations.metadata.MethodAnnotationMetadata;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public final class BusinessMethodResolver {
    public static final String CLASS_INIT = "<clinit>";
    public static final String CONST_INIT = "<init>";
    private static Log logger = LogFactory.getLog(BusinessMethodResolver.class);

    private BusinessMethodResolver() {
    }

    public static void resolve(ClassAnnotationMetadata classAnnotationMetadata) {
        BusinessMethodResolver.loop(classAnnotationMetadata, classAnnotationMetadata);
    }

    private static void loop(ClassAnnotationMetadata beanclassAnnotationMetadata, ClassAnnotationMetadata visitingclassAnnotationMetadata) {
        for (String itf : visitingclassAnnotationMetadata.getInterfaces()) {
            if (itf.startsWith("javax/ejb/") || itf.startsWith("java/io/Serializable") || itf.startsWith("java/io/Externalizable")) continue;
            ClassAnnotationMetadata itfMetadata = visitingclassAnnotationMetadata.getEjbJarAnnotationMetadata().getClassAnnotationMetadata(itf);
            if (itfMetadata == null) {
                logger.warn("No class was found for interface {0}.", itf);
                continue;
            }
            for (MethodAnnotationMetadata methodData : itfMetadata.getMethodAnnotationMetadataCollection()) {
                JMethod itfMethod = methodData.getJMethod();
                if (itfMethod.getName().equals(CLASS_INIT) || itfMethod.getName().equals(CONST_INIT)) continue;
                MethodAnnotationMetadata beanMethod = beanclassAnnotationMetadata.getMethodAnnotationMetadata(itfMethod);
                if (beanMethod == null) {
                    throw new IllegalStateException("No method was found for method " + itfMethod + " in class " + beanclassAnnotationMetadata.getClassName());
                }
                beanMethod.setBusinessMethod(true);
            }
            if (itfMetadata.getInterfaces() == null) continue;
            BusinessMethodResolver.loop(beanclassAnnotationMetadata, itfMetadata);
        }
    }
}

