/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.annotations.helper.bean;

import java.util.ArrayList;
import java.util.List;
import org.ow2.easybeans.asm.Type;
import org.ow2.easybeans.deployment.annotations.JMethod;
import org.ow2.easybeans.deployment.annotations.impl.JRemove;
import org.ow2.easybeans.deployment.annotations.metadata.ClassAnnotationMetadata;
import org.ow2.easybeans.deployment.annotations.metadata.EjbJarAnnotationMetadata;
import org.ow2.easybeans.deployment.annotations.metadata.MethodAnnotationMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EJB21Finder {
    private static final JMethod REMOVE_METHOD = new JMethod(1, "remove", "()V", null, new String[]{"javax/ejb/RemoveException"});
    private static final JMethod ISIDENTICAL_METHOD = new JMethod(1, "isIdentical", "(Ljavax/ejb/EJBObject;)Z", null, new String[]{"java/rmi/RemoteException"});
    private static final JMethod ISIDENTICAL_LOCAL_METHOD = new JMethod(1, "isIdentical", "(Ljavax/ejb/EJBLocalObject;)Z", null, new String[]{"javax/ejb/EJBException"});
    private static final JMethod GETHANDLE_METHOD = new JMethod(1, "getHandle", "()Ljavax/ejb/Handle;", null, new String[]{"java/rmi/RemoteException"});
    private static final JMethod GETPRIMARYKEY_METHOD = new JMethod(1, "getPrimaryKey", "()Ljava/lang/Object;", null, null);

    private EJB21Finder() {
    }

    public static void resolve(ClassAnnotationMetadata bean) {
        String remoteHome = bean.getRemoteHome();
        String localHome = bean.getLocalHome();
        if (remoteHome == null && localHome == null) {
            return;
        }
        EjbJarAnnotationMetadata ejbJarAnnotationMetadata = bean.getEjbJarAnnotationMetadata();
        ArrayList<String> interfacesList = new ArrayList<String>();
        if (remoteHome != null) {
            EJB21Finder.getInterfacesFromHome(remoteHome, interfacesList, ejbJarAnnotationMetadata);
        }
        if (localHome != null) {
            EJB21Finder.getInterfacesFromHome(localHome, interfacesList, ejbJarAnnotationMetadata);
        }
        for (String itf : interfacesList) {
            ClassAnnotationMetadata interfaceUsed = ejbJarAnnotationMetadata.getClassAnnotationMetadata(itf);
            if (interfaceUsed == null) {
                throw new IllegalStateException("Cannot find the metadata for the class '" + itf + "' referenced in the home/localhome of the bean '" + bean.getClassName() + "'.");
            }
            for (MethodAnnotationMetadata methodData : interfaceUsed.getMethodAnnotationMetadataCollection()) {
                JMethod itfMethod = methodData.getJMethod();
                if (itfMethod.getName().equals("<clinit>") || itfMethod.getName().equals("<init>")) continue;
                MethodAnnotationMetadata beanMethod = bean.getMethodAnnotationMetadata(itfMethod);
                if (beanMethod == null) {
                    throw new IllegalStateException("No method was found for method " + itfMethod + " in class " + bean.getClassName());
                }
                beanMethod.setBusinessMethod(true);
            }
        }
        MethodAnnotationMetadata metadataRemove = bean.getMethodAnnotationMetadata(REMOVE_METHOD);
        if (metadataRemove == null) {
            metadataRemove = new MethodAnnotationMetadata(REMOVE_METHOD, bean);
            bean.addMethodAnnotationMetadata(metadataRemove);
        }
        metadataRemove.setRemove(new JRemove());
        metadataRemove.setBusinessMethod(true);
        bean.addMethodAnnotationMetadata(new MethodAnnotationMetadata(ISIDENTICAL_METHOD, bean));
        bean.addMethodAnnotationMetadata(new MethodAnnotationMetadata(ISIDENTICAL_LOCAL_METHOD, bean));
        bean.addMethodAnnotationMetadata(new MethodAnnotationMetadata(GETHANDLE_METHOD, bean));
        bean.addMethodAnnotationMetadata(new MethodAnnotationMetadata(GETPRIMARYKEY_METHOD, bean));
    }

    private static void getInterfacesFromHome(String home, List<String> interfacesList, EjbJarAnnotationMetadata ejbJarAnnotationMetadata) {
        String encodedname = home.replace(".", "/");
        ClassAnnotationMetadata homeMetadata = ejbJarAnnotationMetadata.getClassAnnotationMetadata(encodedname);
        if (homeMetadata == null) {
            throw new IllegalStateException("Cannot find the class '" + home + "' referenced as an home/localhome interface");
        }
        for (MethodAnnotationMetadata method : homeMetadata.getMethodAnnotationMetadataCollection()) {
            JMethod jMethod;
            Type returnType;
            String returnTypeClassname;
            if (!method.getMethodName().startsWith("create") || interfacesList.contains(returnTypeClassname = (returnType = Type.getReturnType((jMethod = method.getJMethod()).getDescriptor())).getClassName())) continue;
            interfacesList.add(returnTypeClassname.replace(".", "/"));
        }
        String[] interfaces = homeMetadata.getInterfaces();
        if (interfaces != null) {
            for (String itf : interfaces) {
                if ("javax/ejb/EJBHome".equals(itf) || "javax/ejb/EJBLocalHome".equals(itf)) continue;
                EJB21Finder.getInterfacesFromHome(itf, interfacesList, ejbJarAnnotationMetadata);
            }
        }
    }
}

