/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.annotations.helper.bean;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ejb.Remove;
import org.ow2.easybeans.asm.Type;
import org.ow2.easybeans.container.session.stateful.interceptors.RemoveAlwaysInterceptor;
import org.ow2.easybeans.container.session.stateful.interceptors.RemoveOnlyWithoutExceptionInterceptor;
import org.ow2.easybeans.deployment.annotations.InterceptorType;
import org.ow2.easybeans.deployment.annotations.JClassInterceptor;
import org.ow2.easybeans.deployment.annotations.JMethod;
import org.ow2.easybeans.deployment.annotations.exceptions.ResolverException;
import org.ow2.easybeans.deployment.annotations.helper.bean.InheritanceMethodResolver;
import org.ow2.easybeans.deployment.annotations.impl.JInterceptors;
import org.ow2.easybeans.deployment.annotations.metadata.ClassAnnotationMetadata;
import org.ow2.easybeans.deployment.annotations.metadata.EjbJarAnnotationMetadata;
import org.ow2.easybeans.deployment.annotations.metadata.MethodAnnotationMetadata;
import org.ow2.easybeans.naming.interceptors.ENCManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InterceptorsClassResolver {
    private static final JMethod EASYBEANS_INTERCEPTOR = new JMethod(0, "intercept", "(Lorg/ow2/easybeans/api/EasyBeansInvocationContext;)Ljava/lang/Object;", null, new String[]{"java/lang/Exception"});

    private InterceptorsClassResolver() {
    }

    public static void resolve(ClassAnnotationMetadata classAnnotationMetadata) throws ResolverException {
        ArrayList<String> easyBeansInterceptorsClasses = new ArrayList<String>();
        easyBeansInterceptorsClasses.add(Type.getInternalName(ENCManager.getInterceptorClass()));
        ArrayList<JClassInterceptor> easyBeansGlobalInterceptors = new ArrayList<JClassInterceptor>();
        for (String easyBeansInterceptor : easyBeansInterceptorsClasses) {
            easyBeansGlobalInterceptors.add(new JClassInterceptor(easyBeansInterceptor, EASYBEANS_INTERCEPTOR));
        }
        classAnnotationMetadata.setGlobalEasyBeansInterceptors(easyBeansGlobalInterceptors);
        EjbJarAnnotationMetadata ejbJarAnnotationMetadata = classAnnotationMetadata.getEjbJarAnnotationMetadata();
        JInterceptors defaultInterceptorsClasses = ejbJarAnnotationMetadata.getDefaultInterceptorsClasses();
        Map<InterceptorType, List<JClassInterceptor>> mapDefaultInterceptors = ejbJarAnnotationMetadata.getDefaultInterceptors();
        if (mapDefaultInterceptors == null && defaultInterceptorsClasses != null && defaultInterceptorsClasses.size() > 0) {
            Map<InterceptorType, List<JClassInterceptor>> defaultInterceptors = InterceptorsClassResolver.getInterceptors(classAnnotationMetadata.getClassName(), classAnnotationMetadata.getEjbJarAnnotationMetadata(), defaultInterceptorsClasses.getClasses());
            ejbJarAnnotationMetadata.setDefaultInterceptors(defaultInterceptors);
        }
        ArrayList<String> externalInterceptorsClasses = new ArrayList<String>();
        LinkedList<ClassAnnotationMetadata> invertedInheritanceClassesList = InterceptorsClassResolver.getInvertedSuperClassesMetadata(classAnnotationMetadata);
        for (ClassAnnotationMetadata superMetaData : invertedInheritanceClassesList) {
            JInterceptors classIinterceptors = superMetaData.getAnnotationInterceptors();
            if (classIinterceptors == null) continue;
            for (String cls : classIinterceptors.getClasses()) {
                externalInterceptorsClasses.add(cls);
            }
        }
        Map<InterceptorType, List<JClassInterceptor>> externalMapClassInterceptors = InterceptorsClassResolver.getInterceptors(classAnnotationMetadata.getClassName(), classAnnotationMetadata.getEjbJarAnnotationMetadata(), externalInterceptorsClasses);
        classAnnotationMetadata.setExternalUserInterceptors(externalMapClassInterceptors);
        ArrayList<String> internalInterceptorsClasses = new ArrayList<String>();
        if (classAnnotationMetadata.isAroundInvokeMethodMetadata()) {
            internalInterceptorsClasses.add(classAnnotationMetadata.getClassName());
        }
        Map<InterceptorType, List<JClassInterceptor>> internalMapClassInterceptors = InterceptorsClassResolver.getInterceptors(classAnnotationMetadata.getClassName(), classAnnotationMetadata.getEjbJarAnnotationMetadata(), internalInterceptorsClasses);
        classAnnotationMetadata.setInternalUserInterceptors(internalMapClassInterceptors);
        for (MethodAnnotationMetadata methodAnnotationMetaData : classAnnotationMetadata.getMethodAnnotationMetadataCollection()) {
            JInterceptors methodAnnotationInterceptors;
            Remove remove = methodAnnotationMetaData.getJRemove();
            if (remove != null) {
                ArrayList<JClassInterceptor> easyBeansMethodGlobalInterceptors = new ArrayList<JClassInterceptor>();
                String classType = null;
                classType = remove.retainIfException() ? Type.getInternalName(RemoveOnlyWithoutExceptionInterceptor.class) : Type.getInternalName(RemoveAlwaysInterceptor.class);
                easyBeansMethodGlobalInterceptors.add(new JClassInterceptor(classType, EASYBEANS_INTERCEPTOR));
                methodAnnotationMetaData.setGlobalEasyBeansInterceptors(easyBeansMethodGlobalInterceptors);
            }
            if ((methodAnnotationInterceptors = methodAnnotationMetaData.getAnnotationInterceptors()) == null) continue;
            ArrayList<String> methodInterceptorsClasses = new ArrayList<String>();
            for (String cls : methodAnnotationInterceptors.getClasses()) {
                methodInterceptorsClasses.add(cls);
            }
            Map<InterceptorType, List<JClassInterceptor>> mapMethodInterceptors = InterceptorsClassResolver.getInterceptors(classAnnotationMetadata.getClassName() + "/Method " + methodAnnotationMetaData.getMethodName(), classAnnotationMetadata.getEjbJarAnnotationMetadata(), methodInterceptorsClasses);
            methodAnnotationMetaData.setUserInterceptors(mapMethodInterceptors);
        }
    }

    private static Map<InterceptorType, List<JClassInterceptor>> getInterceptors(String referencingName, EjbJarAnnotationMetadata ejbJarAnnotationMetadata, List<String> interceptorsClasses) throws ResolverException {
        HashMap<InterceptorType, List<JClassInterceptor>> mapInterceptors = new HashMap<InterceptorType, List<JClassInterceptor>>();
        for (InterceptorType type : InterceptorType.values()) {
            mapInterceptors.put(type, new ArrayList());
        }
        int interceptorClassAnalyzed = 0;
        for (String className : interceptorsClasses) {
            ClassAnnotationMetadata interceptorMetadata = ejbJarAnnotationMetadata.getClassAnnotationMetadata(className);
            if (interceptorMetadata == null) {
                throw new ResolverException("No medata for interceptor class " + className + " referenced by " + referencingName);
            }
            ++interceptorClassAnalyzed;
            if (interceptorMetadata.getClassName().contains("$")) {
                throw new IllegalStateException("Interceptor can't be defined in an inner class.");
            }
            InheritanceMethodResolver.resolve(interceptorMetadata);
            LinkedList<ClassAnnotationMetadata> invertedInheritanceClassesList = InterceptorsClassResolver.getInvertedSuperClassesMetadata(interceptorMetadata);
            for (ClassAnnotationMetadata currentMetaData : invertedInheritanceClassesList) {
                for (MethodAnnotationMetadata method : currentMetaData.getMethodAnnotationMetadataCollection()) {
                    if (method.isInherited()) continue;
                    JClassInterceptor jInterceptor = new JClassInterceptor(className, method.getJMethod(), interceptorClassAnalyzed);
                    MethodAnnotationMetadata analyzedMethod = method;
                    MethodAnnotationMetadata methodSubClass = interceptorMetadata.getMethodAnnotationMetadata(method.getJMethod());
                    if (methodSubClass != null) {
                        analyzedMethod = methodSubClass;
                    }
                    if (analyzedMethod.isAroundInvoke()) {
                        InterceptorsClassResolver.addOnlyIfNotPresent((List)mapInterceptors.get((Object)InterceptorType.AROUND_INVOKE), jInterceptor);
                    }
                    if (currentMetaData.isBean()) continue;
                    if (analyzedMethod.isPostActivate()) {
                        InterceptorsClassResolver.addOnlyIfNotPresent((List)mapInterceptors.get((Object)InterceptorType.POST_ACTIVATE), jInterceptor);
                    }
                    if (analyzedMethod.isPostConstruct()) {
                        InterceptorsClassResolver.addOnlyIfNotPresent((List)mapInterceptors.get((Object)InterceptorType.POST_CONSTRUCT), jInterceptor);
                    }
                    if (analyzedMethod.isPreDestroy()) {
                        InterceptorsClassResolver.addOnlyIfNotPresent((List)mapInterceptors.get((Object)InterceptorType.PRE_DESTROY), jInterceptor);
                    }
                    if (!analyzedMethod.isPrePassivate()) continue;
                    InterceptorsClassResolver.addOnlyIfNotPresent((List)mapInterceptors.get((Object)InterceptorType.PRE_PASSIVATE), jInterceptor);
                }
            }
        }
        return mapInterceptors;
    }

    private static void addOnlyIfNotPresent(List<JClassInterceptor> interceptors, JClassInterceptor jInterceptor) {
        if (!interceptors.contains(jInterceptor)) {
            interceptors.add(jInterceptor);
        }
    }

    private static LinkedList<ClassAnnotationMetadata> getInvertedSuperClassesMetadata(ClassAnnotationMetadata classAnnotationMetadata) {
        LinkedList<ClassAnnotationMetadata> superClassesList = new LinkedList<ClassAnnotationMetadata>();
        String superClassName = classAnnotationMetadata.getSuperName();
        while (!"java/lang/Object".equals(superClassName)) {
            ClassAnnotationMetadata superMetaData = classAnnotationMetadata.getEjbJarAnnotationMetadata().getClassAnnotationMetadata(superClassName);
            if (superMetaData != null) {
                superClassName = superMetaData.getSuperName();
                superClassesList.addFirst(superMetaData);
                continue;
            }
            superClassName = "java/lang/Object";
        }
        superClassesList.addLast(classAnnotationMetadata);
        return superClassesList;
    }
}

