/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.annotations.helper.bean;

import org.ow2.easybeans.deployment.annotations.exceptions.ResolverException;
import org.ow2.easybeans.deployment.annotations.impl.JLocal;
import org.ow2.easybeans.deployment.annotations.impl.JRemote;
import org.ow2.easybeans.deployment.annotations.metadata.ClassAnnotationMetadata;
import org.ow2.easybeans.deployment.annotations.metadata.EjbJarAnnotationMetadata;

public final class InterfaceAnnotatedHelper {
    private InterfaceAnnotatedHelper() {
    }

    public static void resolve(ClassAnnotationMetadata sessionBean) throws ResolverException {
        String[] interfaces;
        EjbJarAnnotationMetadata ejbJarAnnotationMetadata = sessionBean.getEjbJarAnnotationMetadata();
        JLocal currentLocalInterfaces = sessionBean.getLocalInterfaces();
        JRemote currentRemoteInterfaces = sessionBean.getRemoteInterfaces();
        for (String itf : interfaces = sessionBean.getInterfaces()) {
            JRemote jRemote;
            ClassAnnotationMetadata itfAnnotationMetadata = ejbJarAnnotationMetadata.getClassAnnotationMetadata(itf);
            if (itfAnnotationMetadata == null) continue;
            JLocal jLocal = itfAnnotationMetadata.getLocalInterfaces();
            if (jLocal != null) {
                if (currentLocalInterfaces == null) {
                    currentLocalInterfaces = new JLocal();
                    sessionBean.setLocalInterfaces(currentLocalInterfaces);
                }
                String itfName = itfAnnotationMetadata.getClassName();
                if (!currentLocalInterfaces.getInterfaces().contains(itfName)) {
                    currentLocalInterfaces.addInterface(itfName);
                }
            }
            if ((jRemote = itfAnnotationMetadata.getRemoteInterfaces()) == null) continue;
            if (currentRemoteInterfaces == null) {
                currentRemoteInterfaces = new JRemote();
                sessionBean.setRemoteInterfaces(currentRemoteInterfaces);
            }
            String itfName = itfAnnotationMetadata.getClassName();
            if (currentRemoteInterfaces.getInterfaces().contains(itfName)) continue;
            currentRemoteInterfaces.addInterface(itfName);
        }
    }
}

