/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.enc;

import java.util.Arrays;
import java.util.List;
import org.ow2.easybeans.asm.Type;
import org.ow2.easybeans.deployment.annotations.JMethod;
import org.ow2.easybeans.deployment.annotations.impl.JAnnotationResource;
import org.ow2.easybeans.deployment.annotations.impl.JavaxPersistenceContext;
import org.ow2.easybeans.deployment.annotations.impl.JavaxPersistenceUnit;
import org.ow2.easybeans.deployment.annotations.metadata.ClassAnnotationMetadata;
import org.ow2.easybeans.deployment.annotations.metadata.CommonAnnotationMetadata;
import org.ow2.easybeans.deployment.annotations.metadata.EjbJarAnnotationMetadata;
import org.ow2.easybeans.deployment.annotations.metadata.FieldAnnotationMetadata;
import org.ow2.easybeans.deployment.annotations.metadata.MethodAnnotationMetadata;
import org.ow2.easybeans.deployment.api.IJAnnotationResource;
import org.ow2.easybeans.deployment.api.IJavaxPersistenceContext;
import org.ow2.easybeans.deployment.api.IJavaxPersistenceUnit;
import org.ow2.easybeans.deployment.enc.ENCBinding;
import org.ow2.easybeans.deployment.enc.ENCBindingException;
import org.ow2.easybeans.deployment.enc.ENCBindingHolder;

public class ENCBindingBuilder {
    private EjbJarAnnotationMetadata ejbJarAnnotationMetadata = null;
    private ENCBindingHolder bindingHolder = null;
    private static final int GETTER_LENGTH = 3;

    protected ENCBindingBuilder(EjbJarAnnotationMetadata ejbJarAnnotationMetadata) {
        this.ejbJarAnnotationMetadata = ejbJarAnnotationMetadata;
        this.bindingHolder = new ENCBindingHolder();
    }

    protected void analyze() throws ENCBindingException {
        for (ClassAnnotationMetadata classMetadata : this.ejbJarAnnotationMetadata.getClassAnnotationMetadataCollection()) {
            this.analyzeClassMetadata(classMetadata);
        }
    }

    protected void analyzeClassMetadata(ClassAnnotationMetadata classMetadata) throws ENCBindingException {
        List<JAnnotationResource> jAnnotationResources;
        List<JavaxPersistenceUnit> javaxPersistenceUnits;
        List<JavaxPersistenceContext> javaxPersistenceContexts = classMetadata.getJavaxPersistencePersistenceContexts();
        if (javaxPersistenceContexts != null) {
            for (JavaxPersistenceContext javaxPersistenceContext : javaxPersistenceContexts) {
                this.addPersistenceContext(javaxPersistenceContext);
            }
        }
        if ((javaxPersistenceUnits = classMetadata.getJavaxPersistencePersistenceUnits()) != null) {
            for (JavaxPersistenceUnit javaxPersistenceUnit : javaxPersistenceUnits) {
                this.addPersistenceUnit(javaxPersistenceUnit);
            }
        }
        if ((jAnnotationResources = classMetadata.getJAnnotationResources()) != null) {
            for (JAnnotationResource jAnnotationResource : jAnnotationResources) {
                this.addResource(jAnnotationResource);
            }
        }
        this.analyzeCommonMetadata(classMetadata);
        for (FieldAnnotationMetadata fieldAnnotationMetadata : classMetadata.getFieldAnnotationMetadataCollection()) {
            this.analyzeFieldMetadata(fieldAnnotationMetadata);
        }
        for (MethodAnnotationMetadata methodAnnotationMetadata : classMetadata.getMethodAnnotationMetadataCollection()) {
            this.analyzeMethodMetadata(methodAnnotationMetadata);
        }
    }

    protected void analyzeFieldMetadata(FieldAnnotationMetadata fieldMetadata) throws ENCBindingException {
        this.analyzeCommonMetadata(fieldMetadata);
    }

    protected void analyzeMethodMetadata(MethodAnnotationMetadata methodAnnotationMetadata) throws ENCBindingException {
        this.analyzeCommonMetadata(methodAnnotationMetadata);
    }

    protected void analyzeCommonMetadata(CommonAnnotationMetadata commonAnnotationMetadata) throws ENCBindingException {
        JAnnotationResource jAnnotationResource;
        JavaxPersistenceUnit javaxPersistenceUnit;
        JavaxPersistenceContext javaxPersistenceContext = commonAnnotationMetadata.getJavaxPersistenceContext();
        if (javaxPersistenceContext != null) {
            if (this.isNullOrEmpty(javaxPersistenceContext.getName())) {
                javaxPersistenceContext.setName(this.getName(commonAnnotationMetadata, javaxPersistenceContext));
            }
            this.addPersistenceContext(javaxPersistenceContext);
        }
        if ((javaxPersistenceUnit = commonAnnotationMetadata.getJavaxPersistenceUnit()) != null) {
            if (this.isNullOrEmpty(javaxPersistenceUnit.getName())) {
                javaxPersistenceUnit.setName(this.getName(commonAnnotationMetadata, javaxPersistenceUnit));
            }
            this.addPersistenceUnit(javaxPersistenceUnit);
        }
        if ((jAnnotationResource = commonAnnotationMetadata.getJAnnotationResource()) != null) {
            if (this.isNullOrEmpty(jAnnotationResource.getName())) {
                jAnnotationResource.setName(this.getName(commonAnnotationMetadata, jAnnotationResource));
            }
            jAnnotationResource.setType(this.getType(commonAnnotationMetadata, jAnnotationResource));
            this.addResource(jAnnotationResource);
        }
    }

    private boolean isNullOrEmpty(String name) {
        return name == null || "".equals(name);
    }

    private String getName(CommonAnnotationMetadata commonAnnotationMetadata, Object o) throws ENCBindingException {
        if (commonAnnotationMetadata instanceof FieldAnnotationMetadata) {
            FieldAnnotationMetadata fieldAnnotationMetadata = (FieldAnnotationMetadata)commonAnnotationMetadata;
            return fieldAnnotationMetadata.getClassAnnotationMetadata().getClassName().replace("/", ".") + "/" + fieldAnnotationMetadata.getFieldName();
        }
        if (commonAnnotationMetadata instanceof MethodAnnotationMetadata) {
            MethodAnnotationMetadata methodAnnotationMetadata = (MethodAnnotationMetadata)commonAnnotationMetadata;
            StringBuilder propertyBuilder = new StringBuilder(methodAnnotationMetadata.getMethodName());
            propertyBuilder.delete(0, 3);
            propertyBuilder.setCharAt(0, Character.toLowerCase(propertyBuilder.charAt(0)));
            propertyBuilder.insert(0, methodAnnotationMetadata.getClassAnnotationMetadata().getClassName().replace("/", ".") + "/");
            return propertyBuilder.toString();
        }
        throw new ENCBindingException("There is no defined name in the object '" + o + "' that is defined on the class '" + commonAnnotationMetadata + "'.");
    }

    private String getType(CommonAnnotationMetadata commonAnnotationMetadata, IJAnnotationResource jAnnotationResource) throws ENCBindingException {
        if (commonAnnotationMetadata instanceof FieldAnnotationMetadata) {
            FieldAnnotationMetadata fieldAnnotationMetadata = (FieldAnnotationMetadata)commonAnnotationMetadata;
            Type typeInterface = Type.getType(fieldAnnotationMetadata.getJField().getDescriptor());
            return typeInterface.getClassName();
        }
        if (commonAnnotationMetadata instanceof MethodAnnotationMetadata) {
            MethodAnnotationMetadata methodAnnotationMetadata = (MethodAnnotationMetadata)commonAnnotationMetadata;
            JMethod jMethod = methodAnnotationMetadata.getJMethod();
            Type[] args = Type.getArgumentTypes(jMethod.getDescriptor());
            if (args.length != 1) {
                throw new ENCBindingException("Method args '" + Arrays.asList(args) + "' for method '" + jMethod + "' are invalid. Length should be of 1.");
            }
            Type typeInterface = args[0];
            return typeInterface.getClassName();
        }
        return jAnnotationResource.getType();
    }

    protected void addPersistenceContext(IJavaxPersistenceContext javaxPersistenceContext) {
        this.bindingHolder.addPersistenceContextBinding(new ENCBinding<IJavaxPersistenceContext>(javaxPersistenceContext.getName(), javaxPersistenceContext));
    }

    protected void addPersistenceUnit(IJavaxPersistenceUnit javaxPersistenceUnit) {
        this.bindingHolder.addPersistenceUnitBinding(new ENCBinding<IJavaxPersistenceUnit>(javaxPersistenceUnit.getName(), javaxPersistenceUnit));
    }

    protected void addResource(IJAnnotationResource jAnnotationResource) {
        this.bindingHolder.addResourceBinding(new ENCBinding<IJAnnotationResource>(jAnnotationResource.getName(), jAnnotationResource));
    }

    protected ENCBindingHolder getHolder() {
        return this.bindingHolder;
    }

    public static ENCBindingHolder analyze(EjbJarAnnotationMetadata ejbJarAnnotationMetadata) throws ENCBindingException {
        ENCBindingBuilder bindingBuilder = new ENCBindingBuilder(ejbJarAnnotationMetadata);
        bindingBuilder.analyze();
        return bindingBuilder.getHolder();
    }
}

