/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.osgi.configuration;

import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.ow2.easybeans.component.api.EZBComponent;
import org.ow2.easybeans.server.Embedded;
import org.ow2.util.xmlconfig.XMLConfiguration;
import org.ow2.util.xmlconfig.XMLConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLConfigurationInjector
extends XMLConfiguration {
    private String xmlConfiguration;
    private EZBComponent componentObject;
    private Embedded embedded;

    public XMLConfigurationInjector(Class<? extends EZBComponent> componentClass, String xmlConfiguration) throws XMLConfigurationException {
        super(null, "http://easybeans.ow2.org/xml/ns/mapping", "easybeans-mapping.xml");
        this.xmlConfiguration = xmlConfiguration;
        try {
            this.componentObject = componentClass.newInstance();
        }
        catch (Exception e) {
            throw new XMLConfigurationException("Could not instantiate component class: " + componentClass.getName(), e);
        }
        this.embedded = new Embedded();
        this.configure(this.embedded);
    }

    @Override
    public void configure(Object object) throws XMLConfigurationException {
        Document componentConfigurationXML;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            componentConfigurationXML = documentBuilder.parse(new InputSource(new StringReader(this.xmlConfiguration)));
        }
        catch (Exception e) {
            throw new XMLConfigurationException("Could not configure object from XML Configuration.", e);
        }
        Element rootElement = componentConfigurationXML.getDocumentElement();
        super.configure(object, rootElement, null);
    }

    public EZBComponent getConfiguredComponent() {
        for (EZBComponent component : this.embedded.getComponents().getEZBComponents()) {
            if (!component.getClass().equals(this.componentObject.getClass())) continue;
            return component;
        }
        return null;
    }
}

