/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.persistence.xml;

import java.net.URL;
import javax.persistence.spi.PersistenceProvider;
import org.ow2.easybeans.persistence.PersistenceUnitManager;
import org.ow2.easybeans.persistence.xml.JPersistenceUnitInfo;
import org.ow2.easybeans.persistence.xml.JPersistenceUnitInfoException;
import org.ow2.easybeans.persistence.xml.JPersistenceUnitInfoHelper;
import org.ow2.easybeans.persistence.xml.PersistenceXmlFileAnalyzerException;
import org.ow2.util.ee.deploy.api.archive.ArchiveException;
import org.ow2.util.ee.deploy.api.archive.IArchive;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public final class PersistenceXmlFileAnalyzer {
    private static final String DIRECTORY_PERSISTENCE_XML_FILE = "META-INF";
    private static final String PERSISTENCE_XML_FILE = "persistence.xml";
    private static Log logger = LogFactory.getLog(PersistenceXmlFileAnalyzer.class);

    private PersistenceXmlFileAnalyzer() {
    }

    public static PersistenceUnitManager analyzePersistenceXmlFile(IArchive archive, ClassLoader classLoader) throws PersistenceXmlFileAnalyzerException {
        URL persistenceXmlURL = null;
        try {
            persistenceXmlURL = archive.getResource("META-INF/persistence.xml");
        }
        catch (ArchiveException e) {
            throw new PersistenceXmlFileAnalyzerException("Cannot check if entry 'META-INF/persistence.xml' is present on the file '" + archive.getName() + "'.", e);
        }
        JPersistenceUnitInfo[] persistenceUnitInfos = null;
        if (persistenceXmlURL != null) {
            try {
                persistenceUnitInfos = JPersistenceUnitInfoHelper.getPersistenceUnitInfo(persistenceXmlURL);
            }
            catch (JPersistenceUnitInfoException e) {
                throw new PersistenceXmlFileAnalyzerException("Cannot parse the URL '" + persistenceXmlURL + "'.", e);
            }
            for (JPersistenceUnitInfo persistenceUnitInfo : persistenceUnitInfos) {
                PersistenceProvider persistenceProvider;
                Class<?> persistenceProviderClass;
                try {
                    persistenceUnitInfo.addJarFile(archive.getURL());
                    persistenceUnitInfo.setPersistenceUnitRootUrl(archive.getURL());
                }
                catch (ArchiveException e) {
                    throw new PersistenceXmlFileAnalyzerException("Cannot get the URL on the jar file '" + archive.getName() + "'.", e);
                }
                persistenceUnitInfo.setClassLoader(classLoader);
                if (persistenceUnitInfo.getPersistenceProviderClassName() == null) {
                    throw new PersistenceXmlFileAnalyzerException("No Persistence provider has been set");
                }
                try {
                    ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
                    persistenceProviderClass = ctxLoader.loadClass(persistenceUnitInfo.getPersistenceProviderClassName());
                }
                catch (ClassNotFoundException e) {
                    throw new PersistenceXmlFileAnalyzerException("Cannot load the persistence provider class '" + persistenceUnitInfo.getPersistenceProviderClassName() + "'.");
                }
                try {
                    persistenceProvider = (PersistenceProvider)persistenceProviderClass.newInstance();
                }
                catch (InstantiationException e) {
                    throw new PersistenceXmlFileAnalyzerException("Cannot instantiate the persistence provider class '" + persistenceUnitInfo.getPersistenceProviderClassName() + "'.", e);
                }
                catch (IllegalAccessException e) {
                    throw new PersistenceXmlFileAnalyzerException("Cannot instantiate the persistence provider class '" + persistenceUnitInfo.getPersistenceProviderClassName() + "'.", e);
                }
                persistenceUnitInfo.setPersistenceProvider(persistenceProvider);
            }
            return new PersistenceUnitManager(persistenceUnitInfos);
        }
        return null;
    }
}

