/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.rpc.rmi.client;

import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.ow2.easybeans.rpc.api.ClientRPC;
import org.ow2.easybeans.rpc.api.EJBRequest;
import org.ow2.easybeans.rpc.api.EJBResponse;
import org.ow2.easybeans.rpc.rmi.server.RMIServerRPC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMIClientRPC
implements ClientRPC {
    public static final String EASYBEANS_RMI_FACTORY = "easybeans.rpc.rmi.factory";
    private Hashtable rmiClientEnvironment = null;

    public RMIClientRPC(Hashtable<?, ?> rmiClientEnvironment) {
        this.rmiClientEnvironment = rmiClientEnvironment;
    }

    @Override
    public EJBResponse sendEJBRequest(EJBRequest request) {
        String additionalInitialFactory = System.getProperty(EASYBEANS_RMI_FACTORY);
        if (additionalInitialFactory != null) {
            this.rmiClientEnvironment.put("java.naming.factory.initial", additionalInitialFactory);
        }
        InitialContext ictx = null;
        try {
            ictx = new InitialContext(this.rmiClientEnvironment);
        }
        catch (NamingException ne) {
            throw new IllegalStateException(ne);
        }
        Object serverObject = null;
        try {
            serverObject = ictx.lookup("RMI_SERVER_RPC");
        }
        catch (NamingException ne) {
            throw new IllegalStateException(ne);
        }
        RMIServerRPC server = (RMIServerRPC)PortableRemoteObject.narrow((Object)serverObject, RMIServerRPC.class);
        try {
            return server.getEJBResponse(request);
        }
        catch (RemoteException re) {
            throw new RuntimeException("Error while handling answer on the remote side ", re);
        }
    }
}

