/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.cmi.internal;

import java.net.URL;
import javax.ejb.EJBObject;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.carol.cmi.config.CMIConfig;
import org.ow2.carol.cmi.controller.server.AbsServerClusterViewManager;
import org.ow2.carol.cmi.info.CMIInfoExtractor;
import org.ow2.carol.cmi.info.CMIInfoExtractorException;
import org.ow2.carol.cmi.info.CMIInfoRepository;
import org.ow2.carol.cmi.info.ClusteredObjectInfo;
import org.ow2.carol.util.configuration.ConfigurationRepository;
import org.ow2.jonas.cmi.CmiService;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.service.ServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmiServiceImpl
extends AbsServiceImpl
implements CmiService {
    protected static Logger cmilogger = Log.getLogger("org.ow2.carol.cmi");

    @Override
    protected void doStart() throws ServiceException {
        try {
            ConfigurationRepository.getServerConfiguration().setStartCMI(true);
        }
        catch (Exception e) {
            cmilogger.log(BasicLevel.ERROR, (Object)"Cannot configure Carol to use CMI", (Throwable)e);
            throw new ServiceException("Cannot configure Carol to use CMI", e);
        }
        CMIConfig.setConfDir(JProp.getConfDir());
        IExecution<Void> startExec = new IExecution<Void>(){

            @Override
            public Void execute() throws Exception {
                AbsServerClusterViewManager.start();
                return null;
            }
        };
        ExecutionResult<Void> startExecResult = RunnableHelper.execute(this.getClass().getClassLoader(), startExec);
        if (startExecResult.hasException()) {
            cmilogger.log(BasicLevel.ERROR, (Object)"Cannot start the server-side manager", (Throwable)startExecResult.getException());
            throw new ServiceException("Cannot start the server-side manager", startExecResult.getException());
        }
    }

    @Override
    protected void doStop() throws ServiceException {
        try {
            ConfigurationRepository.getServerConfiguration().setStartCMI(false);
        }
        catch (Exception e) {
            cmilogger.log(BasicLevel.ERROR, (Object)"Cannot disable cmi in Carol", (Throwable)e);
        }
        try {
            AbsServerClusterViewManager.stop();
        }
        catch (Exception e) {
            cmilogger.log(BasicLevel.ERROR, (Object)"Cannot stop the server-side manager", (Throwable)e);
            throw new ServiceException("Cannot stop the server-side manager", e);
        }
    }

    @Override
    public void addClusteredObject(String jndiName, String clusterPolicyName, Class<?> homeClass, Class<? extends EJBObject> remoteClass, ClassLoader classLoader, boolean stateful, boolean clusterReplicated) throws Exception {
        if (clusterPolicyName == null) {
            cmilogger.log(BasicLevel.DEBUG, (Object)("The object with name " + jndiName + " is not clustered."));
            return;
        }
        URL url = classLoader.getResource(clusterPolicyName);
        if (url != null) {
            try {
                ClusteredObjectInfo clusteredObjectInfo = CMIInfoExtractor.extractClusteringInfoFromDD(homeClass, remoteClass, url, stateful, clusterReplicated, null);
                CMIInfoRepository.addClusteredObjectInfo(jndiName, clusteredObjectInfo);
                cmilogger.log(BasicLevel.INFO, (Object)("The object with name " + jndiName + " is clustered."));
            }
            catch (CMIInfoExtractorException e) {
                cmilogger.log(BasicLevel.ERROR, (Object)("Error when extracting infos about clustering for the object with name " + jndiName), (Throwable)e);
                throw new Exception("Error when extracting infos about clustering for the object with name " + jndiName, e);
            }
        } else {
            cmilogger.log(BasicLevel.ERROR, (Object)("Cannot find the policy of load-balancing with name " + clusterPolicyName));
            throw new Exception("Cannot find the policy of load-balancing with name " + clusterPolicyName);
        }
    }
}

