/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.domain.lib;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.common.digester.JDigester;
import org.ow2.jonas.deployment.common.lib.AbsDeploymentDescManager;
import org.ow2.jonas.deployment.domain.DomainMap;
import org.ow2.jonas.deployment.domain.DomainMapException;
import org.ow2.jonas.deployment.domain.DomainSchemas;
import org.ow2.jonas.deployment.domain.rules.DomainRuleSet;
import org.ow2.jonas.deployment.domain.xml.Domain;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.util.Log;

public class DomainMapManager
extends AbsDeploymentDescManager {
    public static final String DOMAIN_FILE_NAME = "domain.xml";
    private static JDigester domainDigester = null;
    private static DomainRuleSet domainRuleSet = new DomainRuleSet();
    private static Logger logger = Log.getLogger("org.ow2.jonas.deployment.domain");
    private static boolean parsingWithValidation = true;

    private DomainMapManager() {
    }

    public static DomainMap getDomainMap(String domainFileName, ClassLoader classLoaderForCls) throws DomainMapException {
        InputStream domainInputStream = null;
        String fileName = null;
        fileName = domainFileName == null ? System.getProperty("jonas.base") + File.separator + "conf" + File.separator + DOMAIN_FILE_NAME : domainFileName;
        File domainFile = new File(fileName);
        if (!domainFile.exists()) {
            domainInputStream = classLoaderForCls.getResourceAsStream(DOMAIN_FILE_NAME);
        } else {
            try {
                domainInputStream = new FileInputStream(domainFile);
            }
            catch (Exception e) {
                throw new DomainMapException("Cannot read the domain.xml", e);
            }
        }
        Domain domain = DomainMapManager.loadDomain(new InputStreamReader(domainInputStream), DOMAIN_FILE_NAME);
        try {
            domainInputStream.close();
        }
        catch (IOException e) {
            logger.log(BasicLevel.WARN, (Object)"Cannot close InputStream for domain.xml");
        }
        DomainMap domainMap = new DomainMap(domain);
        return domainMap;
    }

    public static Domain loadDomain(Reader reader, String fileName) throws DomainMapException {
        Domain domain = new Domain();
        if (domainDigester == null) {
            try {
                domainDigester = new JDigester(domainRuleSet, DomainMapManager.getParsingWithValidation(), true, null, new DomainSchemas());
            }
            catch (DeploymentDescException e) {
                throw new DomainMapException(e);
            }
        }
        final Reader myReader = reader;
        final String myFilename = fileName;
        final Domain myDomain = domain;
        IExecution<Void> exec = new IExecution<Void>(){

            @Override
            public Void execute() throws Exception {
                try {
                    domainDigester.parse(myReader, myFilename, myDomain);
                }
                catch (DeploymentDescException e) {
                    throw new DomainMapException(e);
                }
                finally {
                    domainDigester.push(null);
                }
                return null;
            }
        };
        ExecutionResult<Void> result = RunnableHelper.execute(Domain.class.getClassLoader(), exec);
        if (result.hasException()) {
            throw (DomainMapException)result.getException();
        }
        return domain;
    }

    public static boolean getParsingWithValidation() {
        return parsingWithValidation;
    }

    public static void setParsingWithValidation(boolean validation) {
        parsingWithValidation = validation;
    }
}

