/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.ear.wrapper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.deployment.ear.EarDeploymentDesc;
import org.ow2.jonas.deployment.ear.EarDeploymentDescException;
import org.ow2.jonas.lib.bootstrap.LoaderManager;
import org.ow2.jonas.lib.bootstrap.loader.JClassLoader;
import org.ow2.jonas.lib.util.Log;
import org.ow2.util.ee.deploy.api.deployable.EARDeployable;

public final class EarManagerWrapper {
    private static final String EAR_MANAGER_CLASSNAME = "org.ow2.jonas.deployment.ear.lib.EarDeploymentDescManager";
    private static Logger logger = Log.getLogger("org.ow2.jonas.ear");

    private EarManagerWrapper() {
    }

    public static EarDeploymentDesc getDeploymentDesc(EARDeployable earDeployable, ClassLoader cl) throws EarDeploymentDescException {
        LoaderManager lm = LoaderManager.getInstance();
        EarDeploymentDesc earDD = null;
        try {
            JClassLoader tools = lm.getToolsLoader();
            Class<?> manager = tools.loadClass(EAR_MANAGER_CLASSNAME);
            Method m = manager.getDeclaredMethod("getDeploymentDesc", EARDeployable.class, ClassLoader.class);
            earDD = (EarDeploymentDesc)m.invoke(null, earDeployable, cl);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (EarDeploymentDescException.class.isInstance(t)) {
                throw (EarDeploymentDescException)ite.getTargetException();
            }
            throw new EarDeploymentDescException("EarDeploymentDescManager.getDeploymentDesc fails", t);
        }
        catch (Exception e) {
            throw new EarDeploymentDescException("Problems when using reflection on EarDeploymentDescManager", e);
        }
        return earDD;
    }

    public static void setParsingWithValidation(boolean b) {
        LoaderManager lm = LoaderManager.getInstance();
        try {
            JClassLoader tools = lm.getToolsLoader();
            Class<?> manager = tools.loadClass(EAR_MANAGER_CLASSNAME);
            Method m = manager.getDeclaredMethod("setParsingWithValidation", Boolean.TYPE);
            m.invoke(null, new Boolean(b));
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)e);
        }
    }
}

