/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.ws.wrapper;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.ow2.jonas.deployment.ws.MappingFile;
import org.ow2.jonas.deployment.ws.WSDeploymentDescException;
import org.ow2.jonas.lib.bootstrap.LoaderManager;
import org.ow2.jonas.lib.bootstrap.loader.JClassLoader;

public class MappingFileManagerWrapper {
    private static final String MAPPINGFILEMANAGER_CLASSNAME = "org.ow2.jonas.deployment.ws.lib.MappingFileManager";

    private MappingFileManagerWrapper() {
    }

    public static MappingFile getMappingFile(File module, String filename) throws WSDeploymentDescException {
        LoaderManager lm = LoaderManager.getInstance();
        MappingFile mf = null;
        try {
            JClassLoader tools = lm.getToolsLoader();
            Class<?> manager = tools.loadClass(MAPPINGFILEMANAGER_CLASSNAME);
            Method m = manager.getDeclaredMethod("getInstance", File.class, String.class);
            mf = (MappingFile)m.invoke(null, module, filename);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (WSDeploymentDescException.class.isInstance(t)) {
                throw (WSDeploymentDescException)ite.getTargetException();
            }
            throw new WSDeploymentDescException("MappingFileManager.getInstance fails", t);
        }
        catch (Exception e) {
            throw new WSDeploymentDescException("Problems when using reflection on MappingFileManager", e);
        }
        return mf;
    }

    public static MappingFile getMappingFile(InputStream is, String filename) throws WSDeploymentDescException {
        LoaderManager lm = LoaderManager.getInstance();
        MappingFile mf = null;
        try {
            JClassLoader tools = lm.getToolsLoader();
            Class<?> manager = tools.loadClass(MAPPINGFILEMANAGER_CLASSNAME);
            Method m = manager.getDeclaredMethod("getInstance", InputStream.class, String.class);
            mf = (MappingFile)m.invoke(null, is, filename);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (WSDeploymentDescException.class.isInstance(t)) {
                throw (WSDeploymentDescException)ite.getTargetException();
            }
            throw new WSDeploymentDescException("MappingFileManager.getInstance fails", t);
        }
        catch (Exception e) {
            throw new WSDeploymentDescException("Problems when using reflection on MappingFileManager", e);
        }
        return mf;
    }
}

