/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ejb.internal;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Vector;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.ejb.EJBService;
import org.ow2.jonas.lib.work.AbsCleanTask;
import org.ow2.jonas.lib.work.CleanerException;
import org.ow2.jonas.lib.work.DeployerLog;
import org.ow2.jonas.lib.work.DeployerLogException;
import org.ow2.jonas.lib.work.FileManager;
import org.ow2.jonas.lib.work.FileManagerException;
import org.ow2.jonas.lib.work.LogEntry;

public class JarCleanTask
extends AbsCleanTask {
    private static DeployerLog jarDeployerLog = null;
    private EJBService ejbService = null;

    public JarCleanTask(DeployerLog jarDeployerLog, EJBService ejb) {
        JarCleanTask.jarDeployerLog = jarDeployerLog;
        this.ejbService = ejb;
    }

    protected boolean isValidLogEntry(LogEntry logEntry) throws CleanerException {
        String fTimeStamp = null;
        File jarOriginalFile = logEntry.getOriginal();
        File jarCopyFile = logEntry.getCopy();
        if (JarCleanTask.getLogger().isLoggable(BasicLevel.DEBUG)) {
            JarCleanTask.getLogger().log(BasicLevel.DEBUG, (Object)("LogEntry exist :" + jarOriginalFile.exists()));
        }
        if (!jarOriginalFile.exists()) {
            return false;
        }
        try {
            fTimeStamp = FileManager.fileToTimeStampDir(jarOriginalFile.toURL(), ".jar");
        }
        catch (FileManagerException efme) {
            throw new CleanerException("Can't get the timestamp of the file " + jarOriginalFile + " : " + efme.getMessage());
        }
        catch (MalformedURLException mue) {
            throw new CleanerException("Can't get the timestamp of the file " + jarOriginalFile + " : " + mue.getMessage());
        }
        if (JarCleanTask.getLogger().isLoggable(BasicLevel.DEBUG)) {
            JarCleanTask.getLogger().log(BasicLevel.DEBUG, (Object)("LogEntry fTimeStamp :" + fTimeStamp));
            JarCleanTask.getLogger().log(BasicLevel.DEBUG, (Object)("LogEntry isValid :" + fTimeStamp.equalsIgnoreCase(jarCopyFile.getName())));
        }
        return fTimeStamp.equalsIgnoreCase(jarCopyFile.getName());
    }

    protected void removeLogEntry(LogEntry logEntry) throws CleanerException {
        this.removeRecursiveDirectory(logEntry.getCopy());
        try {
            jarDeployerLog.removeEntry(logEntry);
        }
        catch (DeployerLogException edle) {
            throw new CleanerException("Can't remove an entry" + edle.getMessage());
        }
    }

    protected Vector getLogEntries() {
        return jarDeployerLog.getEntries();
    }

    protected boolean isDeployLogEntry(LogEntry logEntry) throws CleanerException {
        return this.ejbService.isJarDeployedByWorkName(logEntry.getCopy().getName());
    }
}

