/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.genbase.archive;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.jar.Attributes;
import javax.xml.parsers.ParserConfigurationException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.ear.EarDeploymentDesc;
import org.ow2.jonas.deployment.ear.lib.EarDeploymentDescManager;
import org.ow2.jonas.deployment.ear.xml.Web;
import org.ow2.jonas.generators.genbase.GenBaseException;
import org.ow2.jonas.generators.genbase.archive.AbsArchive;
import org.ow2.jonas.generators.genbase.archive.Archive;
import org.ow2.jonas.generators.genbase.archive.Client;
import org.ow2.jonas.generators.genbase.archive.EjbJar;
import org.ow2.jonas.generators.genbase.archive.FileArchive;
import org.ow2.jonas.generators.genbase.archive.J2EEArchive;
import org.ow2.jonas.generators.genbase.archive.JarArchive;
import org.ow2.jonas.generators.genbase.archive.WebApp;
import org.ow2.jonas.generators.genbase.utils.XMLUtils;
import org.ow2.jonas.lib.loader.EjbJarClassLoader;
import org.ow2.util.ee.deploy.api.archive.ArchiveException;
import org.ow2.util.ee.deploy.api.archive.IArchive;
import org.ow2.util.ee.deploy.api.deployable.EARDeployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.impl.archive.ArchiveManager;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelperException;
import org.ow2.util.ee.deploy.impl.helper.UnpackDeployableHelper;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Application
extends J2EEArchive {
    private List clients;
    private List webapps;
    private List ejbjars;
    private EarDeploymentDesc earDD = null;
    private Map<String, Document> descriptors = new Hashtable<String, Document>();
    private Document app;
    private URLClassLoader ejbCL = null;
    private URLClassLoader commonCL = null;
    private List pathFiles;
    private String appFilename;

    public Application(Archive archive) throws GenBaseException {
        super(archive);
        this.appFilename = archive.getRootFile().getName();
        if (Application.getLogger().isLoggable(BasicLevel.DEBUG)) {
            Application.getLogger().log(BasicLevel.DEBUG, (Object)("Wrapping '" + archive.getName() + "' in Application"));
        }
        this.init();
    }

    protected void init() throws GenBaseException {
        IDeployable<?> deployable;
        this.pathFiles = new Vector();
        this.ejbjars = new Vector();
        this.webapps = new Vector();
        this.clients = new Vector();
        IArchive archive = ArchiveManager.getInstance().getArchive(new File(this.getRootFile().getAbsolutePath()));
        try {
            deployable = DeployableHelper.getDeployable(archive);
        }
        catch (DeployableHelperException e) {
            throw new GenBaseException("Cannot get a deployable for the archive '" + archive + "'", e);
        }
        EARDeployable earDeployable = null;
        if (deployable instanceof EARDeployable) {
            try {
                earDeployable = UnpackDeployableHelper.unpack((EARDeployable)deployable, "genbase");
                this.setArchive(new FileArchive(new File(earDeployable.getArchive().getURL().getFile())));
            }
            catch (DeployerException e) {
                throw new GenBaseException("Cannot unpack the deployable '" + deployable + "'.", e);
            }
            catch (ArchiveException e) {
                throw new GenBaseException("Cannot unpack the deployable '" + deployable + "'.", e);
            }
        } else {
            throw new GenBaseException(deployable + " is not an EAR deployable");
        }
        try {
            this.earDD = EarDeploymentDescManager.getDeploymentDesc(earDeployable, Thread.currentThread().getContextClassLoader());
        }
        catch (DeploymentDescException dde) {
            String err = Application.getI18n().getMessage("Application.init.earDDExc", this.getArchive().getRootFile());
            throw new GenBaseException(err, dde);
        }
        String[] ejbs = this.earDD.getEjbTags();
        for (int i = 0; i < ejbs.length; ++i) {
            File ejbFile = new File(this.getRootFile(), ejbs[i]);
            AbsArchive ejbArch = null;
            ejbArch = ejbFile.isDirectory() ? new FileArchive(ejbFile) : new JarArchive(ejbFile);
            this.ejbjars.add(new EjbJar(ejbArch, this));
            this.addClassPathEntry(ejbArch);
        }
        Web[] webs = this.earDD.getWebTags();
        for (int i = 0; i < webs.length; ++i) {
            File webFile = new File(this.getRootFile(), webs[i].getWebUri());
            if (webFile.isDirectory()) {
                this.webapps.add(new WebApp(new FileArchive(webFile), this));
                continue;
            }
            this.webapps.add(new WebApp(new JarArchive(webFile), this));
        }
        String[] clts = this.earDD.getClientTags();
        for (int i = 0; i < clts.length; ++i) {
            File clientFile = new File(this.getRootFile(), clts[i]);
            if (clientFile.isDirectory()) {
                this.clients.add(new Client(new FileArchive(clientFile), this));
                continue;
            }
            this.clients.add(new Client(new JarArchive(clientFile), this));
        }
        this.setModuleClassloader(this.createEARClassLoader());
        this.ejbCL = this.createEJBClassLoader();
        this.loadDescriptors();
    }

    protected void loadDescriptors() throws GenBaseException {
        InputStream is = null;
        try {
            is = this.getApplicationInputStream();
        }
        catch (IOException e) {
            throw new GenBaseException("Cannot get inputstream", e);
        }
        if (is == null) {
            return;
        }
        try {
            this.app = XMLUtils.newDocument(is, "META-INF/application.xml", this.isDTDsAllowed());
        }
        catch (SAXException saxe) {
            String err = Application.getI18n().getMessage("Application.loadDescriptors.parseError");
            throw new GenBaseException(err, saxe);
        }
        catch (ParserConfigurationException pce) {
            String err = Application.getI18n().getMessage("Application.loadDescriptors.prepare");
            throw new GenBaseException(err, pce);
        }
        catch (IOException ioe) {
            String err = Application.getI18n().getMessage("Application.loadDescriptors.parseError");
            throw new GenBaseException(err, ioe);
        }
        this.descriptors.put("META-INF/application.xml", this.app);
    }

    public void initialize() throws GenBaseException {
        for (EjbJar ejb : this.ejbjars) {
            ejb.initialize();
        }
        for (WebApp web : this.webapps) {
            web.initialize();
        }
        for (Client client : this.clients) {
            client.initialize();
        }
    }

    public String getName() {
        return this.appFilename;
    }

    private URLClassLoader createEJBClassLoader() throws GenBaseException {
        URL[] urls = new URL[this.pathFiles.size() + this.ejbjars.size()];
        int index = 0;
        for (File f : this.pathFiles) {
            try {
                urls[index] = f.toURL();
            }
            catch (IOException ioe) {
                String err = "Cannot convert " + f + " to URL.";
                throw new GenBaseException(err, ioe);
            }
            ++index;
        }
        Iterator i = this.ejbjars.iterator();
        while (i.hasNext()) {
            try {
                urls[index] = ((EjbJar)i.next()).getRootFile().toURL();
            }
            catch (IOException ioe) {
                String err = "Cannot transform as a URL : " + ioe.getMessage();
                throw new GenBaseException(err, ioe);
            }
            ++index;
        }
        try {
            return new EjbJarClassLoader(urls, this.getModuleClassloader());
        }
        catch (IOException ioe) {
            String err = "Cannot create EjbJarClassLoader";
            throw new GenBaseException(err, ioe);
        }
    }

    private URLClassLoader createEARClassLoader() throws GenBaseException {
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        String classpath = this.getManifest().getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        URL[] urls = new URL[]{};
        if (classpath != null) {
            String[] paths = classpath.split(" ");
            urls = new URL[paths.length];
            for (int i = 0; i < paths.length; ++i) {
                try {
                    URL path;
                    urls[i] = path = new File(this.getRootFile(), paths[i]).toURL();
                    continue;
                }
                catch (IOException ioe) {
                    String err = "Cannot transform '" + paths[i] + "' as a URL";
                    throw new GenBaseException(err, ioe);
                }
            }
        }
        return new URLClassLoader(urls, parent);
    }

    private void addClassPathEntry(Archive a) throws GenBaseException {
        String classpath = a.getManifest().getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        if (classpath != null) {
            String[] paths = classpath.split(" ");
            for (int i = 0; i < paths.length; ++i) {
                try {
                    File path = new File(a.getRootFile().getParentFile(), paths[i]).getCanonicalFile();
                    if (this.pathFiles.contains(path)) continue;
                    this.pathFiles.add(path);
                    continue;
                }
                catch (IOException ioe) {
                    String err = "Cannot add in EAR classpath :" + paths[i];
                    throw new GenBaseException(err, ioe);
                }
            }
        }
    }

    public Document getApplicationDoc() {
        return this.app;
    }

    public InputStream getApplicationInputStream() throws IOException {
        InputStream is = null;
        is = this.isPacked() ? this.getInputStream("META-INF/application.xml") : this.getInputStream("META-INF" + File.separator + "application.xml");
        return is;
    }

    public void addEjbJar(EjbJar ejbjar) {
        this.ejbjars.add(ejbjar);
        XMLUtils.addEjb(this.app, ejbjar);
    }

    public void addClient(Client client) {
        this.clients.add(client);
        XMLUtils.addClient(this.app, client);
    }

    public void addWebApp(WebApp webapp, String context) {
        if (!XMLUtils.isWebModuleAlreadyDeclared(this.app, webapp.getName())) {
            this.webapps.add(webapp);
            XMLUtils.addWebApp(this.app, webapp, context);
        }
        this.addFile(webapp.getRootFile(), webapp.getName());
    }

    public Iterator getEjbJars() {
        return this.ejbjars.iterator();
    }

    public Iterator getWebApps() {
        return this.webapps.iterator();
    }

    public Iterator getClients() {
        return this.clients.iterator();
    }

    public URLClassLoader getEARClassLoader() {
        return this.commonCL;
    }

    public URLClassLoader getEJBClassLoader() {
        return this.ejbCL;
    }

    public Map getDescriptors() {
        return this.descriptors;
    }

    public boolean omit(String name) {
        return name.equals("META-INF/application.xml") || name.equals("META-INF\\application.xml");
    }

    public void setClients(List clients) {
        this.clients = clients;
    }

    public void setEjbjars(List ejbjars) {
        this.ejbjars = ejbjars;
    }

    public void setWebapps(List webapps) {
        this.webapps = webapps;
    }

    public Document getApp() {
        return this.app;
    }

    public void close() {
        super.close();
        this.earDD = null;
        this.descriptors = null;
        this.app = null;
        this.ejbCL = null;
        this.commonCL = null;
        this.pathFiles = null;
        Iterator i = this.getEjbJars();
        while (i.hasNext()) {
            EjbJar ejbjar = (EjbJar)i.next();
            ejbjar.close();
        }
        i = this.getWebApps();
        while (i.hasNext()) {
            WebApp webapp = (WebApp)i.next();
            webapp.close();
        }
        i = this.getClients();
        while (i.hasNext()) {
            Client client = (Client)i.next();
            client.close();
        }
        this.clients = null;
        this.webapps = null;
        this.ejbjars = null;
    }
}

