/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.jmx.internal;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.jmx.internal.BaseJMXService;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.registry.RegistryService;
import org.ow2.jonas.service.JonasAlreadyStartedException;
import org.ow2.jonas.service.ServiceException;

public class JOnASJMXService
extends BaseJMXService {
    private static Logger logger = Log.getLogger("org.ow2.jonas.jmx");
    private static final String MX4J_COMMONS_LOGGER_CLASSNAME = "mx4j.log.CommonsLogger";
    private static final String MX4J_LOG_CLASSNAME = "mx4j.log.Log";
    private static final String MX4J_LOGGER_CLASS = "mx4j.log.Logger";
    private JMXConnectorServer[] connectorServers = null;
    private JMXServiceURL[] connectorServerURLs = null;
    private RegistryService registryService = null;
    private List connectorObjectNames = null;

    private void initializeMX4JLoggingSystem() {
        block6: {
            Class<?> mx4jCommonsLoggerClass = null;
            try {
                mx4jCommonsLoggerClass = Thread.currentThread().getContextClassLoader().loadClass(MX4J_COMMONS_LOGGER_CLASSNAME);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)"Class mx4j.log.CommonsLogger founded");
                }
                Object o = mx4jCommonsLoggerClass.newInstance();
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(MX4J_LOG_CLASSNAME);
                Class<?> mx4jLoggerClass = Thread.currentThread().getContextClassLoader().loadClass(MX4J_LOGGER_CLASS);
                Method m = clazz.getMethod("redirectTo", mx4jLoggerClass);
                m.invoke(clazz, o);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)"MX4J logging redirected to the Jakarta commons logger");
                }
            }
            catch (ClassNotFoundException cnfe) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("Class mx4j.log.CommonsLogger not found: " + cnfe));
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.WARN)) break block6;
                logger.log(BasicLevel.WARN, (Object)("Problem with mx4j.log.CommonsLogger instance creation " + e));
            }
        }
    }

    public void doStart() throws ServiceException {
        logger.log(BasicLevel.DEBUG, (Object)"Starting JMX Service");
        this.initializeMX4JLoggingSystem();
        super.doStart();
        String serverName = this.getJonasServerName();
        if (serverName == null) {
            throw new ServiceException("Cannot start JMX service. No serverName.");
        }
        String defaultProtocolName = this.registryService.getDefaultProtocolName();
        try {
            List protocols = this.registryService.getActiveProtocolNames();
            int nbProtocols = protocols.size();
            this.connectorServerURLs = new JMXServiceURL[nbProtocols];
            this.connectorServers = new JMXConnectorServer[nbProtocols];
            this.connectorObjectNames = new ArrayList();
            int index = 0;
            for (String name : protocols) {
                JMXConnectorServer connectorServer;
                String connectorName = null;
                this.registryService.setDefaultProtocol(name);
                String protocol = "rmi";
                URI carolURL = this.registryService.getProviderURL(name);
                String scheme = carolURL.getScheme();
                String host = carolURL.getHost();
                int port = this.registryService.getExportedObjectPort(name);
                String ictxFactory = this.registryService.getInitialContextFactoryName(name);
                Properties props = new Properties();
                props.put("jmx.remote.jndi.rebind", "true");
                props.put("java.naming.factory.initial", ictxFactory);
                props.put("java.naming.provider.url", carolURL.toString());
                JMXServiceURL serviceURL = null;
                if (name.equals("jrmp")) {
                    connectorName = "jrmpconnector_" + serverName;
                } else if (name.equals("irmi")) {
                    connectorName = "irmiconnector_" + serverName;
                    if (port != 0) {
                        ++port;
                    }
                } else {
                    if (!name.equals("iiop")) continue;
                    connectorName = "iiopconnector_" + serverName;
                    protocol = "iiop";
                    props.put("java.naming.corba.orb", new InitialContext().lookup("java:comp/ORB"));
                }
                serviceURL = new JMXServiceURL(protocol, host, port, "/jndi/" + carolURL.toString() + "/" + connectorName);
                this.connectorServers[index] = connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(serviceURL, props, null);
                String connectorObjectName = "connector_" + name;
                ObjectName connectorServerName = JonasObjectName.jmxConnectorServer(scheme, connectorObjectName);
                this.connectorObjectNames.add(connectorServerName);
                if (this.getJmxServer().isRegistered(connectorServerName)) {
                    this.getJmxServer().unregisterMBean(connectorServerName);
                }
                this.getJmxServer().registerMBean(connectorServer, connectorServerName);
                final int idx = index++;
                final JMXConnectorServer server = connectorServer;
                IExecution<Void> exec = new IExecution<Void>(){

                    @Override
                    public Void execute() throws Exception {
                        server.start();
                        ((JOnASJMXService)JOnASJMXService.this).connectorServerURLs[idx] = server.getAddress();
                        return null;
                    }
                };
                System.setProperty("carol.multipro.protocol", name);
                ExecutionResult<Void> res = RunnableHelper.execute(JOnASJMXService.class.getClassLoader(), exec);
                System.setProperty("carol.multipro.protocol", "any");
                if (!res.hasException()) continue;
                throw res.getException();
            }
        }
        catch (NameAlreadyBoundException ne) {
            logger.log(BasicLevel.DEBUG, (Object)("Cannot start JMX service " + ne));
            throw new JonasAlreadyStartedException();
        }
        catch (Exception e) {
            throw new ServiceException("Cannot start JMX service", e);
        }
        finally {
            this.registryService.setDefaultProtocol(defaultProtocolName);
        }
        logger.log(BasicLevel.INFO, (Object)("JMX Service started, using connector(s) " + Arrays.asList(this.connectorServerURLs)));
    }

    public void checkRequirements() throws ServiceException {
        super.checkRequirements();
        if (this.registryService == null) {
            this.throwRequirementException("Missing reference to " + RegistryService.class);
        }
    }

    public void doStop() {
        super.doStop();
        logger.log(BasicLevel.DEBUG, (Object)"Stopping JMX Service");
        if (this.connectorObjectNames != null) {
            for (final ObjectName name : this.connectorObjectNames) {
                try {
                    IExecution<Void> exec = new IExecution<Void>(){

                        @Override
                        public Void execute() throws Exception {
                            JOnASJMXService.this.getJmxServer().unregisterMBean(name);
                            return null;
                        }
                    };
                    String protocol = name.getKeyProperty("protocol");
                    System.setProperty("carol.multipro.protocol", protocol);
                    ExecutionResult<Void> result = RunnableHelper.execute(this.getClass().getClassLoader(), exec);
                    System.setProperty("carol.multipro.protocol", "any");
                    if (!result.hasException()) continue;
                    throw result.getException();
                }
                catch (Exception e) {
                    logger.log(BasicLevel.ERROR, (Object)("Cannot unregister Connector MBean for '" + name + "'"), (Throwable)e);
                }
            }
        }
        if (this.connectorServers != null) {
            for (int i = 0; i < this.connectorServers.length; ++i) {
                try {
                    this.connectorServers[i].stop();
                    continue;
                }
                catch (Exception e) {
                    logger.log(BasicLevel.INFO, (Object)"Cannot Stop JMX Connector", (Throwable)e);
                }
            }
        }
        logger.log(BasicLevel.INFO, (Object)"JMX Service stopped");
    }

    public JMXServiceURL[] getConnectorServerURLs() {
        return this.connectorServerURLs;
    }

    public void setRegistryService(RegistryService registryService) {
        this.registryService = registryService;
    }
}

