/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21.ha;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Stack;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.carol.cmi.controller.common.AbsClusterViewManager;
import org.ow2.carol.cmi.ha.RequestId;
import org.ow2.carol.cmi.ha.SessionId;
import org.ow2.carol.cmi.ha.interceptor.HACurrent;
import org.ow2.jonas.lib.ejb21.JSessionFactory;
import org.ow2.jonas.lib.ejb21.JSessionRemote;
import org.ow2.jonas.lib.ejb21.JStatefulSwitch;
import org.ow2.jonas.lib.ejb21.RequestCtx;
import org.ow2.jonas.lib.ejb21.ha.JRepUtil;
import org.ow2.jonas.lib.util.Log;

public abstract class JRepStatefulRemote
extends JSessionRemote
implements Remote {
    protected static Logger cmilogger = Log.getLogger("org.ow2.carol.cmi.ha");

    public JRepStatefulRemote(JSessionFactory bf) throws RemoteException {
        super(bf);
        cmilogger.log(BasicLevel.DEBUG, (Object)"");
    }

    public RequestCtx preInvoke(int txa) throws RemoteException {
        RequestCtx rctx = super.preInvoke(txa);
        this.preInvokeHook(rctx);
        return rctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postInvoke(RequestCtx rctx, Object response, boolean remove) throws RemoteException {
        try {
            this.postInvokeHook(rctx, response, remove);
        }
        catch (Exception e) {
            cmilogger.log(BasicLevel.ERROR, (Object)"Error calling postInvokeHook in sfsb.", (Throwable)e);
        }
        finally {
            super.postInvoke(rctx);
            JRepUtil.removeCurrentRequest();
        }
    }

    protected void injectState() {
        RequestId reqId;
        HACurrent current = HACurrent.getHACurrent();
        Stack<RequestId> requests = current.getRequests();
        if (requests != null && !requests.isEmpty() && (reqId = requests.peek()) != null) {
            JRepUtil.injectState(reqId.getObjectId(), (JStatefulSwitch)this.bs);
        }
    }

    protected boolean hasResponse() {
        HACurrent current = HACurrent.getHACurrent();
        Stack<RequestId> requests = current.getRequests();
        if (requests != null && !requests.isEmpty()) {
            RequestId reqId = requests.peek();
            if (reqId != null) {
                try {
                    return JRepUtil.hasBackupResponse(reqId);
                }
                catch (Exception e) {
                    cmilogger.log(BasicLevel.ERROR, (Object)("Cannot check response : " + reqId), (Throwable)e);
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    protected Object getResponse() {
        Object response = null;
        HACurrent current = HACurrent.getHACurrent();
        Stack<RequestId> requests = current.getRequests();
        if (requests != null && !requests.isEmpty()) {
            RequestId reqId = requests.peek();
            if (reqId != null) {
                try {
                    response = JRepUtil.getRepMgr().getBackupResponse(reqId);
                }
                catch (Exception e) {
                    cmilogger.log(BasicLevel.ERROR, (Object)("Cannot obtain response : " + reqId), (Throwable)e);
                    response = null;
                }
            } else {
                response = null;
            }
            requests.pop();
        }
        return response;
    }

    private void preInvokeHook(RequestCtx rctx) throws RemoteException {
        HACurrent current = HACurrent.getHACurrent();
        Stack<RequestId> requests = current.getRequests();
        if (requests != null && !requests.isEmpty()) {
            RequestId reqId = requests.peek();
            if (!reqId.getObjectId().getClientId().equals(AbsClusterViewManager.getClusterViewManager().getUUID())) {
                requests.clear();
                requests.push(reqId);
            }
            JRepUtil.preInvokeHook(this.bs, reqId.getObjectId(), rctx);
        }
    }

    private void postInvokeHook(RequestCtx rctx, Object response, boolean remove) {
        HACurrent current = HACurrent.getHACurrent();
        RequestId reqId = null;
        SessionId clusterOId = null;
        Stack<RequestId> requests = current.getRequests();
        if (requests != null && !requests.isEmpty()) {
            reqId = requests.peek();
            clusterOId = reqId.getObjectId();
            JRepUtil.postInvokeHook(rctx, clusterOId, this.bs, remove);
            if (requests.size() == 1) {
                try {
                    JRepUtil.getRepMgr().addResponse(reqId, response);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    cmilogger.log(BasicLevel.ERROR, (Object)"unable to obtain replication manager.", (Throwable)e);
                }
            }
        }
    }
}

