/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.domain;

import java.util.Collection;
import javax.management.JMException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.management.domain.DomainMonitor;
import org.ow2.jonas.lib.management.javaee.J2EEManagedObject;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.lib.util.Log;

public class J2EEDomain
extends J2EEManagedObject
implements MBeanRegistration {
    private String domainName = null;
    private static Logger logger = Log.getLogger("org.ow2.jonas.management.j2eemanagement");
    private String myJ2EEServerOn = null;
    private MBeanServer mbeanServer;
    private DomainMonitor domainMonitor = null;
    private static J2EEDomain unique;
    private JmxService jmxService = null;

    public J2EEDomain(String objectName) throws JMException {
        super(objectName, false, false, false);
        ObjectName myObjectName = ObjectName.getInstance(objectName);
        this.domainName = myObjectName.getKeyProperty("name");
        unique = this;
    }

    String getErrorMessage(String filename, String servername) {
        logger.log(BasicLevel.DEBUG, (Object)"");
        if (!this.isMaster()) {
            logger.log(BasicLevel.ERROR, (Object)"Operation allowed on master only");
            return null;
        }
        return this.domainMonitor.getErrorMessage(filename, servername);
    }

    public void forgetAllDeploy() {
        logger.log(BasicLevel.DEBUG, (Object)"");
        if (!this.isMaster()) {
            logger.log(BasicLevel.ERROR, (Object)"Operation allowed on master only");
            return;
        }
        this.domainMonitor.forgetAllDeploy();
    }

    public String[] getClusterDaemons() {
        logger.log(BasicLevel.DEBUG, (Object)"");
        if (!this.isMaster()) {
            logger.log(BasicLevel.ERROR, (Object)"Operation allowed on master only");
            return null;
        }
        return this.domainMonitor.getClusterDaemons();
    }

    public String[] getClusters() {
        logger.log(BasicLevel.DEBUG, (Object)"");
        if (!this.isMaster()) {
            logger.log(BasicLevel.ERROR, (Object)"Operation allowed on master only");
            return null;
        }
        return this.domainMonitor.getClusters();
    }

    public String getDescription() {
        if (!this.isMaster()) {
            return this.domainMonitor.getDescription();
        }
        return "Unknown";
    }

    public boolean isMaster() {
        return this.domainMonitor.isMaster();
    }

    public String getMyName() {
        return this.domainName;
    }

    public String[] getServerNames() {
        logger.log(BasicLevel.DEBUG, (Object)"");
        if (!this.isMaster()) {
            return this.getServerName();
        }
        return this.domainMonitor.getServerNames();
    }

    public String[] getServers() {
        logger.log(BasicLevel.DEBUG, (Object)"");
        if (!this.isMaster()) {
            return this.getServer();
        }
        boolean started = false;
        return this.domainMonitor.getServers(started);
    }

    public String[] getStartedServers() {
        logger.log(BasicLevel.DEBUG, (Object)"");
        if (!this.isMaster()) {
            return this.getServer();
        }
        boolean started = true;
        return this.domainMonitor.getServers(started);
    }

    public String createCluster(String name) {
        logger.log(BasicLevel.DEBUG, (Object)"");
        if (!this.isMaster()) {
            logger.log(BasicLevel.ERROR, (Object)"Operation allowed on master only");
            return null;
        }
        return this.domainMonitor.createCluster(name);
    }

    public void startServer(String serverName) {
        if (!this.isMaster()) {
            logger.log(BasicLevel.ERROR, (Object)"Operation only possible on master");
            return;
        }
        this.domainMonitor.startServer(serverName);
    }

    public void stopServer(String serverName) {
        if (!this.isMaster()) {
            logger.log(BasicLevel.ERROR, (Object)"Operation only possible on master");
            return;
        }
        this.domainMonitor.stopServer(serverName);
    }

    public void deployJar(String[] target, String fileName) {
        for (int i = 0; i < target.length; ++i) {
            this.deployOnTarget(target[i], fileName);
        }
    }

    public void deployEar(String[] target, String fileName) {
        for (int i = 0; i < target.length; ++i) {
            this.deployOnTarget(target[i], fileName);
        }
    }

    public void deployWar(String[] target, String fileName) {
        for (int i = 0; i < target.length; ++i) {
            this.deployOnTarget(target[i], fileName);
        }
    }

    public void deployRar(String[] target, String fileName) {
        for (int i = 0; i < target.length; ++i) {
            this.deployOnTarget(target[i], fileName);
        }
    }

    public void uploadDeployJar(String[] target, String fileName, boolean replaceExisting) {
        for (int i = 0; i < target.length; ++i) {
            this.uploadDeployOnTarget(target[i], fileName, replaceExisting);
        }
    }

    public void uploadDeployWar(String[] target, String fileName, boolean replaceExisting) {
        for (int i = 0; i < target.length; ++i) {
            this.uploadDeployOnTarget(target[i], fileName, replaceExisting);
        }
    }

    public void uploadDeployEar(String[] target, String fileName, boolean replaceExisting) {
        for (int i = 0; i < target.length; ++i) {
            this.uploadDeployOnTarget(target[i], fileName, replaceExisting);
        }
    }

    public void uploadDeployRar(String[] target, String fileName, boolean replaceExisting) {
        for (int i = 0; i < target.length; ++i) {
            this.uploadDeployOnTarget(target[i], fileName, replaceExisting);
        }
    }

    public void unDeployJar(String[] target, String fileName) {
        for (int i = 0; i < target.length; ++i) {
            this.unDeployOnTarget(target[i], fileName);
        }
    }

    public void unDeployWar(String[] target, String fileName) {
        for (int i = 0; i < target.length; ++i) {
            this.unDeployOnTarget(target[i], fileName);
        }
    }

    public void unDeployEar(String[] target, String fileName) {
        for (int i = 0; i < target.length; ++i) {
            this.unDeployOnTarget(target[i], fileName);
        }
    }

    public void unDeployRar(String[] target, String fileName) {
        for (int i = 0; i < target.length; ++i) {
            this.unDeployOnTarget(target[i], fileName);
        }
    }

    public String[] getDeployServers(String fileName) {
        if (!this.isMaster()) {
            logger.log(BasicLevel.ERROR, (Object)"Operation only possible on master");
            return null;
        }
        return this.domainMonitor.getDeployServers(fileName);
    }

    public String getDeployState(String fileName, String serverName) {
        if (!this.isMaster()) {
            logger.log(BasicLevel.ERROR, (Object)"Operation only possible on master");
            return null;
        }
        return this.domainMonitor.getDeployState(fileName, serverName);
    }

    public String[] getServersNotInCluster(String ClusterName) {
        if (!this.isMaster()) {
            logger.log(BasicLevel.ERROR, (Object)"Operation only possible on master");
            return null;
        }
        return this.domainMonitor.getServersNotInCluster(ClusterName);
    }

    public String[] getServersInCluster(String ClusterName) {
        if (!this.isMaster()) {
            logger.log(BasicLevel.ERROR, (Object)"Operation only possible on master");
            return null;
        }
        return this.domainMonitor.getServersInCluster(ClusterName);
    }

    public String getServerState(String serverName) {
        if (!this.isMaster()) {
            logger.log(BasicLevel.ERROR, (Object)"Operation only possible on master");
            return null;
        }
        return this.domainMonitor.getServerState(serverName);
    }

    public String getClusterState(String clusterName) {
        if (!this.isMaster()) {
            logger.log(BasicLevel.ERROR, (Object)"Operation only possible on master");
            return null;
        }
        return this.domainMonitor.getClusterState(clusterName);
    }

    public String getClusterdaemonState(String clusterdaemonName) {
        if (!this.isMaster()) {
            logger.log(BasicLevel.ERROR, (Object)"Operation only possible on master");
            return null;
        }
        return this.domainMonitor.getClusterdaemonState(clusterdaemonName);
    }

    public String getClusterType(String clusterName) {
        if (!this.isMaster()) {
            logger.log(BasicLevel.ERROR, (Object)"Operation only possible on master");
            return null;
        }
        return this.domainMonitor.getClusterType(clusterName);
    }

    public String getServerClusterdaemon(String serverName) {
        if (!this.isMaster()) {
            logger.log(BasicLevel.ERROR, (Object)"Operation only possible on master");
            return null;
        }
        return this.domainMonitor.getServerClusterdaemon(serverName);
    }

    public static J2EEDomain getInstance() {
        return unique;
    }

    public DomainMonitor getDomainMonitor() {
        return this.domainMonitor;
    }

    public void addLocalServer(String serverName, Collection urls) {
        logger.log(BasicLevel.DEBUG, (Object)"");
        if (this.isMaster()) {
            this.domainMonitor.addLocalServer(serverName, urls);
        }
    }

    public void setMaster(boolean ismaster, String serverName) {
        try {
            this.domainMonitor = new DomainMonitor(this.domainName, serverName);
            this.domainMonitor.setJmxService(this.jmxService);
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot create DomainMonitor", (Throwable)e);
        }
        if (ismaster) {
            this.domainMonitor.setMaster();
        }
    }

    public void setMyJ2EEServerOn(String myJ2EEServerOn) {
        this.myJ2EEServerOn = myJ2EEServerOn;
    }

    public boolean startRemoteTarget(String target) throws JMException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        return this.domainMonitor.startRemoteTarget(target);
    }

    public boolean stopRemoteTarget(String target) throws JMException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        return this.domainMonitor.stopRemoteTarget(target);
    }

    public boolean uploadDeployFileOn(String target, String filename) {
        logger.log(BasicLevel.DEBUG, (Object)"");
        return this.domainMonitor.uploadDeployFileOn(target, filename);
    }

    public ObjectName preRegister(MBeanServer mbeanServer, ObjectName name) throws Exception {
        String argName;
        logger.log(BasicLevel.DEBUG, (Object)"");
        if (name == null) {
            return J2eeObjectName.J2EEDomain(this.domainName);
        }
        this.mbeanServer = mbeanServer;
        String myName = this.getObjectName().toString();
        if (myName.equals(argName = name.toString())) {
            return name;
        }
        if (logger.isLoggable(BasicLevel.WARN)) {
            logger.log(BasicLevel.WARN, (Object)("Trying to register J2EEDomain MBean with the following name: " + argName + " when the expected name is: " + myName));
        }
        return ObjectName.getInstance(this.domainName);
    }

    public void postRegister(Boolean registrationDone) {
        logger.log(BasicLevel.DEBUG, (Object)"");
    }

    public void preDeregister() throws Exception {
        logger.log(BasicLevel.DEBUG, (Object)"");
    }

    public void postDeregister() {
        logger.log(BasicLevel.DEBUG, (Object)"");
    }

    private String[] getServer() {
        String[] sb = new String[]{this.myJ2EEServerOn};
        return sb;
    }

    private String[] getServerName() {
        String[] names = new String[1];
        try {
            ObjectName on = ObjectName.getInstance(this.myJ2EEServerOn);
            names[0] = on.getKeyProperty("name");
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        return names;
    }

    private void deployOnTarget(String target, String fileName) {
        if (!this.isMaster()) {
            logger.log(BasicLevel.ERROR, (Object)"Operation only possible on master");
            return;
        }
        this.domainMonitor.deployOnTarget(target, fileName);
    }

    private void uploadDeployOnTarget(String target, String fileName, boolean replaceExisting) {
        if (!this.isMaster()) {
            logger.log(BasicLevel.ERROR, (Object)"Operation only possible on master");
            return;
        }
        this.domainMonitor.uploadDeployOnTarget(target, fileName, replaceExisting);
    }

    private void unDeployOnTarget(String target, String fileName) {
        if (!this.isMaster()) {
            logger.log(BasicLevel.ERROR, (Object)"Operation only possible on master");
            return;
        }
        this.domainMonitor.unDeployOnTarget(target, fileName);
    }

    public void setJmxService(JmxService jmxService) {
        this.jmxService = jmxService;
    }
}

