/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.domain.cluster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.management.domain.DomainMonitor;
import org.ow2.jonas.lib.management.domain.cluster.BaseClusterMBean;
import org.ow2.jonas.lib.management.domain.cluster.ClusterFactory;
import org.ow2.jonas.lib.management.domain.cluster.ClusterMember;
import org.ow2.jonas.lib.management.domain.proxy.clusterd.ClusterDaemonProxy;
import org.ow2.jonas.lib.management.domain.proxy.server.ServerProxy;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.lib.util.Log;

public abstract class BaseCluster
implements BaseClusterMBean {
    protected String name = null;
    protected ObjectName objectName = null;
    protected Map members = new HashMap();
    protected ClusterFactory cf;
    protected int state = 0;
    public static final int STATE_INIT = 0;
    public static final int STATE_UP = 1;
    public static final int STATE_DOWN = 2;
    public static final int STATE_FAILED = 3;
    public static final int STATE_PARTIALLY_FAILED = 4;
    public static final int STATE_PARTIALLY_UP = 5;
    public static final int STATE_PARTIALLY_DOWN = 6;
    public static final int STATE_UNKNOWN = 7;
    protected static Logger logger = Log.getLogger("org.ow2.jonas.management.cluster");
    protected JmxService jmx = null;
    protected DomainMonitor dm;
    protected String domainName = null;

    public BaseCluster(ClusterFactory cf) {
        logger.log(BasicLevel.DEBUG, (Object)"");
        this.cf = cf;
        this.dm = cf.getDomainMonitor();
        this.domainName = this.dm.getDomainName();
        this.jmx = this.dm.getJmxService();
    }

    public abstract ClusterMember createClusterMember(String var1, ServerProxy var2);

    public ObjectName setName(String name) throws JMException {
        this.name = name;
        this.objectName = JonasObjectName.cluster(this.domainName, name, this.getType());
        return this.objectName;
    }

    public String getObjectName() {
        return this.objectName.toString();
    }

    public abstract String getType();

    public synchronized boolean addMember(ClusterMember m) {
        String mbr = m.getName();
        logger.log(BasicLevel.DEBUG, (Object)mbr);
        this.members.put(mbr, m);
        return true;
    }

    public synchronized ServerProxy getServerProxy(String name) {
        for (ClusterMember member : this.members.values()) {
            try {
                if (!member.getServerName().equals(name)) continue;
                return member.getProxy();
            }
            catch (JMException e) {
                logger.log(BasicLevel.WARN, (Object)("Cannot get server name: " + e));
                return null;
            }
        }
        return null;
    }

    public synchronized Collection getServerProxyList() {
        ArrayList<ServerProxy> ret = new ArrayList<ServerProxy>();
        for (ClusterMember m : this.members.values()) {
            ret.add(m.getProxy());
        }
        return ret;
    }

    public String getState() {
        this.updateState();
        switch (this.state) {
            case 0: {
                return "INIT";
            }
            case 1: {
                return "UP";
            }
            case 2: {
                return "DOWN";
            }
            case 3: {
                return "FAILED";
            }
            case 5: {
                return "PARTIALLY_UP";
            }
            case 6: {
                return "PARTIALLY_DOWN";
            }
            case 4: {
                return "PARTIALLY_FAILED";
            }
        }
        return "UNKNOWN";
    }

    public String getName() {
        return this.name;
    }

    public int getNbMembers() {
        return this.members.size();
    }

    public synchronized String[] getMembers() {
        logger.log(BasicLevel.DEBUG, (Object)"");
        Collection col = this.members.values();
        String[] result = new String[col.size()];
        int i = 0;
        for (ClusterMember m : col) {
            result[i++] = m.getObjectName().toString();
        }
        return result;
    }

    public void addServer(String svname, String[] urls, String cdn) throws JMException {
        ServerProxy proxy;
        ClusterDaemonProxy cdp = null;
        if (cdn != null && cdn.length() > 0 && (cdp = this.dm.findClusterDaemonProxy(cdn)) == null) {
            logger.log(BasicLevel.WARN, (Object)("Unknown ClusterDaemon :" + cdn));
        }
        if ((proxy = this.dm.findServerProxy(svname)) == null) {
            ArrayList<String> urlcol = new ArrayList<String>();
            for (int i = 0; i < urls.length; ++i) {
                urlcol.add(urls[i]);
            }
            proxy = new ServerProxy(this.dm, svname, urlcol, cdp);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Adding server : " + svname));
            }
            ObjectName on = JonasObjectName.serverProxy(this.domainName, svname);
            proxy.setObjectName(on.toString());
        }
        proxy.retrieveClusterdInfos();
        ClusterMember member = this.createClusterMember(svname, proxy);
        boolean added = this.addMember(member);
        if (!added) {
            throw new RuntimeException("Server already in cluster: " + svname);
        }
        ObjectName on = JonasObjectName.clusterMember(this.domainName, svname, this.getType(), this.name);
        member.setObjectName(on);
        MBeanServer mbeanServer = this.jmx.getJmxServer();
        if (mbeanServer.isRegistered(on)) {
            mbeanServer.unregisterMBean(on);
        }
        mbeanServer.registerMBean(member, on);
        this.dm.notifyServerProxyRunning(proxy);
    }

    public synchronized void removeServer(String svname) {
        ClusterMember member = (ClusterMember)this.members.remove(svname);
    }

    public synchronized boolean isMember(String serverName) {
        return this.members.containsKey(serverName);
    }

    public synchronized void startit() throws JMException {
        for (ClusterMember m : this.members.values()) {
            DeployThread th = new DeployThread(m.getProxy(), null, 5, false);
            th.start();
        }
    }

    public synchronized void stopit() throws JMException {
        for (ClusterMember m : this.members.values()) {
            DeployThread th = new DeployThread(m.getProxy(), null, 6, false);
            th.start();
        }
    }

    public synchronized void deployModule(String file) {
        for (ClusterMember m : this.members.values()) {
            DeployThread th = new DeployThread(m.getProxy(), file, 1, false);
            th.start();
        }
    }

    public synchronized void undeployModule(String file) {
        for (ClusterMember m : this.members.values()) {
            DeployThread th = new DeployThread(m.getProxy(), file, 2, false);
            th.start();
        }
    }

    public void uploadFile(String file, boolean repl) {
        for (ClusterMember m : this.members.values()) {
            DeployThread th = new DeployThread(m.getProxy(), file, 3, repl);
            th.start();
        }
    }

    public synchronized void uploadDeployModule(String file, boolean repl) {
        for (ClusterMember m : this.members.values()) {
            DeployThread th = new DeployThread(m.getProxy(), file, 4, repl);
            th.start();
        }
    }

    private synchronized void updateState() {
        int nbFailed = 0;
        int nbRunning = 0;
        int nbStopped = 0;
        int nbInitial = 0;
        int nbMembers = 0;
        for (ClusterMember member : this.members.values()) {
            int memberState = member.getServerState();
            switch (memberState) {
                case 0: 
                case 5: {
                    ++nbInitial;
                    break;
                }
                case 2: {
                    ++nbRunning;
                    break;
                }
                case 4: {
                    ++nbFailed;
                    break;
                }
                case 3: {
                    ++nbStopped;
                }
            }
            ++nbMembers;
        }
        this.state = nbInitial == nbMembers ? 0 : (nbFailed == nbMembers ? 3 : (nbRunning == nbMembers ? 1 : (nbStopped == nbMembers ? 2 : (nbFailed > 0 ? 4 : (nbRunning > 0 ? 5 : (nbStopped > 0 ? 6 : 7))))));
    }

    public class DeployThread
    extends Thread {
        private ServerProxy proxy;
        private String filename;
        private int action;
        private boolean replace;

        public DeployThread(ServerProxy proxy, String filename, int action, boolean replace) {
            this.proxy = proxy;
            this.filename = filename;
            this.action = action;
            this.replace = replace;
        }

        public void run() {
            switch (this.action) {
                case 5: {
                    this.proxy.startit();
                    break;
                }
                case 6: {
                    this.proxy.stopit();
                    break;
                }
                case 1: {
                    this.proxy.deployModule(this.filename);
                    break;
                }
                case 2: {
                    this.proxy.undeployModule(this.filename);
                    break;
                }
                case 4: {
                    this.proxy.uploadDeployModule(this.filename, this.replace);
                    break;
                }
                case 3: {
                    this.proxy.uploadFile(this.filename, this.replace);
                }
            }
        }
    }
}

