/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.work;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.lib.work.FileManagerException;

public class FileManager {
    private static final String TIMESTAMP_FORMAT = "_yyyy.MM.dd-HH.mm.ss";
    private static final int BUFFER_SIZE = 2048;
    private static Logger logger = Log.getLogger("org.ow2.jonas.work");

    protected FileManager() {
    }

    public static String fileToTimeStampDir(URL urlFileName) throws FileManagerException {
        return FileManager.fileToTimeStampDir(urlFileName, "");
    }

    public static String fileToTimeStampDir(URL urlFileName, String ext) throws FileManagerException {
        if (!urlFileName.getProtocol().equalsIgnoreCase("file")) {
            throw new FileManagerException("Only the file:/ URL can be used");
        }
        File urlFile = null;
        urlFile = new File(urlFileName.getFile());
        if (!urlFile.exists()) {
            throw new FileManagerException("The file " + urlFileName.getFile() + " was not found.");
        }
        SimpleDateFormat sdf = new SimpleDateFormat(TIMESTAMP_FORMAT);
        long lastModified = urlFile.lastModified();
        if (lastModified == 0L) {
            throw new FileManagerException("Can't read the last modified time for the file" + urlFile + ".");
        }
        Date d = new Date(lastModified);
        String stReturn = urlFile.getName();
        int lastIndex = stReturn.lastIndexOf(".");
        if (lastIndex == -1) {
            throw new FileManagerException("The specified file " + urlFileName.getFile() + " is not a file with the format XXX.ear.");
        }
        stReturn = stReturn.substring(0, lastIndex);
        stReturn = stReturn + sdf.format(d) + ext;
        return stReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void dump(InputStream in, File earEntryFile) throws FileManagerException {
        try {
            FileOutputStream out = new FileOutputStream(earEntryFile);
            int n = 0;
            try {
                byte[] buffer = new byte[2048];
                while ((n = in.read(buffer)) > 0) {
                    out.write(buffer, 0, n);
                }
            }
            finally {
                out.close();
            }
        }
        catch (IOException e) {
            String err = "Error while uncompressing the file " + earEntryFile;
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new FileManagerException(err, e);
        }
    }
}

