/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.resource.internal.osgi;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.properties.ServerProperties;
import org.ow2.jonas.resource.ResourceService;
import org.ow2.jonas.resource.internal.JOnASResourceService;
import org.ow2.jonas.tm.TransactionService;
import org.ow2.jonas.workmanager.WorkManagerService;

public class Activator
implements BundleActivator {
    private JOnASResourceService resource;
    private ServiceRegistration myServiceRegistration;

    public void start(BundleContext bc) throws Exception {
        System.out.println("Starting JOnAS Resource Service Bundle...");
        this.resource = new JOnASResourceService();
        ServiceReference sr = bc.getServiceReference(ServerProperties.class.getName());
        ServerProperties props = (ServerProperties)bc.getService(sr);
        this.resource.setServerProperties(props);
        sr = bc.getServiceReference(TransactionService.class.getName());
        TransactionService transactionService = (TransactionService)bc.getService(sr);
        this.resource.setTransactionService(transactionService);
        sr = bc.getServiceReference(JmxService.class.getName());
        JmxService jmxService = (JmxService)bc.getService(sr);
        this.resource.setJmxService(jmxService);
        sr = bc.getServiceReference(WorkManagerService.class.getName());
        WorkManagerService workManagerService = (WorkManagerService)bc.getService(sr);
        this.resource.setWorkManagerService(workManagerService);
        this.resource.checkRequirements();
        this.resource.start();
        this.myServiceRegistration = bc.registerService(ResourceService.class.getName(), (Object)this.resource, null);
    }

    public void stop(BundleContext bc) throws Exception {
        System.out.println("Stopping JOnAS Resource Service Bundle...");
        this.myServiceRegistration.unregister();
        if (this.resource != null) {
            this.resource.stop();
        }
    }
}

