/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.deploy.impl.deployer;

import java.util.ArrayList;
import java.util.List;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.ee.deploy.api.deployer.UnsupportedDeployerException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeployerManager
implements IDeployerManager {
    public static final String DEPLOYER_FACTORY_CLASS_NAME = DeployerManager.class.getName();
    private static Log logger = LogFactory.getLog(DeployerManager.class);
    private List<IDeployer> deployers = new ArrayList<IDeployer>();

    @Override
    public void register(IDeployer deployer) {
        if (deployer != null) {
            logger.debug("Registering deployer ''{0}''", deployer.getClass());
            this.deployers.add(deployer);
        }
    }

    @Override
    public void unregister(IDeployer deployer) {
        if (this.deployers.contains(deployer)) {
            logger.debug("Unregistering deployer ''{0}''", deployer);
            this.deployers.remove(deployer);
        } else {
            logger.warn("Cannot unregister the deployer ''{0}'' as it is not registered.", deployer);
        }
    }

    protected IDeployer findDeployerForDeployable(IDeployable<?> deployable) throws UnsupportedDeployerException {
        for (IDeployer deployer : this.deployers) {
            if (!deployer.supports(deployable)) continue;
            return deployer;
        }
        throw new UnsupportedDeployerException("No deployer was found for the deployable '" + deployable + "'.");
    }

    @Override
    public void deploy(IDeployable<?> deployable) throws DeployerException, UnsupportedDeployerException {
        this.findDeployerForDeployable(deployable).deploy(deployable);
    }

    @Override
    public void undeploy(IDeployable<?> deployable) throws DeployerException, UnsupportedDeployerException {
        this.findDeployerForDeployable(deployable).undeploy(deployable);
    }

    @Override
    public void isDeployed(IDeployable<?> deployable) throws DeployerException, UnsupportedDeployerException {
        this.findDeployerForDeployable(deployable).isDeployed(deployable);
    }
}

