/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.pool.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.Pool;
import org.ow2.util.pool.api.PoolAttributes;
import org.ow2.util.pool.api.PoolException;
import org.ow2.util.pool.impl.PoolEntryStatistics;
import org.ow2.util.pool.impl.PoolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPool<InstanceType, Clue>
implements Pool<InstanceType, Clue>,
PoolAttributes {
    private static final long DEFAULT_TIMEOUT = 10000L;
    private static final int DEFAULT_MAX_WAITERS = 1000;
    private static final int NO_LIMIT = -1;
    private Log logger = LogFactory.getLog(JPool.class);
    private PoolFactory<InstanceType, Clue> poolFactory = null;
    private List<InstanceType> availableList = null;
    private List<InstanceType> busyList = null;
    private Map<InstanceType, PoolEntryStatistics> infoMap = null;
    private int minSize = 0;
    private int maxSize = -1;
    private int initSize = 0;
    private boolean strict = true;
    private int maxWaiters = 1000;
    private long waiterTimeout = 10000L;
    private int currentWaiters = 0;
    private int highMaxWaiters = 0;
    private int totalWaiters = 0;
    private long totalWaitingTime = 0L;
    private long highWaitingTime = 0L;
    private int servedInstance = 0;
    private int rejectedTimeout = 0;
    private int rejectedFull = 0;
    private boolean allowSharedInstance = true;

    public JPool(PoolFactory<InstanceType, Clue> poolFactory) {
        this.poolFactory = poolFactory;
        this.availableList = new ArrayList<InstanceType>();
        this.busyList = new ArrayList<InstanceType>();
        this.infoMap = new HashMap<InstanceType, PoolEntryStatistics>();
    }

    @Override
    public InstanceType get() throws PoolException {
        return this.get(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized InstanceType get(Clue clue) throws PoolException {
        Object instance = null;
        long timeToWait = this.waiterTimeout;
        while (instance == null) {
            if (!this.availableList.isEmpty()) {
                this.logger.debug("Instances are available", new Object[0]);
                int indexToExtract = -1;
                if (clue == null) {
                    this.logger.debug("No clue, return the first available entry.", new Object[0]);
                    indexToExtract = 0;
                } else {
                    this.logger.debug("Clue is used, try to get a matching entry.", new Object[0]);
                    for (int i = 0; i < this.availableList.size(); ++i) {
                        InstanceType tmpInstance = this.availableList.get(i);
                        if (!this.poolFactory.isMatching(tmpInstance, clue)) continue;
                        this.logger.debug("Found a matching instance, instance = {0}", tmpInstance);
                        indexToExtract = i;
                        break;
                    }
                }
                if (indexToExtract != -1) {
                    this.logger.debug("Remove from available instance, item with index {0}", indexToExtract);
                    instance = this.availableList.remove(indexToExtract);
                    this.busyList.add(instance);
                }
            }
            if (instance != null) continue;
            int curSize = this.availableList.size() + this.busyList.size();
            boolean sharedInstance = true;
            if (!this.allowSharedInstance) {
                for (int i = 0; i < this.busyList.size(); ++i) {
                    InstanceType tmpInstance = this.busyList.get(i);
                    if (!this.poolFactory.isMatching(tmpInstance, clue)) continue;
                    this.logger.debug("Found a matching instance, instance = {0}", tmpInstance);
                    sharedInstance = false;
                    break;
                }
            }
            if (sharedInstance && (this.maxSize == -1 || curSize < this.maxSize)) {
                this.logger.debug("Maximum size not reached, can create a new entry with clue = {0}", clue);
                instance = this.poolFactory.create(clue);
                this.busyList.add(instance);
                continue;
            }
            if (sharedInstance && this.availableList.size() > 0) {
                this.logger.debug("limit reached but entries available in the pool. Replace one by a new one.", new Object[0]);
                InstanceType previousInstance = this.availableList.get(0);
                this.poolFactory.remove(previousInstance);
                this.availableList.remove(previousInstance);
                this.infoMap.remove(previousInstance);
                instance = this.poolFactory.create(clue);
                this.busyList.add(instance);
                continue;
            }
            this.logger.debug("limit reached and no available instances in the pool", new Object[0]);
            boolean timeoutWokenUp = true;
            long startSleeping = 0L;
            if (timeToWait > 0L && this.currentWaiters < this.maxWaiters) {
                ++this.currentWaiters;
                if (this.highMaxWaiters < this.currentWaiters) {
                    this.highMaxWaiters = this.currentWaiters;
                }
                if (startSleeping == 0L) {
                    startSleeping = System.currentTimeMillis();
                    this.logger.debug("Waiting an instance", new Object[0]);
                }
                try {
                    this.wait(timeToWait);
                }
                catch (InterruptedException ie) {
                    this.logger.warn("Waiter has been interrupted", ie);
                }
                finally {
                    --this.currentWaiters;
                }
                long sleepTime = System.currentTimeMillis() - startSleeping;
                timeoutWokenUp = this.waiterTimeout - sleepTime <= 0L;
                ++this.totalWaiters;
                this.totalWaitingTime += sleepTime;
                if (this.highWaitingTime < sleepTime) {
                    this.highWaitingTime = sleepTime;
                }
                if (!timeoutWokenUp) continue;
            }
            if (!timeoutWokenUp || !this.availableList.isEmpty() || this.busyList.size() < this.maxSize) continue;
            if (startSleeping > 0L) {
                ++this.rejectedTimeout;
                this.logger.warn("Cannot create an instance due to a timeout", new Object[0]);
            } else {
                ++this.rejectedFull;
                this.logger.warn("Cannot create an instance", new Object[0]);
            }
            throw new PoolException("No more instances available");
        }
        PoolEntryStatistics poolEntryStat = new PoolEntryStatistics();
        this.infoMap.put(instance, poolEntryStat);
        ++this.servedInstance;
        return (InstanceType)instance;
    }

    @Override
    public synchronized void release(InstanceType instance) throws PoolException {
        if (!this.busyList.contains(instance)) {
            this.logger.debug("Attempt to release inactive resource {0}. Probably discarded.", instance);
            return;
        }
        this.busyList.remove(instance);
        this.logger.debug("Put back into the pool the instance {0}", instance);
        this.availableList.add(instance);
        this.infoMap.remove(instance);
        if (this.currentWaiters > 0) {
            this.notify();
        }
    }

    @Override
    public synchronized void discard(InstanceType instance) throws PoolException {
        if (!this.busyList.contains(instance)) {
            throw new PoolException("Attempt to discard an inactive resource(" + instance + ")");
        }
        this.poolFactory.remove(instance);
        this.busyList.remove(instance);
        this.infoMap.remove(instance);
        if (this.currentWaiters > 0) {
            this.notify();
        }
    }

    public void setAllowSharedInstance(boolean allowSharedInstance) {
        this.allowSharedInstance = allowSharedInstance;
    }

    public boolean isAllowSharedInstance() {
        return this.allowSharedInstance;
    }

    @Override
    public void start() throws PoolException {
    }

    @Override
    public void stop() throws PoolException {
    }
}

