/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.xmlconfig.mapping;

import java.net.URL;
import org.ow2.util.xml.DocumentParser;
import org.ow2.util.xml.DocumentParserException;
import org.ow2.util.xml.XMLUtils;
import org.ow2.util.xmlconfig.XMLConfigurationException;
import org.ow2.util.xmlconfig.mapping.AttributeMapping;
import org.ow2.util.xmlconfig.mapping.ClassMapping;
import org.ow2.util.xmlconfig.mapping.XMLMapping;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XMLMappingBuilder {
    private static final String PACKAGE_ELEMENT = "package";
    private static final String CLASS_ELEMENT = "class";
    private static final String ATTRIBUTE_ELEMENT = "attribute";
    private URL mappingURL = null;
    private XMLMapping xmlMapping = null;
    private final String nameSpace;

    public XMLMappingBuilder(String nameSpace, URL mappingURL) {
        this.mappingURL = mappingURL;
        this.xmlMapping = new XMLMapping();
        this.nameSpace = nameSpace;
    }

    public void build() throws XMLConfigurationException {
        Document xmlMappingConfigurationDocument = null;
        try {
            xmlMappingConfigurationDocument = DocumentParser.getDocument(this.mappingURL, false, null);
        }
        catch (DocumentParserException e) {
            throw new XMLConfigurationException("Cannot get a document on the given url '" + this.mappingURL + "'.", e);
        }
        Element rootMappingElement = xmlMappingConfigurationDocument.getDocumentElement();
        NodeList packageList = rootMappingElement.getElementsByTagNameNS(this.nameSpace, PACKAGE_ELEMENT);
        for (int i = 0; i < packageList.getLength(); ++i) {
            Element packageElement = (Element)packageList.item(i);
            String packageName = XMLUtils.getAttributeValue(packageElement, "name");
            NodeList classList = packageElement.getElementsByTagNameNS(this.nameSpace, CLASS_ELEMENT);
            this.addClassMapping(classList, packageName + ".", true);
        }
        NodeList classList = rootMappingElement.getElementsByTagNameNS(this.nameSpace, CLASS_ELEMENT);
        this.addClassMapping(classList, "", false);
    }

    private void addClassMapping(NodeList classList, String packageName, boolean packageParent) {
        for (int c = 0; c < classList.getLength(); ++c) {
            Element classElement = (Element)classList.item(c);
            if (classElement.getParentNode().getNodeName().equals(PACKAGE_ELEMENT) && !packageParent) continue;
            ClassMapping classMapping = new ClassMapping();
            String name = XMLUtils.getAttributeValue(classElement, "name");
            String className = packageName + name;
            classMapping.setName(className);
            String alias = XMLUtils.getAttributeValue(classElement, "alias");
            classMapping.setAlias(alias);
            String elementAttribute = XMLUtils.getAttributeValue(classElement, "element-attribute");
            classMapping.setElementAttribute(elementAttribute);
            NodeList attributeList = classElement.getElementsByTagNameNS(this.nameSpace, ATTRIBUTE_ELEMENT);
            for (int a = 0; a < attributeList.getLength(); ++a) {
                String isListElementName;
                Element attributeElement = (Element)attributeList.item(a);
                AttributeMapping attributeMapping = new AttributeMapping();
                String attributeName = XMLUtils.getAttributeValue(attributeElement, "name");
                attributeMapping.setName(attributeName);
                String isElementName = XMLUtils.getAttributeValue(attributeElement, "element");
                if (Boolean.parseBoolean(isElementName)) {
                    attributeMapping.setElement();
                }
                if (Boolean.parseBoolean(isListElementName = XMLUtils.getAttributeValue(attributeElement, "isList"))) {
                    attributeMapping.setListElement();
                }
                String getter = XMLUtils.getAttributeValue(attributeElement, "getter");
                attributeMapping.setGetter(getter);
                String setter = XMLUtils.getAttributeValue(attributeElement, "setter");
                attributeMapping.setSetter(setter);
                String attributeAlias = XMLUtils.getAttributeValue(attributeElement, "alias");
                attributeMapping.setAlias(attributeAlias);
                classMapping.addAttributeMapping(attributeMapping);
            }
            this.xmlMapping.addClassMapping(classMapping);
        }
    }

    public XMLMapping getXmlMapping() {
        return this.xmlMapping;
    }
}

