/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.ejb.wrapper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.ejb.DeploymentDesc;
import org.ow2.jonas.lib.bootstrap.LoaderManager;
import org.ow2.jonas.lib.bootstrap.loader.JClassLoader;
import org.ow2.jonas.lib.util.Log;

public class EjbManagerWrapper {
    private static final String EJB_MANAGER_CLASSNAME = "org.ow2.jonas.deployment.ejb.lib.EjbDeploymentDescManager";
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.ejb");

    private EjbManagerWrapper() {
    }

    public static DeploymentDesc getDeploymentDesc(URL url, ClassLoader moduleCL, ClassLoader earCL) throws DeploymentDescException {
        LoaderManager lm = LoaderManager.getInstance();
        DeploymentDesc dd = null;
        try {
            JClassLoader tools = lm.getToolsLoader();
            Class<?> manager = tools.loadClass(EJB_MANAGER_CLASSNAME);
            Method m = manager.getDeclaredMethod("getInstance", new Class[0]);
            Object instance = m.invoke(null, new Object[0]);
            m = manager.getDeclaredMethod("getDeploymentDesc", URL.class, ClassLoader.class, ClassLoader.class);
            dd = (DeploymentDesc)m.invoke(instance, url, moduleCL, earCL);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (DeploymentDescException.class.isInstance(t)) {
                throw (DeploymentDescException)ite.getTargetException();
            }
            throw new DeploymentDescException("EjbDeploymentDescManager.getDeploymentDesc fails", t);
        }
        catch (Exception e) {
            throw new DeploymentDescException("Problems when using reflection on EjbDeploymentDescManager", e);
        }
        return dd;
    }

    public static void setAvailableEjbJarsAndAltDDs(URLClassLoader earClassLoader, URL[] jarUrls, URL[] ejbsAltDDs) {
        LoaderManager lm = LoaderManager.getInstance();
        try {
            JClassLoader tools = lm.getToolsLoader();
            Class<?> manager = tools.loadClass(EJB_MANAGER_CLASSNAME);
            Method m = manager.getDeclaredMethod("getInstance", new Class[0]);
            Object instance = m.invoke(null, new Object[0]);
            m = manager.getDeclaredMethod("setAvailableEjbJarsAndAltDDs", ClassLoader.class, URL[].class, URL[].class);
            m.invoke(instance, earClassLoader, jarUrls, ejbsAltDDs);
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)e);
        }
    }

    public static void setParsingWithValidation(boolean b) {
        LoaderManager lm = LoaderManager.getInstance();
        try {
            JClassLoader tools = lm.getToolsLoader();
            Class<?> manager = tools.loadClass(EJB_MANAGER_CLASSNAME);
            Method m = manager.getDeclaredMethod("setParsingWithValidation", Boolean.TYPE);
            m.invoke(null, new Boolean(b));
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)e);
        }
    }

    public static void removeCache(ClassLoader classLoader) {
        LoaderManager lm = LoaderManager.getInstance();
        try {
            JClassLoader tools = lm.getToolsLoader();
            Class<?> manager = tools.loadClass(EJB_MANAGER_CLASSNAME);
            Method m = manager.getDeclaredMethod("getInstance", new Class[0]);
            Object instance = m.invoke(null, new Object[0]);
            m = manager.getDeclaredMethod("removeCache", ClassLoader.class);
            m.invoke(instance, classLoader);
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)e);
        }
    }
}

