/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.irmi;

import java.util.HashMap;
import java.util.Map;
import org.ow2.carol.irmi.Pair;

public class UnionClassLoader
extends ClassLoader {
    private static Map LOADERS = new HashMap();
    private ClassLoader one;
    private ClassLoader two;

    public static synchronized UnionClassLoader get(ClassLoader one, ClassLoader two) {
        Pair key = new Pair((Object)one, (Object)two);
        UnionClassLoader result = (UnionClassLoader)LOADERS.get(key);
        if (result == null) {
            result = new UnionClassLoader(one, two);
            LOADERS.put(key, result);
        }
        return result;
    }

    public UnionClassLoader(ClassLoader one, ClassLoader two) {
        this.one = one;
        this.two = two;
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return this.one.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return this.two.loadClass(name);
        }
    }
}

