/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.base;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.xml.namespace.QName;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.deployment.api.IServiceRefDesc;
import org.ow2.jonas.deployment.common.HandlerDesc;
import org.ow2.jonas.deployment.web.WebContainerDeploymentDesc;
import org.ow2.jonas.deployment.web.WebContainerDeploymentDescException;
import org.ow2.jonas.deployment.web.wrapper.WebManagerWrapper;
import org.ow2.jonas.deployment.ws.JaxRpcPortComponentDesc;
import org.ow2.jonas.deployment.ws.PortComponentDesc;
import org.ow2.jonas.deployment.ws.SSBPortComponentDesc;
import org.ow2.jonas.deployment.ws.ServiceDesc;
import org.ow2.jonas.deployment.ws.WSDLFile;
import org.ow2.jonas.deployment.ws.WSDeploymentDesc;
import org.ow2.jonas.deployment.ws.WSDeploymentDescException;
import org.ow2.jonas.deployment.ws.wrapper.WSManagerWrapper;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.loader.WebappClassLoader;
import org.ow2.jonas.lib.naming.ComponentContext;
import org.ow2.jonas.lib.naming.URLFactory;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.I18n;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.lib.util.ModuleNamingUtils;
import org.ow2.jonas.naming.JNamingManager;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.web.JWebContainerService;
import org.ow2.jonas.web.JWebContainerServiceException;
import org.ow2.jonas.ws.WSServiceException;
import org.ow2.jonas.ws.WebServicesService;
import org.ow2.jonas.ws.base.BaseWebServicesServiceMBean;
import org.ow2.jonas.ws.base.WSDLManager;
import org.ow2.jonas.ws.base.factory.JServiceFactory;
import org.ow2.jonas.ws.base.factory.JServiceFactoryFinder;
import org.ow2.jonas.ws.base.handler.WSDLHandler;
import org.ow2.jonas.ws.base.handler.WSDLHandlerFactory;
import org.ow2.jonas.ws.base.mbean.Handler;
import org.ow2.jonas.ws.base.mbean.PortComponent;
import org.ow2.jonas.ws.base.mbean.Service;
import org.ow2.jonas.ws.base.mbean.WebServicesObjectName;

public abstract class BaseWebServicesService
extends AbsServiceImpl
implements WebServicesService,
BaseWebServicesServiceMBean {
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.ws");
    private static I18n i18n = null;
    private WSDLManager wsdlManager = null;
    private JWebContainerService webService = null;
    private JmxService jmxService = null;
    private Map deployments = new HashMap();
    private Map webservicesMBeans = new HashMap();
    private String endpointURLPrefix = null;
    private boolean autoWSGen = true;
    private JNamingManager naming;

    public BaseWebServicesService() {
        IExecution<I18n> exec = new IExecution<I18n>(){

            public I18n execute() {
                return I18n.getInstance(BaseWebServicesService.class);
            }
        };
        ExecutionResult result = RunnableHelper.execute((ClassLoader)this.getClass().getClassLoader(), (IExecution)exec);
        i18n = (I18n)result.getResult();
    }

    public void checkRequirements() throws ServiceException {
        if (this.jmxService == null) {
            this.throwRequirementException("Missing " + JmxService.class + "reference.");
        }
        if (this.wsdlManager == null) {
            this.throwRequirementException("Missing configuration for wsdlhandlers.");
        }
    }

    public void setWsdlhandlers(String param) {
        List handlers = BaseWebServicesService.convertToList((String)param);
        this.wsdlManager = new WSDLManager();
        WSDLHandlerFactory factory = WSDLHandlerFactory.newInstance();
        for (String name : handlers) {
            WSDLHandler handler = factory.newHandler(name);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Adding WSDLHandler '" + name + "'"));
            }
            this.wsdlManager.addHandler(handler);
        }
    }

    public void setUrlPrefix(String prefix) {
        this.endpointURLPrefix = prefix;
    }

    public void setParsingwithvalidation(boolean validate) {
        WSManagerWrapper.setParsingWithValidation((boolean)validate);
        if (!validate) {
            logger.log(BasicLevel.DEBUG, (Object)"WebServices XML parsing without validation");
        } else {
            logger.log(BasicLevel.DEBUG, (Object)"WebServices XML parsing with validation");
        }
    }

    public void setAutoWsgenEngaged(boolean engage) {
        this.autoWSGen = engage;
    }

    public void deployWebServices(Context ctx) throws WSServiceException {
        ComponentContext compCtx;
        int i;
        URL[] jarUrls = null;
        URL[] warUrls = null;
        URL earURL = null;
        ClassLoader ejbClassLoader = null;
        ClassLoader earClassLoader = null;
        Map warCtxRootMapping = null;
        String unpackDir = null;
        try {
            jarUrls = (URL[])ctx.lookup("jarUrls");
            warUrls = (URL[])ctx.lookup("warUrls");
            unpackDir = (String)ctx.lookup("unpackDir");
        }
        catch (NamingException e) {
            String err = i18n.getMessage("AbsWebServicesServiceImpl.deployWebServices.ctxParamProblem");
            logger.log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
            throw new WSServiceException(err, (Throwable)e);
        }
        try {
            earURL = (URL)ctx.lookup("earURL");
            earClassLoader = (ClassLoader)ctx.lookup("earClassLoader");
            warCtxRootMapping = (Map)ctx.lookup("warCtxRootMapping");
            ejbClassLoader = (ClassLoader)ctx.lookup("ejbClassLoader");
        }
        catch (NamingException ne) {
            earURL = null;
            earClassLoader = null;
            warCtxRootMapping = null;
            ejbClassLoader = null;
        }
        URLClassLoader loaderForCls = null;
        String earAppName = null;
        if (earURL != null) {
            earAppName = ModuleNamingUtils.fromURL((URL)earURL);
        }
        String fileName = null;
        WSDeploymentDesc wsDD = null;
        for (i = 0; i < warUrls.length; ++i) {
            fileName = warUrls[i].getFile();
            logger.log(BasicLevel.DEBUG, (Object)("Analyzing war '" + fileName + "' for web services"));
            loaderForCls = this.webService.getClassLoader(warUrls[i], earAppName, ejbClassLoader);
            WebappClassLoader webLoader = (WebappClassLoader)loaderForCls;
            URL url = webLoader.getBaseURL();
            try {
                wsDD = WSManagerWrapper.getDeploymentDesc((URL)warUrls[i], (URL)url, (ClassLoader)loaderForCls, (ClassLoader)earClassLoader);
            }
            catch (WSDeploymentDescException wsdde) {
                String err = i18n.getMessage("AbsWebServicesServiceImpl.deployWebServices.wsddEx", (Object)fileName);
                logger.log(BasicLevel.ERROR, (Object)(err + ": " + (Object)((Object)wsdde)));
                throw new WSServiceException(err, (Throwable)wsdde);
            }
            if (wsDD == null) continue;
            try {
                compCtx = new ComponentContext(fileName);
                compCtx.rebind("wsDD", (Object)wsDD);
                compCtx.rebind("cl", (Object)loaderForCls);
                if (earClassLoader != null) {
                    compCtx.rebind("earCL", (Object)earClassLoader);
                }
                compCtx.rebind("warURL", (Object)warUrls[i]);
                if (warCtxRootMapping != null) {
                    compCtx.rebind("warContextRoot", warCtxRootMapping.get(warUrls[i]));
                } else {
                    compCtx.rebind("warContextRoot", (Object)"");
                }
                this.doDeployWebServices((Context)compCtx);
                continue;
            }
            catch (NamingException ne) {
                String err = i18n.getMessage("AbsWebServicesServiceImpl.deployWebServices.bindError", (Object)fileName);
                logger.log(BasicLevel.ERROR, (Object)err);
                throw new WSServiceException(err, (Throwable)ne);
            }
        }
        if (jarUrls.length != 0 && warCtxRootMapping == null) {
            String err = i18n.getMessage("AbsWebServicesServiceImpl.deployWebServices.ctxRootMappingMissing");
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new WSServiceException(err);
        }
        for (i = 0; i < jarUrls.length; ++i) {
            fileName = jarUrls[i].getFile();
            logger.log(BasicLevel.DEBUG, (Object)("Analyzing EjbJar '" + fileName + "' for web services"));
            URLClassLoader webClassLoader = null;
            try {
                wsDD = WSManagerWrapper.getDeploymentDesc((URL)jarUrls[i], (ClassLoader)ejbClassLoader, (ClassLoader)earClassLoader);
            }
            catch (WSDeploymentDescException wsdde) {
                String err = i18n.getMessage("AbsWebServicesServiceImpl.deployWebServices.wsddEx", (Object)fileName);
                logger.log(BasicLevel.ERROR, (Object)(err + ": " + (Object)((Object)wsdde)));
                throw new WSServiceException(err, (Throwable)wsdde);
            }
            if (wsDD == null) continue;
            URL warURL = null;
            try {
                if (wsDD.getWarFile() != null) {
                    warURL = new File(new URL(unpackDir + File.separator + wsDD.getWarFile()).getFile()).getCanonicalFile().toURL();
                } else {
                    String ejb = new File(jarUrls[i].getFile()).getName();
                    String war = ejb.substring(0, ejb.length() - ".jar".length());
                    warURL = new File(new URL(unpackDir + File.separator + war + ".war").getFile()).getCanonicalFile().toURL();
                }
                logger.log(BasicLevel.DEBUG, (Object)("Unpack Dir : " + unpackDir));
                logger.log(BasicLevel.DEBUG, (Object)("Computed URL : " + warURL));
                boolean present = false;
                for (int w = 0; w < warUrls.length; ++w) {
                    if (warUrls[w].equals(warURL)) {
                        present = true;
                    }
                    logger.log(BasicLevel.DEBUG, (Object)("warUrls[" + w + "]=" + warUrls[w]));
                }
                webClassLoader = this.webService.getClassLoader(warURL, earAppName, ejbClassLoader);
                if (!present) {
                    String err = i18n.getMessage("AbsWebServicesServiceImpl.deployWebServices.webappNotFound", (Object)warURL);
                    logger.log(BasicLevel.ERROR, (Object)err);
                    throw new WSServiceException(err);
                }
            }
            catch (MalformedURLException mue) {
                String err = i18n.getMessage("AbsWebServicesServiceImpl.deployWebServices.mue");
                logger.log(BasicLevel.ERROR, (Object)mue.getMessage());
                throw new WSServiceException(err, (Throwable)mue);
            }
            catch (IOException ioe) {
                String err = "Cannot locate file : " + ioe.getMessage();
                logger.log(BasicLevel.ERROR, (Object)err);
                throw new WSServiceException(err, (Throwable)ioe);
            }
            try {
                compCtx = new ComponentContext(fileName);
                compCtx.rebind("wsDD", (Object)wsDD);
                compCtx.rebind("cl", (Object)webClassLoader);
                compCtx.rebind("earCL", (Object)earClassLoader);
                compCtx.rebind("warURL", (Object)warURL);
                compCtx.rebind("warContextRoot", warCtxRootMapping.get(warURL));
                this.doDeployWebServices((Context)compCtx);
                continue;
            }
            catch (NamingException ne) {
                String err = i18n.getMessage("AbsWebServicesServiceImpl.deployWebServices.bindError", (Object)fileName);
                logger.log(BasicLevel.ERROR, (Object)err);
                throw new WSServiceException(err, (Throwable)ne);
            }
        }
    }

    protected void doDeployWebServices(Context ctx) throws WSServiceException {
        Stack<WSDeployInfo> s;
        WSDeploymentDesc wsDD = null;
        ClassLoader cl = null;
        ClassLoader earCL = null;
        String warContextRoot = null;
        URL warURL = null;
        try {
            wsDD = (WSDeploymentDesc)ctx.lookup("wsDD");
            cl = (ClassLoader)ctx.lookup("cl");
            warContextRoot = (String)ctx.lookup("warContextRoot");
            warURL = (URL)ctx.lookup("warURL");
        }
        catch (NamingException ne) {
            String err = i18n.getMessage("AbsWebServicesServiceImpl.doDeployWebServices.namingError");
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new WSServiceException(err, (Throwable)ne);
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Deploying WebServices for '" + warURL + "'"));
        }
        try {
            earCL = (ClassLoader)ctx.lookup("earCL");
        }
        catch (NamingException ne) {
            earCL = null;
        }
        ClassLoader key = cl;
        if (earCL != null) {
            key = earCL;
        }
        if ((s = (Stack<WSDeployInfo>)this.deployments.get(key)) == null) {
            s = new Stack<WSDeployInfo>();
            this.deployments.put(key, s);
        }
        s.push(new WSDeployInfo(warURL, wsDD));
        List sds = wsDD.getServiceDescs();
        for (ServiceDesc sd : sds) {
            WSDLFile wsdl = sd.getWSDL();
            for (PortComponentDesc pcd : sd.getPortComponents()) {
                QName portQName = pcd.getQName();
                URL endpoint = null;
                endpoint = pcd.hasJaxRpcImpl() ? this.getEndpointURL(wsDD, (JaxRpcPortComponentDesc)pcd, warURL, warContextRoot) : this.getEndpointURL(wsDD, (SSBPortComponentDesc)pcd, warURL, cl, earCL, warContextRoot);
                pcd.setEndpointURL(endpoint);
                wsdl.setLocation(portQName, endpoint);
                try {
                    InitialContext registry = new InitialContext();
                    Reference urlRef = new Reference(URL.class.getName(), URLFactory.class.getName(), null);
                    urlRef.add(new StringRefAddr("url", endpoint.toString()));
                    registry.rebind(pcd.getName(), (Object)urlRef);
                    logger.log(BasicLevel.DEBUG, (Object)("Bind updated URL (" + endpoint + ") in " + pcd.getName()));
                }
                catch (NamingException ne) {
                    throw new WSServiceException("Cannot bind updated URL for port-component '" + pcd.getName() + "'", (Throwable)ne);
                }
            }
            this.wsdlManager.publish(sd);
        }
    }

    private void addHandlerMBeansToPortComponent(PortComponent pcMBean, PortComponentDesc pcd) {
        for (HandlerDesc hd : pcd.getHandlers()) {
            Handler hMBean = BaseWebServicesService.createHandlerMBean(hd.getName(), pcMBean);
            hMBean.setClassname(hd.getHandlerClassName());
            hMBean.setName(hd.getName());
            List sh = hd.getSOAPHeaders();
            String[] headers = new String[sh.size()];
            int index = 0;
            Iterator j = sh.iterator();
            while (j.hasNext()) {
                headers[index++] = ((QName)j.next()).toString();
            }
            hMBean.setSoapHeaders(headers);
            List sr = hd.getSOAPRoles();
            hMBean.setSoapRoles(sr.toArray(new String[sr.size()]));
            hMBean.setInitParams(hd.getInitParams());
        }
    }

    private static Handler createHandlerMBean(String name, PortComponent parent) {
        Handler h = null;
        try {
            h = new Handler(WebServicesObjectName.handler(name, parent.getRealObjectName()).toString());
        }
        catch (MalformedObjectNameException e) {
            logger.log(BasicLevel.DEBUG, (Object)"Should never happen", (Throwable)e);
        }
        parent.addHandlerMBean(h);
        return h;
    }

    private static PortComponent createPortComponentMBean(String name, Service parent) {
        PortComponent pc = null;
        try {
            pc = new PortComponent(WebServicesObjectName.portComponent(name, parent.getRealObjectName()).toString());
        }
        catch (MalformedObjectNameException e) {
            logger.log(BasicLevel.DEBUG, (Object)"Should never happen", (Throwable)e);
        }
        return pc;
    }

    private static Service createServiceMBean(String name, ObjectName parent) {
        Service service = null;
        try {
            service = new Service(WebServicesObjectName.service(name, parent).toString());
        }
        catch (MalformedObjectNameException e) {
            logger.log(BasicLevel.DEBUG, (Object)"Should never happen", (Throwable)e);
        }
        return service;
    }

    private URL getEndpointURL(WSDeploymentDesc wsDD, JaxRpcPortComponentDesc jpcd, URL warURL, String contextRoot) throws WSServiceException {
        logger.log(BasicLevel.DEBUG, (Object)"get endpoint for JaxRpc Port Component");
        return this.getEndpointURL(wsDD, jpcd.getWebDesc(), warURL, contextRoot, (PortComponentDesc)jpcd);
    }

    private URL getEndpointURL(WSDeploymentDesc wsDD, SSBPortComponentDesc spcd, URL warURL, ClassLoader cl, ClassLoader earCL, String contextRoot) throws WSServiceException {
        logger.log(BasicLevel.DEBUG, (Object)"get endpoint for StatelessSessionBean Port Component");
        WebContainerDeploymentDesc webDD = null;
        try {
            webDD = WebManagerWrapper.getDeploymentDesc((URL)warURL, (ClassLoader)cl, (ClassLoader)earCL);
        }
        catch (WebContainerDeploymentDescException e) {
            String err = i18n.getMessage("AbsWebServicesServiceImpl.getEndpointURL.webDDException", (Object)warURL.getFile());
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new WSServiceException(err, (Throwable)e);
        }
        return this.getEndpointURL(wsDD, webDD, warURL, contextRoot, (PortComponentDesc)spcd);
    }

    private URL getEndpointURL(WSDeploymentDesc wsDD, WebContainerDeploymentDesc webDD, URL warURL, String warContextRoot, PortComponentDesc pcd) throws WSServiceException {
        String servletName = pcd.getSibLink();
        String pcName = pcd.getQName().getLocalPart();
        logger.log(BasicLevel.DEBUG, (Object)("SOAP Servlet name '" + servletName + "'"));
        String hostname = webDD.getHost();
        String port = webDD.getPort();
        String scheme = "http";
        String contextRoot = null;
        String mapping = null;
        contextRoot = wsDD.getContextRoot() != null && pcd instanceof SSBPortComponentDesc ? wsDD.getContextRoot() : BaseWebServicesService.getContextRoot(warContextRoot, webDD, warURL);
        boolean needPortName = true;
        if (pcd.getEndpointURI() != null) {
            mapping = pcd.getEndpointURI();
            needPortName = false;
        } else {
            mapping = this.getServletMapping(servletName, webDD);
        }
        String prefix = this.endpointURLPrefix;
        if (this.endpointURLPrefix == null || this.endpointURLPrefix.equals("")) {
            if (hostname == null) {
                try {
                    hostname = this.webService.getDefaultHost();
                }
                catch (JWebContainerServiceException e) {
                    String err = i18n.getMessage("AbsWebServicesServiceImpl.getEndpointURL.noDefaultHost", (Object)warURL.getFile());
                    logger.log(BasicLevel.ERROR, (Object)err);
                    throw new WSServiceException(err, (Throwable)e);
                }
            }
            if (port == null) {
                try {
                    port = this.webService.getDefaultHttpPort();
                    scheme = "http";
                }
                catch (JWebContainerServiceException e) {
                    try {
                        port = this.webService.getDefaultHttpsPort();
                        scheme = "https";
                    }
                    catch (JWebContainerServiceException e2) {
                        String err = i18n.getMessage("AbsWebServicesServiceImpl.getEndpointURL.noDefaultHTTPPort", (Object)warURL.getFile());
                        logger.log(BasicLevel.ERROR, (Object)err);
                        throw new WSServiceException(err, (Throwable)e2);
                    }
                }
            }
            port = port.equals("80") ? "" : ":" + port;
            prefix = scheme + "://" + hostname + port;
        }
        String url = null;
        if (needPortName) {
            String encodedPortName = null;
            try {
                encodedPortName = URLEncoder.encode(pcName, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                encodedPortName = pcName;
            }
            url = prefix + "/" + contextRoot + "/" + mapping + "/" + encodedPortName;
        } else {
            url = prefix + "/" + contextRoot + mapping;
        }
        URL endpoint = null;
        try {
            endpoint = new URL(url);
        }
        catch (MalformedURLException mue) {
            String err = i18n.getMessage("AbsWebServicesServiceImpl.getEndpointURL.endpointURLError", (Object)pcName, (Object)url);
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new WSServiceException(err, (Throwable)mue);
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Constructed URL for '" + pcName + "' : '" + endpoint + "'"));
        }
        return endpoint;
    }

    private static String getContextRoot(String ctxRoot, WebContainerDeploymentDesc webDD, URL warURL) {
        String file;
        String cRoot;
        String contextRoot = null;
        contextRoot = "".equals(ctxRoot) ? ((cRoot = webDD.getContextRoot()) == null ? ((file = new File(warURL.getFile()).getName()).toLowerCase().endsWith(".war") ? file.substring(0, file.length() - ".war".length()) : file.substring(0, file.length())) : cRoot) : ctxRoot;
        return contextRoot;
    }

    public void doStop() throws ServiceException {
    }

    public void doStart() throws ServiceException {
        WebServicesObjectName.setDomain(this.getDomainName());
        if (this.jmxService != null) {
            this.jmxService.loadDescriptors(this.getClass().getPackage().getName() + ".mbean", this.getClass().getClassLoader());
        }
    }

    private String getServletMapping(String servlet, WebContainerDeploymentDesc webDD) throws WSServiceException {
        List mappings = webDD.getServletMappings(servlet);
        logger.log(BasicLevel.DEBUG, (Object)("mapping : " + mappings));
        if (mappings == null) {
            String err = i18n.getMessage("AbsWebServicesServiceImpl.getServletMapping.noMapping", (Object)servlet);
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new WSServiceException(err);
        }
        if (mappings.size() != 1) {
            String err = i18n.getMessage("AbsWebServicesServiceImpl.getServletMapping.1mappingOnly", (Object)servlet);
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new WSServiceException(err);
        }
        String mapping = (String)mappings.get(0);
        StringTokenizer st = new StringTokenizer(mapping, "/");
        mapping = st.nextToken();
        return mapping;
    }

    public void removeCache(ClassLoader cl) {
        WSManagerWrapper.removeCache((ClassLoader)cl);
        this.removeDeploymentInfoStack(cl);
    }

    protected static I18n getI18n() {
        return i18n;
    }

    protected static Logger getLogger() {
        return logger;
    }

    public void completeWSDeployment(Context ctx) throws WSServiceException {
        ClassLoader cl = null;
        ObjectName parent = null;
        Boolean isInEar = Boolean.FALSE;
        try {
            cl = (ClassLoader)ctx.lookup("classloader");
            parent = (ObjectName)ctx.lookup("parentObjectName");
            isInEar = (Boolean)ctx.lookup("isInEar");
        }
        catch (NamingException ne) {
            throw new WSServiceException("Cannot retrieve 'classloader' from given Context", (Throwable)ne);
        }
        Stack s = this.getDeploymentInfoStack(cl);
        while (s != null && !s.empty()) {
            WSDeployInfo di = (WSDeployInfo)s.pop();
            URL warURL = di.getWarURL();
            WSDeploymentDesc wsdd = di.getDescriptor();
            ObjectName parentON = parent;
            if (isInEar.booleanValue()) {
                parentON = this.getParentModuleObjectName(parent, wsdd);
            }
            ArrayList<Service> webservices = new ArrayList<Service>();
            this.webservicesMBeans.put(warURL, webservices);
            ClassLoader web = this.webService.getContextLinkedClassLoader(warURL);
            Context c = this.naming.getComponentContext(web);
            if (c == null) {
                throw new WSServiceException("Cannot get Component Context from ClassLoader : " + web);
            }
            List sds = wsdd.getServiceDescs();
            for (ServiceDesc sd : sds) {
                Service serviceMBean = BaseWebServicesService.createServiceMBean(sd.getName(), parentON);
                serviceMBean.setName(sd.getName());
                serviceMBean.setMappingFilename(sd.getMappingFilename());
                serviceMBean.setWsdlFilename(sd.getWsdlFilename());
                webservices.add(serviceMBean);
                for (PortComponentDesc pcd : sd.getPortComponents()) {
                    ObjectName on;
                    Iterator<ObjectName> it;
                    try {
                        c.rebind("comp/jonas/" + pcd.getSibLink() + "/dd", (Object)sd);
                    }
                    catch (NamingException ne) {
                        throw new WSServiceException("Cannot bind ServiceDesc instance for servlet '" + sd.getName() + "'", (Throwable)ne);
                    }
                    PortComponent pcMBean = BaseWebServicesService.createPortComponentMBean(pcd.getName(), serviceMBean);
                    pcMBean.setEndpoint(pcd.getEndpointURL().toExternalForm());
                    pcMBean.setName(pcd.getName());
                    pcMBean.setServiceEndpointInterface(pcd.getServiceEndpointInterface().getName());
                    pcMBean.setWsdlPort(pcd.getQName().toString());
                    MBeanServer mbeanServer = this.jmxService.getJmxServer();
                    if (pcd.hasBeanImpl()) {
                        ObjectName ssbSearch = WebServicesObjectName.getStatelessSessionBeanQuery(parentON, pcd.getSibLink());
                        it = mbeanServer.queryNames(ssbSearch, null).iterator();
                        if (it.hasNext()) {
                            on = it.next();
                            pcMBean.setImplementationBean(on.toString());
                            serviceMBean.addPortComponentMBean(pcMBean);
                        } else {
                            logger.log(BasicLevel.WARN, (Object)("Cannot find the MBean for Stateless '" + pcd.getSibLink() + "'"));
                        }
                    } else {
                        ObjectName sSearch = WebServicesObjectName.getServletQuery(parentON, pcd.getSibLink());
                        it = mbeanServer.queryNames(sSearch, null).iterator();
                        if (it.hasNext()) {
                            on = it.next();
                            pcMBean.setImplementationBean(on.toString());
                            serviceMBean.addPortComponentMBean(pcMBean);
                        } else {
                            logger.log(BasicLevel.WARN, (Object)("Cannot find the MBean for Servlet '" + pcd.getSibLink() + "'"));
                        }
                    }
                    this.addHandlerMBeansToPortComponent(pcMBean, pcd);
                    serviceMBean.setWsdlURL(pcd.getEndpointURL().toExternalForm() + "?JWSDL");
                }
            }
            for (Service service : webservices) {
                service.register(this.jmxService);
            }
        }
    }

    private ObjectName getParentModuleObjectName(ObjectName parent, WSDeploymentDesc wsdd) {
        ObjectName result = null;
        ServiceDesc sd = (ServiceDesc)wsdd.getServiceDescs().iterator().next();
        PortComponentDesc pcd = (PortComponentDesc)sd.getPortComponents().iterator().next();
        String key = pcd.getSibLink();
        MBeanServer mbeanServer = this.jmxService.getJmxServer();
        if (pcd.hasBeanImpl()) {
            ObjectName ssbSearch = WebServicesObjectName.getStatelessSessionBeanQuery(parent, key);
            Iterator<ObjectName> it = mbeanServer.queryNames(ssbSearch, null).iterator();
            if (it.hasNext()) {
                ObjectName ssb = it.next();
                ObjectName emSearch = WebServicesObjectName.getEJBModule(parent, ssb.getKeyProperty("EJBModule"));
                Iterator<ObjectName> it1 = mbeanServer.queryNames(emSearch, null).iterator();
                result = it1.next();
            } else {
                logger.log(BasicLevel.WARN, (Object)("Cannot find EJBModule MBean containing SSB " + key));
                result = parent;
            }
        } else {
            ObjectName sSearch = WebServicesObjectName.getServletQuery(parent, key);
            Iterator<ObjectName> it = mbeanServer.queryNames(sSearch, null).iterator();
            if (it.hasNext()) {
                ObjectName servlet = it.next();
                ObjectName wmSearch = WebServicesObjectName.getWebModule(parent, servlet.getKeyProperty("WebModule"));
                Iterator<ObjectName> it1 = mbeanServer.queryNames(wmSearch, null).iterator();
                result = it1.next();
            } else {
                logger.log(BasicLevel.WARN, (Object)("Cannot find WebModule MBean containing Servlet " + key));
                result = parent;
            }
        }
        return result;
    }

    public Reference buildServiceRef(IServiceRefDesc rd, ClassLoader loader) throws NamingException {
        Reference ref = null;
        JServiceFactory factory = JServiceFactoryFinder.getJOnASServiceFactory();
        try {
            ref = factory.getServiceReference(rd, loader);
        }
        catch (Exception e1) {
            NamingException ne = new NamingException("Cannot get service Reference for " + rd.getServiceRefName());
            ne.initCause(e1);
            throw ne;
        }
        return ref;
    }

    private Stack getDeploymentInfoStack(ClassLoader key) {
        return (Stack)this.deployments.get(key);
    }

    private void removeDeploymentInfoStack(ClassLoader key) {
        this.deployments.remove(key);
    }

    public void undeployWebServices(Context ctx) throws WSServiceException {
        URL url = null;
        try {
            url = (URL)ctx.lookup("warURL");
        }
        catch (NamingException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        List ws = (List)this.webservicesMBeans.get(url);
        if (ws != null) {
            for (Service service : ws) {
                service.unregister(this.jmxService);
            }
        }
    }

    public boolean isAutoWsGenEngaged() {
        return this.autoWSGen;
    }

    public void setWebService(JWebContainerService webService) {
        this.webService = webService;
    }

    public void setJmxService(JmxService jmxService) {
        this.jmxService = jmxService;
    }

    public void setNaming(JNamingManager naming) {
        this.naming = naming;
    }

    public class WSDeployInfo {
        private URL war = null;
        private WSDeploymentDesc wsdd = null;

        public WSDeployInfo(URL war, WSDeploymentDesc wsdd) {
            this.war = war;
            this.wsdd = wsdd;
        }

        public URL getWarURL() {
            return this.war;
        }

        public WSDeploymentDesc getDescriptor() {
            return this.wsdd;
        }
    }
}

