/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.commands.check;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.ow2.jonas.lib.bootstrap.JProp;

public class CheckEnv {
    public static final int ENV_OK = 0;
    public static final int ENV_WARNING = 1;
    public static final int ENV_ERROR = 2;
    private static final int ENV_UNKNOWN = -1;
    private static int envStatus = -1;
    private static final String INSTALL_ROOT = "install.root";
    private static final String JONAS_BASE = "jonas.base";
    private static final String DBM_SERVICE = "dbm";
    private static final String JMS_SERVICE = "jms";
    private static final String RESOURCE_SERVICE = "resource";
    private static final String JORAM_RAR = "joram_for_jonas_ra";
    private static final String JORAM_RAR_ADMIN_CFG_FILE = "joramAdmin.xml";
    private static final String JORAM_RAR_ADMIN_CFG_FILE_DEPRECATED = "joram-admin.cfg";
    private static final String DATASOURCES = "jonas.service.dbm.datasources";
    private static final String DATASOURCE_CLASS_NAME = "datasource.classname";
    private static Hashtable classesToCheck = new Hashtable();

    private CheckEnv() {
    }

    public static int getStatus() {
        envStatus = 0;
        Enumeration cList = classesToCheck.keys();
        while (cList.hasMoreElements()) {
            String cname = (String)cList.nextElement();
            if (CheckEnv.classIsAccessible(cname)) continue;
            System.err.println("JOnAS environment ERROR: Classes of '" + classesToCheck.get(cname) + "' not accessible");
            System.err.println("(The JOnAS package is bad)");
            envStatus = 2;
        }
        try {
            String sRoot = System.getProperty(INSTALL_ROOT);
            if (sRoot == null) {
                System.err.println("JOnAS environment ERROR: 'install.root' system property not defined");
                envStatus = 2;
            } else {
                File fRoot = new File(sRoot);
                if (!fRoot.isDirectory()) {
                    System.err.println("JOnAS environment ERROR: Invalid 'JONAS_ROOT' value");
                    System.err.println("                         '" + sRoot + "' directory not exist");
                    envStatus = 2;
                } else {
                    System.out.println("");
                    System.out.println("- JONAS_ROOT value: ");
                    System.out.println("   " + sRoot);
                }
            }
        }
        catch (SecurityException e) {
            System.err.println("CheckEnv ERROR: Cannot get the 'install.root' system property (" + e + ")");
            envStatus = 2;
        }
        try {
            String sBase = System.getProperty(JONAS_BASE);
            if (sBase == null) {
                System.err.println("JOnAS environment ERROR: 'jonas.base' environment property not defined");
                envStatus = 2;
            } else {
                File fBase = new File(sBase);
                if (!fBase.isDirectory()) {
                    System.err.println("JOnAS environment ERROR: Invalid 'JOAS_BASE' value");
                    System.err.println("                         '" + sBase + "' directory not exist");
                    envStatus = 2;
                } else {
                    System.out.println("");
                    System.out.println("- JONAS_BASE value: ");
                    System.out.println("   " + sBase);
                }
            }
        }
        catch (SecurityException e) {
            System.err.println("CheckEnv ERROR: Cannot get the 'jonas.base' system property (" + e + ")");
            envStatus = 2;
        }
        int res = CheckEnv.checkJonasProperties();
        if (res != 0) {
            envStatus = res;
        }
        if (CheckEnv.getProperties("trace.properties") == null) {
            System.err.println("JOnAS environment ERROR: 'trace.properties' not accessible");
            envStatus = 2;
        }
        if (CheckEnv.getProperties("carol.properties") == null) {
            System.err.println("JOnAS environment ERROR: 'carol.properties' not accessible");
            envStatus = 2;
        }
        if ((res = CheckEnv.checkRealm()) != 0) {
            envStatus = res;
        }
        if ((res = CheckEnv.checkJoramRar()) != 0) {
            envStatus = res;
        }
        return envStatus;
    }

    public static void main(String[] args) {
        boolean isHelp = false;
        for (int argn = 0; argn < args.length; ++argn) {
            String arg = args[argn];
            if (!arg.equals("-help") && !arg.equals("-?")) continue;
            isHelp = true;
        }
        if (isHelp) {
            CheckEnv.usage();
            System.exit(0);
        }
        int status = CheckEnv.getStatus();
        System.out.println("");
        if (status == 0) {
            System.err.println("The JOnAS environment seems correct.");
            System.exit(0);
        } else if (status == 1) {
            System.err.println("WARNING: The JOnAS environment may be incomplete.");
            System.exit(1);
        } else if (status == 2) {
            System.err.println("ERROR: The JOnAS environment is NOT correct.");
            System.exit(2);
        }
    }

    static boolean classIsAccessible(String name) {
        try {
            Class.forName(name);
            return true;
        }
        catch (Exception e) {
            return false;
        }
        catch (Error e) {
            System.err.println(e);
            return false;
        }
    }

    static Properties getProperties(String name) {
        Properties props = null;
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
        if (is != null) {
            props = new Properties();
            try {
                props.load(is);
                System.out.println("");
                System.out.println("- Contents of '" + name + "':");
                if (props.isEmpty()) {
                    System.out.println("JOnAS environment ERROR :'" + name + "' is empty");
                    envStatus = 2;
                }
                System.out.println("  (" + Thread.currentThread().getContextClassLoader().getResource(name).toString() + ")");
                Enumeration<?> pList = props.propertyNames();
                while (pList.hasMoreElements()) {
                    String pname = (String)pList.nextElement();
                    System.out.println("   " + pname + " = " + props.getProperty(pname));
                }
            }
            catch (IOException e) {
                props = null;
            }
        } else {
            props = null;
        }
        return props;
    }

    private static void usage() {
        System.out.println("");
        System.out.println("Usage: CheckEnv [ -help | -? ]");
        System.out.println("    to print this help message");
        System.out.println("");
        System.out.println("or     CheckEnv");
        System.out.println("    to check if the JOnAS environment is correct or not,");
        System.out.println("    and to display the content of the configuration files.");
        System.out.println("");
    }

    /*
     * WARNING - bad return control flow
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int checkJonasProperties() {
        try {
            boolean isServiceDbm = false;
            JProp jonasProps = JProp.getInstance();
            System.out.println("");
            System.out.println("- JOnAS Services:");
            System.out.println("   " + jonasProps.getValue("jonas.services", "none"));
            String[] services = jonasProps.getValueAsArray("jonas.services");
            if (services != null) {
                for (int i = 0; i < services.length; ++i) {
                    String serviceClass;
                    if (DBM_SERVICE.equals(services[i])) {
                        isServiceDbm = true;
                    }
                    if ((serviceClass = jonasProps.getValue("jonas.service." + services[i] + ".class")) == null) {
                        System.err.println("JOnAS environment ERROR: 'jonas.service." + services[i] + ".class' property not defined");
                        return 2;
                    }
                    if (CheckEnv.classIsAccessible(serviceClass)) continue;
                    System.err.println("JOnAS environment ERROR: '" + serviceClass + "' class not accessible ('" + services[i] + "' service class)");
                    return 2;
                }
            } else {
                System.err.println("JOnAS environment ERROR: jonas.services not defined in jonas.properties");
                return 2;
            }
            System.out.println("");
            System.out.println("- Contents of 'jonas.properties':");
            String jonasContent = jonasProps.toString();
            if (jonasContent.length() <= 0) {
                System.err.println("JOnAS environment ERROR : jonas.properties empty");
                return 2;
            }
            System.out.println(jonasProps.toString());
            if (!isServiceDbm) return 0;
            String dsList = jonasProps.getValue(DATASOURCES, "");
            StringTokenizer st = new StringTokenizer(dsList, ",");
            String dsName = null;
            while (st.hasMoreTokens()) {
                try {
                    dsName = st.nextToken().trim();
                    JProp dsProps = JProp.getInstance((String)dsName);
                    System.out.println("");
                    System.out.println("- Contents of '" + dsName + ".properties':");
                    System.out.println(dsProps.toString());
                    String driverName = dsProps.getValue(DATASOURCE_CLASS_NAME, "");
                    if (CheckEnv.classIsAccessible(driverName)) continue;
                    System.err.println("JOnAS environment ERROR: '" + driverName + "' class not accessible ('" + dsName + "' datasource's driver)");
                    return 2;
                }
                catch (Exception e) {
                    System.err.println("JOnAS environment ERROR: '" + dsName + ".properties' " + "not available in JONAS_BASE/conf");
                    return 2;
                    return 0;
                }
            }
        }
        catch (Exception e) {
            System.err.println("JOnAS environment ERROR: 'jonas.properties' not accessible (" + e + ")");
            return 2;
        }
    }

    private static int checkRealm() {
        System.out.println("\n- Check 'jonas-realm.xml':");
        try {
            String jonasBase = JProp.getJonasBase();
            File f = new File(jonasBase + File.separator + "conf" + File.separator + "jonas-realm.xml");
            if (!f.exists()) {
                System.err.println("The file jonas-realm.xml was not found in your JONAS_BASE/conf directory");
                return 2;
            }
            System.out.println("  File is present.");
            return 0;
        }
        catch (Exception fe) {
            System.err.println("Error while checking the jonas-realm.xml file : " + fe.getMessage());
            return 2;
        }
    }

    private static int checkJoramRar() {
        int i;
        String jonasBase;
        JProp jonasProps;
        boolean isJoramRarAutoloadedFromAutoloadDir;
        boolean isJoramRarAutoloadedFromJprop;
        boolean isServiceResource;
        boolean isServiceJms;
        block27: {
            block26: {
                isServiceJms = false;
                isServiceResource = false;
                isJoramRarAutoloadedFromJprop = false;
                isJoramRarAutoloadedFromAutoloadDir = false;
                jonasProps = null;
                jonasBase = null;
                System.out.println("\n- Check 'JORAM configuration':");
                try {
                    jonasProps = JProp.getInstance();
                }
                catch (Exception e) {
                    System.err.println("JOnAS environment ERROR: 'jonas.properties' not accessible (" + e + ")");
                    return 2;
                }
                try {
                    String[] services = jonasProps.getValueAsArray("jonas.services");
                    if (services != null) {
                        for (i = 0; i < services.length; ++i) {
                            if (JMS_SERVICE.equals(services[i])) {
                                isServiceJms = true;
                            }
                            if (!RESOURCE_SERVICE.equals(services[i])) continue;
                            isServiceResource = true;
                        }
                        break block26;
                    }
                    System.err.println("JOnAS environment ERROR: jonas.services not defined in jonas.properties");
                    return 2;
                }
                catch (Exception e) {
                    System.err.println("JOnAS environment ERROR: 'jonas.properties' not accessible (" + e + ")");
                    return 2;
                }
            }
            try {
                String[] resources = jonasProps.getValueAsArray("jonas.service.resource.resources");
                if (resources != null) {
                    for (i = 0; i < resources.length; ++i) {
                        if (JORAM_RAR.equals(resources[i])) {
                            isJoramRarAutoloadedFromJprop = true;
                        }
                        if (!"joram_for_jonas_ra.rar".equals(resources[i])) continue;
                        isJoramRarAutoloadedFromJprop = true;
                    }
                    break block27;
                }
                System.err.println("JOnAS environment ERROR: jonas.service.resource.resources not defined in jonas.properties");
                return 2;
            }
            catch (Exception e) {
                System.err.println("JOnAS environment ERROR: 'jonas.service.resource.resources' not accessible (" + e + ")");
                return 2;
            }
        }
        String[] resourcesAutoloadDir = null;
        try {
            resourcesAutoloadDir = jonasProps.getValueAsArray("jonas.service.resource.autoloaddir");
        }
        catch (Exception e) {
            System.err.println("JOnAS environment ERROR: 'jonas.service.resource.autoloaddir' not accessible (" + e + ")");
            return 2;
        }
        jonasBase = JProp.getJonasBase();
        if (resourcesAutoloadDir != null) {
            for (i = 0; i < resourcesAutoloadDir.length; ++i) {
                File dir = new File(jonasBase + File.separator + "rars" + File.separator + resourcesAutoloadDir[i]);
                if (!dir.exists() || !dir.isDirectory()) {
                    System.err.println("JOnAS environment ERROR: 'resource service configuration error' - " + dir.getName() + " access error");
                    return 2;
                }
                File[] files = dir.listFiles();
                for (int j = 0; j < files.length; ++j) {
                    if (!"joram_for_jonas_ra.rar".equals(files[j].getName())) continue;
                    isJoramRarAutoloadedFromAutoloadDir = true;
                }
            }
        } else {
            System.err.println("JOnAS environment ERROR: jonas.service.resource.autoloaddir not defined in jonas.properties");
            return 2;
        }
        if (isJoramRarAutoloadedFromJprop && isJoramRarAutoloadedFromAutoloadDir) {
            System.err.println("JOnAS environment ERROR: joram rar loaded twice in conf : jonas.properties and resource.autoloaddir");
            return 2;
        }
        if (isServiceJms && isServiceResource && (isJoramRarAutoloadedFromJprop || isJoramRarAutoloadedFromAutoloadDir)) {
            System.err.println("JOnAS environment ERROR: joram rar and jms service must be exclusive'");
            return 2;
        }
        if (isServiceResource) {
            try {
                File NewJoramAdminCfgFile = new File(jonasBase + File.separator + "conf" + File.separator + JORAM_RAR_ADMIN_CFG_FILE);
                File DepJoramAdminCfgFile = new File(jonasBase + File.separator + "conf" + File.separator + JORAM_RAR_ADMIN_CFG_FILE_DEPRECATED);
                if (!NewJoramAdminCfgFile.exists()) {
                    System.err.println("The file joramAdmin.xml was not found in your JONAS_BASE/conf directory");
                    return 2;
                }
                if (DepJoramAdminCfgFile.exists()) {
                    System.err.println("The file joram-admin.cfg was found in your JONAS_BASE/conf directory and may cause confusing with the joramAdmin.xmlfile.");
                    return 2;
                }
            }
            catch (Exception fe) {
                System.err.println("Error while checking the JORAM RA's configuration files : " + fe.getMessage());
                return 2;
            }
        }
        System.out.println("Ok");
        return 0;
    }

    static {
        classesToCheck.put("javax.ejb.EnterpriseBean", "ejb-2_1-api.jar");
        classesToCheck.put("javax.sql.DataSource", "jdbc2_0-stdext.jar");
        classesToCheck.put("javax.transaction.UserTransaction", "jta-spec1_0_1.jar");
        classesToCheck.put("javax.jms.Message", "jms.jar");
        classesToCheck.put("org.apache.regexp.REUtil", "jakarta-regexp-1.2.jar");
        classesToCheck.put("org.objectweb.joram.mom.dest.Topic", "joram-mom.jar");
        classesToCheck.put("org.objectweb.transaction.jta.TMService", "jotm.jar");
    }
}

