/*
 * Decompiled with CFR 0.152.
 */
package com.scalagent.joram.mom.dest.ftp;

import com.scalagent.joram.mom.dest.ftp.FtpMessage;
import com.scalagent.joram.mom.dest.ftp.FtpNot;
import com.scalagent.joram.mom.dest.ftp.FtpThread;
import com.scalagent.joram.mom.dest.ftp.TransferItf;
import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.Debug;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.objectweb.joram.mom.dest.DeadMQueueImpl;
import org.objectweb.joram.mom.dest.QueueImpl;
import org.objectweb.joram.mom.notifications.ClientMessages;
import org.objectweb.joram.shared.messages.Message;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class FtpQueueImpl
extends QueueImpl {
    private static final long serialVersionUID = 1L;
    public static Logger logger = Debug.getLogger(FtpQueueImpl.class.getName());
    private String user = "anonymous";
    private String pass = "no@no.no";
    private String path = null;
    private transient TransferItf transfer = null;
    private ClientMessages currentNot = null;
    private AgentId dmq = null;
    private int clientContext;
    private int requestId;
    public String ftpImplName = "com.scalagent.joram.mom.dest.ftp.TransferImplRef";
    private Hashtable transferTable;

    public FtpQueueImpl(AgentId destId, AgentId adminId, Properties prop) {
        super(destId, adminId, prop);
        this.setProperties(prop);
        this.transferTable = new Hashtable();
        try {
            if (this.ftpImplName != null && this.ftpImplName.length() > 0) {
                this.transfer = (TransferItf)Class.forName(this.ftpImplName).newInstance();
            }
        }
        catch (Exception exc) {
            this.transfer = null;
            logger.log(BasicLevel.ERROR, (Object)"FtpQueueImpl : transfer = null", (Throwable)exc);
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " transfer = " + this.transfer));
        }
    }

    protected void setProperties(Properties prop) {
        this.user = prop.getProperty("user", this.user);
        this.pass = prop.getProperty("pass", this.pass);
        this.path = prop.getProperty("path", this.path);
        this.ftpImplName = prop.getProperty("ftpImpl", this.ftpImplName);
    }

    public String toString() {
        return "FtpQueueImpl:" + this.destId.toString();
    }

    public void ftpNot(FtpNot not) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " ftpNot(" + not + ")\n" + "transferTable = " + this.transferTable));
        }
        Message msg = (Message)not.getMessages().get(0);
        this.storeMessage(new org.objectweb.joram.mom.messages.Message(msg));
        this.deliverMessages(0);
        this.transferTable.remove(new FtpMessage(msg).getIdentifier());
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " doProcess : transferTable = " + this.transferTable));
        }
    }

    public ClientMessages preProcess(AgentId from, ClientMessages not) {
        Enumeration msgs = not.getMessages().elements();
        while (msgs.hasMoreElements()) {
            Message msg = (Message)msgs.nextElement();
            if (!this.isFtpMsg(msg)) continue;
            this.doProcessFtp(not, msg);
            not.getMessages().remove(msg);
        }
        if (not.getMessages().size() > 0) {
            return not;
        }
        return null;
    }

    protected boolean isFtpMsg(Message message) {
        FtpMessage msg = new FtpMessage(message);
        return msg.propertyExists("url") && msg.propertyExists("crc") && msg.propertyExists("ack");
    }

    protected void doProcessFtp(ClientMessages not, Message msg) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " doProcessFtp(" + not + "," + msg + ")"));
        }
        if (this.transfer != null) {
            this.dmq = not.getDMQId();
            if (this.dmq == null && this.dmqId != null) {
                this.dmq = this.dmqId;
            } else if (this.dmq == null) {
                this.dmq = DeadMQueueImpl.getId();
            }
            this.clientContext = not.getClientContext();
            this.requestId = not.getRequestId();
            FtpMessage ftpMsg = new FtpMessage(msg);
            this.transferTable.put(ftpMsg.getIdentifier(), ftpMsg);
            FtpThread t = new FtpThread(this.transfer, (FtpMessage)ftpMsg.clone(), this.destId, this.dmq, this.clientContext, this.requestId, this.user, this.pass, this.path);
            t.start();
        } else {
            ClientMessages deadM = new ClientMessages(not.getClientContext(), not.getRequestId());
            msg.notWriteable = true;
            deadM.addMessage(msg);
            this.sendToDMQ(deadM, not.getDMQId());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            if (this.ftpImplName != null && this.ftpImplName.length() > 0) {
                this.transfer = (TransferItf)Class.forName(this.ftpImplName).newInstance();
            }
        }
        catch (Exception exc) {
            this.transfer = null;
            logger.log(BasicLevel.ERROR, (Object)"readObject : transfer = null", (Throwable)exc);
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " readObject transfer = " + this.transfer));
        }
        if (this.transfer != null) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " readObject : transferTable = " + this.transferTable));
            }
            Enumeration e = this.transferTable.elements();
            while (e.hasMoreElements()) {
                Message msg = (Message)e.nextElement();
                FtpMessage ftpMsg = new FtpMessage(msg);
                FtpThread t = new FtpThread(this.transfer, (FtpMessage)ftpMsg.clone(), this.destId, this.dmq, this.clientContext, this.requestId, this.user, this.pass, this.path);
                t.start();
            }
        }
    }
}

