/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.jndi2.impl;

import fr.dyade.aaa.jndi2.impl.ContextRecord;
import fr.dyade.aaa.jndi2.impl.NamingContextId;
import fr.dyade.aaa.jndi2.impl.ObjectRecord;
import fr.dyade.aaa.jndi2.impl.Record;
import fr.dyade.aaa.util.Strings;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.naming.Binding;
import javax.naming.NameClassPair;
import javax.naming.Reference;

public class NamingContext
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private NamingContextId id;
    private Object ownerId;
    private Vector records;
    static /* synthetic */ Class class$javax$naming$Context;

    public NamingContext(NamingContextId id, Object ownerId) {
        this.id = id;
        this.ownerId = ownerId;
        this.records = new Vector();
    }

    public final NamingContextId getId() {
        return this.id;
    }

    public final Object getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(Object ownerId) {
        this.ownerId = ownerId;
    }

    public Record getRecord(String name) {
        for (int i = 0; i < this.records.size(); ++i) {
            Record r = (Record)this.records.elementAt(i);
            if (!r.getName().equals(name)) continue;
            return r;
        }
        return null;
    }

    public Enumeration getEnumRecord() {
        Vector<Record> elt = new Vector<Record>();
        for (int i = 0; i < this.records.size(); ++i) {
            Record r = (Record)this.records.elementAt(i);
            elt.add(r);
        }
        return elt.elements();
    }

    public void addRecord(Record record) {
        this.records.addElement(record);
    }

    public boolean removeRecord(String name) {
        for (int i = 0; i < this.records.size(); ++i) {
            Record r = (Record)this.records.elementAt(i);
            if (!r.getName().equals(name)) continue;
            this.records.removeElementAt(i);
            return true;
        }
        return false;
    }

    public int size() {
        return this.records.size();
    }

    public NameClassPair[] getNameClassPairs() {
        NameClassPair[] res = new NameClassPair[this.records.size()];
        for (int i = 0; i < this.records.size(); ++i) {
            Record r = (Record)this.records.elementAt(i);
            if (r instanceof ObjectRecord) {
                ObjectRecord or = (ObjectRecord)r;
                res[i] = new NameClassPair(or.getName(), NamingContext.getClassName(or.getObject()), true);
                continue;
            }
            if (!(r instanceof ContextRecord)) continue;
            res[i] = new NameClassPair(r.getName(), (class$javax$naming$Context == null ? NamingContext.class$("javax.naming.Context") : class$javax$naming$Context).getName(), true);
        }
        return res;
    }

    public Binding[] getBindings() {
        Binding[] res = new Binding[this.records.size()];
        for (int i = 0; i < this.records.size(); ++i) {
            Record r = (Record)this.records.elementAt(i);
            if (r instanceof ObjectRecord) {
                ObjectRecord or = (ObjectRecord)r;
                res[i] = new Binding(or.getName(), NamingContext.getClassName(or.getObject()), or.getObject(), true);
                continue;
            }
            if (!(r instanceof ContextRecord)) continue;
            res[i] = new Binding(r.getName(), (class$javax$naming$Context == null ? NamingContext.class$("javax.naming.Context") : class$javax$naming$Context).getName(), null, true);
        }
        return res;
    }

    private static String getClassName(Object obj) {
        if (obj instanceof Reference) {
            Reference ref = (Reference)obj;
            return ref.getClassName();
        }
        return obj.getClass().getName();
    }

    public Object clone() {
        try {
            NamingContext clone = (NamingContext)super.clone();
            clone.records = (Vector)this.records.clone();
            return clone;
        }
        catch (CloneNotSupportedException exc) {
            return null;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append('(' + super.toString());
        buf.append(",id=" + this.id);
        buf.append(",ownerId=" + this.ownerId);
        buf.append(",records=");
        Strings.toString(buf, this.records);
        buf.append(')');
        return buf.toString();
    }
}

