/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.util;

import fr.dyade.aaa.agent.Debug;
import fr.dyade.aaa.util.DBOperation;
import fr.dyade.aaa.util.DBTransactionMBean;
import fr.dyade.aaa.util.Transaction;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public abstract class DBTransaction
implements Transaction,
DBTransactionMBean {
    protected static Logger logmon = null;
    File dir = null;
    private ThreadLocal perThreadContext = null;
    static int LogThresholdOperation = 1000;
    long startTime = 0L;
    protected Connection conn = null;
    private PreparedStatement insertStmt = null;
    private PreparedStatement updateStmt = null;
    private PreparedStatement deleteStmt = null;
    private int phase = 0;
    String phaseInfo = PhaseInfo[this.phase];
    private static final byte[] OOS_STREAM_HEADER = new byte[]{-84, -19, 0, 5};

    public int getLogThresholdOperation() {
        return LogThresholdOperation;
    }

    public long getStartTime() {
        return this.startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String path) throws IOException {
        this.phase = 0;
        logmon = Debug.getLogger("fr.dyade.aaa.agent.Transaction");
        if (logmon.isLoggable(BasicLevel.INFO)) {
            logmon.log(BasicLevel.INFO, (Object)"DBTransaction, init()");
        }
        this.dir = new File(path);
        if (!this.dir.exists()) {
            this.dir.mkdir();
        }
        if (!this.dir.isDirectory()) {
            throw new FileNotFoundException(path + " is not a directory.");
        }
        FilterOutputStream ldos = null;
        try {
            File tfc = new File(this.dir, "TFC");
            if (!tfc.exists()) {
                ldos = new DataOutputStream(new FileOutputStream(tfc));
                ((DataOutputStream)ldos).writeUTF(this.getClass().getName());
                ((DataOutputStream)ldos).flush();
            }
        }
        finally {
            if (ldos != null) {
                ldos.close();
            }
        }
        this.initDB();
        try {
            this.insertStmt = this.conn.prepareStatement("INSERT INTO JoramDB VALUES (?, ?)");
            this.updateStmt = this.conn.prepareStatement("UPDATE JoramDB SET content=? WHERE name=?");
            this.deleteStmt = this.conn.prepareStatement("DELETE FROM JoramDB WHERE name=?");
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw new IOException(sqle.getMessage());
        }
        this.perThreadContext = new ThreadLocal(){

            protected synchronized Object initialValue() {
                return new Context();
            }
        };
        this.startTime = System.currentTimeMillis();
        if (logmon.isLoggable(BasicLevel.INFO)) {
            logmon.log(BasicLevel.INFO, (Object)("DBTransaction, initialized " + this.startTime));
        }
        this.setPhase(1);
    }

    protected abstract void initDB() throws IOException;

    public final File getDir() {
        return this.dir;
    }

    public String getPersistenceDir() {
        return this.dir.getPath();
    }

    public int getPhase() {
        return this.phase;
    }

    public String getPhaseInfo() {
        return this.phaseInfo;
    }

    private final void setPhase(int newPhase) {
        this.phase = newPhase;
        this.phaseInfo = PhaseInfo[this.phase];
    }

    public final synchronized void begin() throws IOException {
        while (this.phase != 1) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.setPhase(2);
    }

    public final synchronized String[] getList(String prefix) {
        try {
            Statement s = this.conn.createStatement();
            ResultSet rs = s.executeQuery("SELECT name FROM JoramDB WHERE name LIKE '" + prefix + "%'");
            Vector<String> v = new Vector<String>();
            while (rs.next()) {
                v.add(rs.getString(1));
            }
            rs.close();
            s.close();
            String[] result = new String[v.size()];
            result = v.toArray(result);
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)("DBTransaction, getList: " + v));
            }
            return result;
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public boolean isPersistent() {
        return true;
    }

    final String fname(String dirName, String name) {
        if (dirName == null) {
            return name;
        }
        return dirName + '/' + name;
    }

    public final void create(Serializable obj, String name) throws IOException {
        this.save(obj, null, name);
    }

    public final void create(Serializable obj, String dirName, String name) throws IOException {
        this.save(obj, dirName, name);
    }

    public void save(Serializable obj, String dirName, String name) throws IOException {
        this.save(obj, this.fname(dirName, name));
    }

    public void save(Serializable obj, String name) throws IOException {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("DBTransaction, save(" + name + ")"));
        }
        Context ctx = (Context)this.perThreadContext.get();
        if (ctx.oos == null) {
            ctx.bos.reset();
            ctx.oos = new ObjectOutputStream(ctx.bos);
        } else {
            ctx.oos.reset();
            ctx.bos.reset();
            ctx.bos.write(OOS_STREAM_HEADER, 0, 4);
        }
        ctx.oos.writeObject(obj);
        ctx.oos.flush();
        this.saveInLog(ctx.bos.toByteArray(), name, ctx.log, false);
    }

    public void saveByteArray(byte[] buf, String dirName, String name) throws IOException {
        this.save((Serializable)buf, this.fname(dirName, name));
    }

    public void saveByteArray(byte[] buf, String name) throws IOException {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("DBTransaction, saveByteArray(" + name + ")"));
        }
        this.saveInLog(buf, name, ((Context)this.perThreadContext.get()).log, true);
    }

    private final void saveInLog(byte[] buf, String name, Hashtable log, boolean copy) throws IOException {
        DBOperation op = DBOperation.alloc(1, name, buf);
        DBOperation old = log.put(name, op);
        if (copy) {
            op.value = old != null && old.type == 1 && old.value.length == buf.length ? old.value : new byte[buf.length];
            System.arraycopy(buf, 0, op.value, 0, buf.length);
        }
        if (old != null) {
            old.free();
        }
    }

    public Object load(String dirName, String name) throws IOException, ClassNotFoundException {
        return this.load(this.fname(dirName, name));
    }

    public Object load(String name) throws IOException, ClassNotFoundException {
        byte[] buf = this.loadByteArray(name);
        if (buf != null) {
            ByteArrayInputStream bis = new ByteArrayInputStream(buf);
            ObjectInputStream ois = new ObjectInputStream(bis);
            return ois.readObject();
        }
        return null;
    }

    public byte[] loadByteArray(String dirName, String name) throws IOException {
        return this.loadByteArray(this.fname(dirName, name));
    }

    public synchronized byte[] loadByteArray(String name) throws IOException {
        Hashtable log;
        DBOperation op;
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("DBTransaction, loadByteArray(" + name + ")"));
        }
        if ((op = (DBOperation)(log = ((Context)this.perThreadContext.get()).log).get(name)) != null) {
            if (op.type == 1) {
                return op.value;
            }
            if (op.type == 2) {
                return null;
            }
        }
        try {
            Statement s = this.conn.createStatement();
            ResultSet rs = s.executeQuery("SELECT content FROM JoramDB WHERE name='" + name + "'");
            if (!rs.next()) {
                return null;
            }
            byte[] content = rs.getBytes(1);
            rs.close();
            s.close();
            return content;
        }
        catch (SQLException sqle) {
            throw new IOException(sqle.getMessage());
        }
    }

    public void delete(String dirName, String name) {
        this.delete(this.fname(dirName, name));
    }

    public void delete(String name) {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("DBTransaction, delete(" + name + ")"));
        }
        Hashtable log = ((Context)this.perThreadContext.get()).log;
        DBOperation op = DBOperation.alloc(2, name);
        if ((op = log.put(name, op)) != null) {
            op.free();
        }
    }

    public final synchronized void commit(boolean release) throws IOException {
        Hashtable log;
        if (this.phase != 2) {
            throw new IllegalStateException("Can not commit.");
        }
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)"DBTransaction, commit");
        }
        if (!(log = ((Context)this.perThreadContext.get()).log).isEmpty()) {
            DBOperation op = null;
            Enumeration e = log.elements();
            while (e.hasMoreElements()) {
                op = (DBOperation)e.nextElement();
                if (op.type == 1) {
                    if (logmon.isLoggable(BasicLevel.DEBUG)) {
                        logmon.log(BasicLevel.DEBUG, (Object)("DBTransaction, commit.save (" + op.name + ')'));
                    }
                    try {
                        this.insertStmt.setString(1, op.name);
                        this.insertStmt.setBytes(2, op.value);
                        this.insertStmt.executeUpdate();
                    }
                    catch (SQLException sqle1) {
                        try {
                            this.updateStmt.setBytes(1, op.value);
                            this.updateStmt.setString(2, op.name);
                            this.updateStmt.executeUpdate();
                        }
                        catch (SQLException sqle) {
                            throw new IOException(sqle.getMessage());
                        }
                    }
                } else if (op.type == 2) {
                    if (logmon.isLoggable(BasicLevel.DEBUG)) {
                        logmon.log(BasicLevel.DEBUG, (Object)("DBTransaction, commit.delete (" + op.name + ')'));
                    }
                    try {
                        this.deleteStmt.setString(1, op.name);
                        this.deleteStmt.executeUpdate();
                    }
                    catch (SQLException sqle) {
                        throw new IOException(sqle.getMessage());
                    }
                }
                op.free();
            }
            log.clear();
            try {
                this.conn.commit();
            }
            catch (SQLException sqle) {
                throw new IOException(sqle.getMessage());
            }
        }
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)"DBTransaction, committed");
        }
        if (release) {
            this.setPhase(1);
            this.notify();
        } else {
            this.setPhase(3);
        }
    }

    public final synchronized void release() throws IOException {
        if (this.phase != 2 && this.phase != 3 && this.phase != 4) {
            throw new IllegalStateException("Can not release transaction.");
        }
        this.setPhase(1);
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (logmon.isLoggable(BasicLevel.INFO)) {
            logmon.log(BasicLevel.INFO, (Object)"DBTransaction, stops");
        }
        while (this.phase != 1) {
            try {
                this.wait();
            }
            catch (InterruptedException exc) {}
        }
        this.setPhase(6);
        try {
            Statement s = this.conn.createStatement();
            this.conn.commit();
            logmon.log(BasicLevel.INFO, (Object)"DBTransaction, TBR stop#3");
            s.executeUpdate("SHUTDOWN COMPACT");
            logmon.log(BasicLevel.INFO, (Object)"DBTransaction, TBR stop#4");
            s.close();
            logmon.log(BasicLevel.INFO, (Object)"DBTransaction, TBR stop#5");
        }
        catch (SQLException sqle) {
            logmon.log(BasicLevel.ERROR, (Object)"DBTransaction, stop#6", (Throwable)sqle);
        }
        catch (Throwable t) {
            logmon.log(BasicLevel.ERROR, (Object)"DBTransaction, stop#7", t);
        }
        finally {
            logmon.log(BasicLevel.INFO, (Object)"DBTransaction, stop#8");
        }
        logmon.log(BasicLevel.INFO, (Object)"DBTransaction, TBR stop#9");
        this.setPhase(1);
        if (logmon.isLoggable(BasicLevel.INFO)) {
            logmon.log(BasicLevel.INFO, (Object)"NTransaction, stopped: ");
        }
    }

    public synchronized void close() {
        if (logmon.isLoggable(BasicLevel.INFO)) {
            logmon.log(BasicLevel.INFO, (Object)"DBTransaction, close");
        }
        if (this.phase == 0) {
            return;
        }
        while (this.phase != 1) {
            try {
                this.wait();
            }
            catch (InterruptedException exc) {}
        }
        this.setPhase(6);
        try {
            Statement s = this.conn.createStatement();
            s.execute("SHUTDOWN COMPACT");
            s.close();
        }
        catch (SQLException sqle) {
            logmon.log(BasicLevel.ERROR, (Object)"DBTransaction, close", (Throwable)sqle);
        }
        this.setPhase(0);
        if (logmon.isLoggable(BasicLevel.INFO)) {
            logmon.log(BasicLevel.INFO, (Object)"DBTransaction, closed: ");
        }
    }

    private class Context {
        Hashtable log = new Hashtable(15);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(256);
        ObjectOutputStream oos = null;

        Context() {
        }
    }
}

